/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.stackeditor.StackEditorManagerPlugin;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class EditStackAction
extends ListingContextAction {
    StackEditorManagerPlugin plugin;
    DataTypeManagerService dtmService;

    EditStackAction(StackEditorManagerPlugin plugin, DataTypeManagerService dtmService) {
        super("Edit Stack Frame", plugin.getName());
        this.plugin = plugin;
        this.dtmService = dtmService;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Edit Stack Frame"}, null, "Stack"));
        this.setHelpLocation(new HelpLocation("StackEditor", "Stack_Editor"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.getFunction(context);
        this.plugin.edit(function);
    }

    private Function getFunction(ListingActionContext context) {
        ProgramLocation loc = context.getLocation();
        Address address = context.getAddress();
        if (loc instanceof FunctionLocation) {
            FunctionLocation functionLocation = (FunctionLocation)loc;
            address = functionLocation.getFunctionAddress();
        }
        if (address == null) {
            return null;
        }
        return context.getProgram().getListing().getFunctionContaining(address);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        Function func = this.getFunction(context);
        if (func != null) {
            return !func.isExternal();
        }
        return false;
    }
}

