/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DataInCodeEntry;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataInCodeCommand
extends LinkEditDataCommand {
    private List<DataInCodeEntry> entries = new ArrayList<DataInCodeEntry>();

    DataInCodeCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        int i = 0;
        while ((long)(i + 8) <= this.datasize) {
            this.entries.add(new DataInCodeEntry(dataReader));
            i += 8;
        }
    }

    public List<DataInCodeEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        try {
            for (DataInCodeEntry entry : this.entries) {
                DataUtilities.createData((Program)program, (Address)addr, (DataType)entry.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add(8L);
            }
        }
        catch (Exception e) {
            log.appendMsg(DataInCodeCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }
}

