/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.quickfix;

import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GIcon;
import ghidra.docking.settings.Settings;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.util.exception.AssertException;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import resources.Icons;

public class QuickFixStatusRenderer
extends AbstractGhidraColumnRenderer<QuickFixStatus> {
    private static final Icon DONE_ICON = new GIcon("icon.base.plugin.quickfix.done");
    private static final Icon ERROR_ICON = Icons.ERROR_ICON;
    private static final Icon WARNING_ICON = Icons.WARNING_ICON;
    private static final Icon DELETE_ICON = Icons.DELETE_ICON;

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        QuickFixStatus status = (QuickFixStatus)((Object)data.getValue());
        Icon icon = this.getIcon(status);
        renderer.setIcon(icon);
        renderer.setText("");
        QuickFix rowObject = (QuickFix)data.getRowObject();
        renderer.setToolTipText(rowObject.getStatusMessage());
        return renderer;
    }

    private Icon getIcon(QuickFixStatus status) {
        switch (status) {
            case DONE: {
                return DONE_ICON;
            }
            case WARNING: 
            case CHANGED: {
                return WARNING_ICON;
            }
            case ERROR: {
                return ERROR_ICON;
            }
            case DELETED: {
                return DELETE_ICON;
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertException("Unexpected QuickFix status: " + String.valueOf((Object)status));
    }

    public String getFilterString(QuickFixStatus t, Settings settings) {
        return t.toString();
    }
}

