/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.data.PointerDBAdapterV0;
import ghidra.program.database.data.PointerDBAdapterV1;
import ghidra.program.database.data.PointerDBAdapterV2;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class PointerDBAdapter
implements RecordTranslator {
    static final String POINTER_TABLE_NAME = "Pointers";
    static final Schema SCHEMA = new Schema(2, "Pointer ID", new Field[]{LongField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE}, new String[]{"Data Type ID", "Category ID", "Length"});
    static final int PTR_DT_ID_COL = 0;
    static final int PTR_CATEGORY_COL = 1;
    static final int PTR_LENGTH_COL = 2;

    PointerDBAdapter() {
    }

    static PointerDBAdapter getAdapter(DBHandle handle, OpenMode openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == OpenMode.CREATE) {
            return new PointerDBAdapterV2(handle, tablePrefix, true);
        }
        try {
            return new PointerDBAdapterV2(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            PointerDBAdapter adapter = PointerDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == OpenMode.UPGRADE) {
                adapter = PointerDBAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    static PointerDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new PointerDBAdapterV1(handle);
        }
        catch (VersionException e) {
            return new PointerDBAdapterV0(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PointerDBAdapter upgrade(DBHandle handle, PointerDBAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        PointerDBAdapterV2 tmpAdapter = null;
        try {
            tmpAdapter = new PointerDBAdapterV2(tmpHandle, tablePrefix, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((PointerDBAdapter)tmpAdapter).updateRecord(rec);
            }
            oldAdapter.deleteTable(handle);
            PointerDBAdapterV2 newAdapter = new PointerDBAdapterV2(handle, tablePrefix, true);
            it = ((PointerDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((PointerDBAdapter)newAdapter).updateRecord(rec);
            }
            PointerDBAdapterV2 pointerDBAdapterV2 = newAdapter;
            return pointerDBAdapterV2;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract DBRecord createRecord(long var1, long var3, int var5) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    public abstract int getRecordCount();
}

