/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPointerTypedefBuiltIn
extends BuiltIn
implements TypeDef {
    private String typedefName;
    private TypedefDataType modelTypedef;
    private UniversalID universalId = UniversalIdGenerator.nextID();

    protected AbstractPointerTypedefBuiltIn(String name, DataType referencedDataType, int pointerSize, DataTypeManager dtm) {
        super(AbstractPointerTypedefBuiltIn.getCategoryPath(referencedDataType), AbstractPointerTypedefBuiltIn.getTempNameIfNeeded(name), dtm);
        this.setTypedefName(name);
        this.modelTypedef = new TypedefDataType("TEMP", new PointerDataType(referencedDataType, pointerSize, dtm));
        this.setDefaultSettings(this.modelTypedef.getDefaultSettings());
    }

    protected AbstractPointerTypedefBuiltIn(String name, Pointer pointerDataType, DataTypeManager dtm) {
        super(pointerDataType.getCategoryPath(), AbstractPointerTypedefBuiltIn.getTempNameIfNeeded(name), dtm);
        this.setTypedefName(name);
        this.modelTypedef = new TypedefDataType("TEMP", pointerDataType.clone(dtm));
        this.setDefaultSettings(this.modelTypedef.getDefaultSettings());
    }

    @Override
    public void enableAutoNaming() {
        this.typedefName = null;
    }

    @Override
    public boolean isAutoNamed() {
        return this.typedefName == null;
    }

    private static CategoryPath getCategoryPath(DataType referencedDataType) {
        return referencedDataType != null ? referencedDataType.getCategoryPath() : CategoryPath.ROOT;
    }

    private static String getTempNameIfNeeded(String baseName) {
        return StringUtils.isBlank((CharSequence)baseName) ? "TEMP" : baseName;
    }

    protected DataType getReferencedDataType() {
        Pointer ptrType = (Pointer)this.getDataType();
        return ptrType.getDataType();
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalId;
    }

    protected boolean hasGeneratedNamed() {
        return this.typedefName == null;
    }

    void setTypedefName(String name) {
        if (name != null && !DataUtilities.isValidDataTypeName(name)) {
            throw new IllegalArgumentException("Invalid DataType name: " + name);
        }
        this.typedefName = name;
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeDef)) {
            return false;
        }
        TypeDef td = (TypeDef)obj;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getName(), td.getName())) {
            return false;
        }
        if (!this.hasSameTypeDefSettings(td)) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), td.getDataType());
    }

    @Override
    public String getName() {
        if (this.typedefName == null) {
            return TypedefDataType.generateTypedefName(this);
        }
        return this.typedefName;
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.modelTypedef.hasLanguageDependantLength();
    }

    @Override
    public int getLength() {
        return this.modelTypedef.getLength();
    }

    @Override
    public int getAlignedLength() {
        return this.modelTypedef.getAlignedLength();
    }

    @Override
    public DataType getDataType() {
        return this.modelTypedef.getDataType();
    }

    @Override
    public DataType getBaseDataType() {
        return this.modelTypedef.getBaseDataType();
    }

    @Override
    public SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return this.modelTypedef.getSettingsDefinitions();
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": typedef " + this.getName() + " " + this.getDataType().getName();
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        if (settings == null) {
            settings = this.getDefaultSettings();
        }
        return this.modelTypedef.getValueClass(settings);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        if (settings == null) {
            settings = this.getDefaultSettings();
        }
        return this.modelTypedef.getValue(buf, settings, length);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (settings == null) {
            settings = this.getDefaultSettings();
        }
        return this.modelTypedef.getRepresentation(buf, settings, length);
    }
}

