/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CategoryPath
implements Comparable<CategoryPath> {
    public static final char DELIMITER_CHAR = '/';
    public static final String DELIMITER_STRING = "/";
    public static final String ESCAPED_DELIMITER_STRING = "\\/";
    public static final CategoryPath ROOT = new CategoryPath();
    private static final String ILLEGAL_STRING = "//";
    private static final int DIFF = "\\/".length() - "/".length();
    private final CategoryPath parent;
    private final String name;

    public static String escapeString(String nonEscapedString) {
        return nonEscapedString.replace(DELIMITER_STRING, ESCAPED_DELIMITER_STRING);
    }

    public static String unescapeString(String escapedString) {
        return escapedString.replace(ESCAPED_DELIMITER_STRING, DELIMITER_STRING);
    }

    private CategoryPath() {
        this.parent = null;
        this.name = "";
    }

    public CategoryPath(CategoryPath parent, String ... subPathElements) {
        this(parent, Arrays.asList(subPathElements));
    }

    public CategoryPath(CategoryPath parent, List<String> subPathElements) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent category must not be null!");
        }
        if (CollectionUtils.isEmpty(subPathElements)) {
            throw new IllegalArgumentException("Category list must contain at least one string name!");
        }
        this.name = subPathElements.get(subPathElements.size() - 1);
        if (this.name == null) {
            throw new IllegalArgumentException("A category element must not be null!");
        }
        this.parent = subPathElements.size() == 1 ? parent : new CategoryPath(parent, subPathElements.subList(0, subPathElements.size() - 1));
    }

    public CategoryPath extend(String ... subPathElements) {
        if (ArrayUtils.isEmpty((Object[])subPathElements)) {
            return this;
        }
        return new CategoryPath(this, subPathElements);
    }

    public CategoryPath extend(List<String> subPathElements) {
        if (CollectionUtils.isEmpty(subPathElements)) {
            return this;
        }
        return new CategoryPath(this, subPathElements);
    }

    public CategoryPath(String path) {
        if (path == null || path.length() == 0 || path.equals(DELIMITER_STRING)) {
            this.parent = null;
            this.name = "";
            return;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Paths must start with /");
        }
        if (this.endsWithNonEscapedDelimiter(path)) {
            throw new IllegalArgumentException("Paths must not end with /");
        }
        if (path.indexOf(ILLEGAL_STRING) >= 0) {
            throw new IllegalArgumentException("Paths must have non-empty elements");
        }
        int delimiterIndex = this.findIndexOfLastNonEscapedDelimiter(path);
        this.parent = new CategoryPath(path.substring(0, delimiterIndex));
        this.name = CategoryPath.unescapeString(path.substring(delimiterIndex + 1));
    }

    private boolean endsWithNonEscapedDelimiter(String string) {
        return string.charAt(string.length() - 1) == '/' && string.lastIndexOf(ESCAPED_DELIMITER_STRING) != string.length() - ESCAPED_DELIMITER_STRING.length();
    }

    private int findIndexOfLastNonEscapedDelimiter(String string) {
        int escapedIndex;
        int delimiterIndex = escapedIndex = string.length();
        while (delimiterIndex > 0) {
            escapedIndex = string.lastIndexOf(ESCAPED_DELIMITER_STRING, escapedIndex - 1);
            if ((delimiterIndex = string.lastIndexOf(47, delimiterIndex - 1)) == escapedIndex + DIFF) continue;
            break;
        }
        return delimiterIndex;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public CategoryPath getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        if (this.isRoot()) {
            return DELIMITER_STRING;
        }
        return this.parent.getPath(this.name);
    }

    public String getPath(String childName) {
        if (StringUtils.isBlank((CharSequence)childName)) {
            throw new IllegalArgumentException("blank child name");
        }
        Object path = this.getPath();
        if (!this.isRoot()) {
            path = (String)path + DELIMITER_STRING;
        }
        path = (String)path + CategoryPath.escapeString(childName);
        return path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryPath other = (CategoryPath)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean isAncestorOrSelf(CategoryPath candidateAncestorPath) {
        if (candidateAncestorPath.isRoot()) {
            return true;
        }
        CategoryPath path = this;
        while (!path.isRoot()) {
            if (candidateAncestorPath.equals(path)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    public String[] getPathElements() {
        return this.asArray();
    }

    @Override
    public int compareTo(CategoryPath other) {
        if (this.isRoot()) {
            return other.isRoot() ? 0 : -1;
        }
        if (other.isRoot()) {
            return 1;
        }
        int result = this.parent.compareTo(other.getParent());
        if (result == 0) {
            result = this.name.compareTo(other.getName());
        }
        return result;
    }

    public String toString() {
        return this.getPath();
    }

    public List<String> asList() {
        if (this.isRoot()) {
            return new ArrayList<String>();
        }
        List<String> list = this.parent.asList();
        list.add(this.name);
        return list;
    }

    public String[] asArray() {
        List<String> list = this.asList();
        return list.toArray(new String[list.size()]);
    }
}

