/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;

public abstract class DataTypeConflictHandler {
    public static final DataTypeConflictHandler DEFAULT_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return ConflictResult.RENAME_AND_ADD;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return true;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return DEFAULT_SUBSEQUENT_HANDLER;
        }
    };
    private static final DataTypeConflictHandler DEFAULT_SUBSEQUENT_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return DEFAULT_HANDLER.resolveConflict(addedDataType, existingDataType);
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static DataTypeConflictHandler REPLACE_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return ConflictResult.REPLACE_EXISTING;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return true;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return SUBSEQUENT_REPLACE_HANDLER;
        }
    };
    private static final DataTypeConflictHandler SUBSEQUENT_REPLACE_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return REPLACE_HANDLER.resolveConflict(addedDataType, existingDataType);
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static final DataTypeConflictHandler KEEP_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            return ConflictResult.USE_EXISTING;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    public static final DataTypeConflictHandler REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER = new DataTypeConflictHandler(){

        private ConflictResult resolveConflictReplaceEmpty(DataType addedDataType, DataType existingDataType) {
            if (addedDataType.isNotYetDefined()) {
                return ConflictResult.USE_EXISTING;
            }
            if (existingDataType.isNotYetDefined()) {
                return ConflictResult.REPLACE_EXISTING;
            }
            return ConflictResult.RENAME_AND_ADD;
        }

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            if (addedDataType instanceof Structure ? existingDataType instanceof Structure : addedDataType instanceof Union && existingDataType instanceof Union) {
                return this.resolveConflictReplaceEmpty(addedDataType, existingDataType);
            }
            return ConflictResult.RENAME_AND_ADD;
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };
    static final DataTypeConflictHandler BUILT_IN_MANAGER_HANDLER = new DataTypeConflictHandler(){

        @Override
        public ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
            throw new UnsupportedOperationException("Built-in data-types may not be substantially changed while Ghidra is running");
        }

        @Override
        public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
            return false;
        }

        @Override
        public DataTypeConflictHandler getSubsequentHandler() {
            return this;
        }
    };

    public abstract ConflictResult resolveConflict(DataType var1, DataType var2);

    public abstract boolean shouldUpdate(DataType var1, DataType var2);

    public abstract DataTypeConflictHandler getSubsequentHandler();

    public static enum ConflictResult {
        RENAME_AND_ADD,
        USE_EXISTING,
        REPLACE_EXISTING;

    }

    public static enum ConflictResolutionPolicy {
        RENAME_AND_ADD{

            @Override
            public DataTypeConflictHandler getHandler() {
                return DEFAULT_HANDLER;
            }
        }
        ,
        USE_EXISTING{

            @Override
            public DataTypeConflictHandler getHandler() {
                return KEEP_HANDLER;
            }
        }
        ,
        REPLACE_EXISTING{

            @Override
            public DataTypeConflictHandler getHandler() {
                return REPLACE_HANDLER;
            }
        }
        ,
        REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD{

            @Override
            public DataTypeConflictHandler getHandler() {
                return REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER;
            }
        };


        public abstract DataTypeConflictHandler getHandler();
    }
}

