/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.AccessibleField;
import docking.widgets.fieldpanel.FieldDescriptionProvider;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleTextSequence;

public class AccessibleFieldPanelDelegate {
    private List<AccessibleLayout> accessibleLayouts;
    private int totalFieldCount;
    private AccessibleField[] fieldsCache;
    private FieldPanel panel;
    private FieldLocation cursorLoc;
    private int caretPos;
    private AccessibleField cursorField;
    private FieldDescriptionProvider fieldDescriber = (l, f) -> "";
    private AccessibleContext context;
    private String description;
    private FieldSelection currentSelection;

    public AccessibleFieldPanelDelegate(List<AnchoredLayout> layouts, AccessibleContext context, FieldPanel panel) {
        this.context = context;
        this.panel = panel;
        this.setLayouts(layouts);
    }

    public void setLayouts(List<AnchoredLayout> layouts) {
        this.totalFieldCount = 0;
        this.cursorField = null;
        this.accessibleLayouts = new ArrayList<AccessibleLayout>(layouts.size());
        for (AnchoredLayout layout : layouts) {
            AccessibleLayout accessibleLayout = new AccessibleLayout(layout, this.totalFieldCount);
            this.accessibleLayouts.add(accessibleLayout);
            this.totalFieldCount += layout.getNumFields();
        }
        this.fieldsCache = new AccessibleField[this.totalFieldCount];
        this.context.firePropertyChange("accessibleInvalidateChildren", null, this.panel);
        if (this.cursorLoc != null) {
            this.setCaret(this.cursorLoc, EventTrigger.GUI_ACTION);
        }
    }

    public void setCaret(FieldLocation newCursorLoc, EventTrigger trigger) {
        if (this.cursorField == null || !this.isSameField(this.cursorLoc, newCursorLoc)) {
            AccessibleTextSequence oldSequence = this.getAccessibleTextSequence(this.cursorField);
            this.cursorLoc = newCursorLoc;
            this.cursorField = this.getAccessibleField(newCursorLoc);
            AccessibleTextSequence newSequence = this.getAccessibleTextSequence(this.cursorField);
            String oldDescription = this.description;
            this.description = this.generateDescription();
            if (trigger == EventTrigger.GUI_ACTION) {
                this.context.firePropertyChange("AccessibleText", oldSequence, newSequence);
                this.context.firePropertyChange("AccessibleDescription", oldDescription, this.description);
            }
            if (this.currentSelection != null && this.currentSelection.contains(this.cursorLoc)) {
                this.updateCurrentFieldSelectedState(trigger);
            }
            this.caretPos = -1;
        }
        if (this.cursorField == null) {
            this.caretPos = 0;
            return;
        }
        int newCaretPos = this.cursorField.getTextOffset(newCursorLoc.getRow(), newCursorLoc.getCol());
        this.cursorField.setCaretPos(newCaretPos);
        if (newCaretPos != this.caretPos && trigger == EventTrigger.GUI_ACTION) {
            this.context.firePropertyChange("AccessibleCaret", this.caretPos, newCaretPos);
        }
        this.caretPos = newCaretPos;
        this.cursorLoc = newCursorLoc;
    }

    public void setSelection(FieldSelection currentSelection, EventTrigger trigger) {
        this.currentSelection = currentSelection;
        this.updateCurrentFieldSelectedState(trigger);
    }

    private void updateCurrentFieldSelectedState(EventTrigger trigger) {
        if (this.cursorField == null) {
            return;
        }
        boolean oldIsSelected = this.cursorField.isSelected();
        boolean newIsSelected = this.currentSelection != null && this.currentSelection.contains(this.cursorLoc);
        this.cursorField.setSelected(newIsSelected);
        if (oldIsSelected != newIsSelected && trigger == EventTrigger.GUI_ACTION) {
            this.context.firePropertyChange("AccessibleSelection", null, null);
        }
    }

    private String generateDescription() {
        Field field = this.cursorField != null ? this.cursorField.getField() : null;
        return this.fieldDescriber.getDescription(this.cursorLoc, field);
    }

    private AccessibleTextSequence getAccessibleTextSequence(AccessibleField field) {
        if (field == null) {
            return new AccessibleTextSequence(0, 0, "");
        }
        String text = field.getField().getText();
        return new AccessibleTextSequence(0, text.length(), text);
    }

    public int getCaretPosition() {
        return this.caretPos;
    }

    public int getCharCount() {
        return this.cursorField != null ? this.cursorField.getCharCount() : 0;
    }

    private boolean isSameField(FieldLocation loc1, FieldLocation loc2) {
        if (loc1.getIndex() != loc2.getIndex()) {
            return false;
        }
        return loc1.getFieldNum() == loc2.getFieldNum();
    }

    public AccessibleField getAccessibleField(int fieldNum) {
        if (fieldNum < 0 || fieldNum >= this.fieldsCache.length) {
            return null;
        }
        if (this.fieldsCache[fieldNum] == null) {
            this.fieldsCache[fieldNum] = this.createAccessibleField(fieldNum);
        }
        return this.fieldsCache[fieldNum];
    }

    public AccessibleField getAccessibleField(FieldLocation loc) {
        AccessibleLayout accessibleLayout = this.getAccessibleLayout(loc.getIndex());
        if (accessibleLayout != null) {
            return this.getAccessibleField(accessibleLayout.getStartingFieldNum() + loc.getFieldNum());
        }
        LayoutModel layoutModel = this.panel.getLayoutModel();
        Layout layout = layoutModel.getLayout(loc.getIndex());
        if (layout == null) {
            return null;
        }
        Field field = layout.getField(loc.getFieldNum());
        return new AccessibleField(field, this.panel, loc.getFieldNum(), null);
    }

    private AccessibleLayout getAccessibleLayout(BigInteger index) {
        if (this.accessibleLayouts == null) {
            return null;
        }
        int result = Collections.binarySearch(this.accessibleLayouts, index, Comparator.comparing(o -> {
            BigInteger bigInteger;
            if (o instanceof AccessibleLayout) {
                AccessibleLayout lh = (AccessibleLayout)o;
                bigInteger = lh.getIndex();
            } else {
                bigInteger = (BigInteger)o;
            }
            return bigInteger;
        }, BigInteger::compareTo));
        if (result < 0) {
            return null;
        }
        return this.accessibleLayouts.get(result);
    }

    private AccessibleField createAccessibleField(int fieldNum) {
        int result = Collections.binarySearch(this.accessibleLayouts, fieldNum, Comparator.comparingInt(o -> {
            int n;
            if (o instanceof AccessibleLayout) {
                AccessibleLayout lh = (AccessibleLayout)o;
                n = lh.getStartingFieldNum();
            } else {
                n = (Integer)o;
            }
            return n;
        }));
        if (result < 0) {
            result = -result - 2;
        }
        AccessibleLayout layout = this.accessibleLayouts.get(result);
        return layout.createAccessibleField(fieldNum);
    }

    public Rectangle getCharacterBounds(int index) {
        if (this.cursorField == null) {
            return null;
        }
        Point loc = this.cursorField.getLocation();
        Rectangle bounds = this.cursorField.getCharacterBounds(index);
        bounds.x += loc.x;
        bounds.y += loc.y;
        return bounds;
    }

    public int getIndexAtPoint(Point p) {
        if (this.cursorField == null) {
            return 0;
        }
        Rectangle bounds = this.cursorField.getBounds();
        if (!bounds.contains(p)) {
            return -1;
        }
        Point localPoint = new Point(p.x - bounds.x, p.y - bounds.y);
        return this.cursorField.getIndexAtPoint(localPoint);
    }

    public String getAtIndex(int part, int index) {
        if (this.cursorField == null) {
            return "";
        }
        return this.cursorField.getAtIndex(part, index);
    }

    public String getAfterIndex(int part, int index) {
        if (this.cursorField == null) {
            return "";
        }
        return this.cursorField.getAfterIndex(part, index);
    }

    public String getBeforeIndex(int part, int index) {
        if (this.cursorField == null) {
            return "";
        }
        return this.cursorField.getBeforeIndex(part, index);
    }

    public int getFieldCount() {
        return this.totalFieldCount;
    }

    public Accessible getAccessibleAt(Point p) {
        int result = Collections.binarySearch(this.accessibleLayouts, p.y, Comparator.comparingInt(o -> {
            int n;
            if (o instanceof AccessibleLayout) {
                AccessibleLayout lh = (AccessibleLayout)o;
                n = lh.getYpos();
            } else {
                n = (Integer)o;
            }
            return n;
        }));
        if (result < 0) {
            result = -result - 2;
        }
        if (result < 0 || result >= this.accessibleLayouts.size()) {
            return null;
        }
        int fieldNum = this.accessibleLayouts.get(result).getFieldNum(p);
        return this.getAccessibleField(fieldNum);
    }

    public String getFieldDescription() {
        return this.description;
    }

    public void setFieldDescriptionProvider(FieldDescriptionProvider provider) {
        this.fieldDescriber = provider;
    }

    public int getSelectionStart() {
        if (this.cursorField == null) {
            return 0;
        }
        return this.cursorField.getSelectionStart();
    }

    public int getSelectionEnd() {
        if (this.cursorField == null) {
            return 0;
        }
        return this.cursorField.getSelectionEnd();
    }

    public String getSelectedText() {
        if (this.cursorField == null) {
            return null;
        }
        return this.cursorField.getSelectedText();
    }

    private class AccessibleLayout {
        private AnchoredLayout layout;
        private int startingFieldNum;

        public AccessibleLayout(AnchoredLayout layout, int startingFieldNum) {
            this.layout = layout;
            this.startingFieldNum = startingFieldNum;
        }

        public AccessibleField createAccessibleField(int fieldNum) {
            int fieldNumInLayout = fieldNum - this.startingFieldNum;
            Field field = this.layout.getField(fieldNumInLayout);
            Rectangle fieldBounds = this.layout.getFieldBounds(fieldNumInLayout);
            return new AccessibleField(field, AccessibleFieldPanelDelegate.this.panel, fieldNum, fieldBounds);
        }

        public int getStartingFieldNum() {
            return this.startingFieldNum;
        }

        public int getFieldNum(Point p) {
            return this.layout.getFieldIndex(p.x, p.y) + this.startingFieldNum;
        }

        public int getYpos() {
            return this.layout.getYPos();
        }

        public BigInteger getIndex() {
            return this.layout.getIndex();
        }
    }
}

