/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import db.DBHandle;
import db.Transaction;
import generic.depends.DependentService;
import generic.depends.err.ServiceConstructionException;
import ghidra.framework.data.DBDomainObjectSupport;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.options.Options;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.database.DBTraceChangeSet;
import ghidra.trace.database.DBTraceDirectChangeListener;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.DBTraceTimeViewport;
import ghidra.trace.database.DBTraceUserData;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.address.TraceAddressFactory;
import ghidra.trace.database.bookmark.DBTraceBookmarkManager;
import ghidra.trace.database.breakpoint.DBTraceBreakpointManager;
import ghidra.trace.database.context.DBTraceRegisterContextManager;
import ghidra.trace.database.data.DBTraceDataSettingsAdapter;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.guest.DBTraceObjectRegisterSupport;
import ghidra.trace.database.guest.DBTracePlatformManager;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCommentAdapter;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.module.DBTraceModuleManager;
import ghidra.trace.database.module.DBTraceStaticMappingManager;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceVariableSnapProgramView;
import ghidra.trace.database.property.DBTraceAddressPropertyManager;
import ghidra.trace.database.stack.DBTraceStackManager;
import ghidra.trace.database.symbol.DBTraceEquateManager;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.database.time.DBTraceTimeManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceClosedException;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.util.CopyOnWrite;
import ghidra.trace.util.TraceChangeManager;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.database.DBCachedDomainObjectAdapter;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.apache.commons.collections4.collection.CompositeCollection;

public class DBTrace
extends DBCachedDomainObjectAdapter
implements Trace,
TraceChangeManager {
    protected static final String TRACE_INFO = "Trace Information";
    protected static final String NAME = "Name";
    protected static final String DATE_CREATED = "Date Created";
    protected static final String BASE_LANGUAGE = "Base Language";
    protected static final String BASE_COMPILER = "Base Compiler";
    protected static final String PLATFORM = "Platform";
    protected static final String EXECUTABLE_PATH = "Executable Location";
    protected static final String EMU_CACHE_VERSION = "Emulator Cache Version";
    protected static final int DB_TIME_INTERVAL = 500;
    protected static final int DB_BUFFER_SIZE = 1000;
    protected List<DBTraceManager> managers = new ArrayList<DBTraceManager>(20);
    @DependentService
    protected DBTraceAddressPropertyManager addressPropertyManager;
    @DependentService
    protected DBTraceBookmarkManager bookmarkManager;
    @DependentService
    protected DBTraceBreakpointManager breakpointManager;
    @DependentService
    protected DBTraceCodeManager codeManager;
    @DependentService
    protected DBTraceCommentAdapter commentAdapter;
    @DependentService
    protected DBTraceDataSettingsAdapter dataSettingsAdapter;
    @DependentService
    protected DBTraceDataTypeManager dataTypeManager;
    @DependentService
    protected DBTraceEquateManager equateManager;
    @DependentService
    protected DBTracePlatformManager platformManager;
    @DependentService
    protected DBTraceMemoryManager memoryManager;
    @DependentService
    protected DBTraceModuleManager moduleManager;
    @DependentService
    protected DBTraceObjectManager objectManager;
    @DependentService
    protected DBTraceOverlaySpaceAdapter overlaySpaceAdapter;
    @DependentService
    protected DBTraceReferenceManager referenceManager;
    @DependentService
    protected DBTraceRegisterContextManager registerContextManager;
    @DependentService
    protected DBTraceStackManager stackManager;
    @DependentService
    protected DBTraceStaticMappingManager staticMappingManager;
    @DependentService
    protected DBTraceSymbolManager symbolManager;
    @DependentService
    protected DBTraceThreadManager threadManager;
    @DependentService
    protected DBTraceTimeManager timeManager;
    private final DBCachedObjectStoreFactory storeFactory;
    protected Language baseLanguage;
    protected CompilerSpec baseCompilerSpec;
    protected TraceAddressFactory baseAddressFactory;
    protected DBTraceChangeSet traceChangeSet;
    protected boolean recordChanges = false;
    protected Set<DBTraceTimeViewport> viewports = new CopyOnWrite.WeakHashCowSet<DBTraceTimeViewport>();
    protected ListenerSet<DBTraceDirectChangeListener> directListeners = new ListenerSet(DBTraceDirectChangeListener.class, true);
    protected DBTraceVariableSnapProgramView programView;
    protected Set<DBTraceVariableSnapProgramView> programViews = new CopyOnWrite.WeakHashCowSet<DBTraceVariableSnapProgramView>();
    protected Set<TraceProgramView> programViewsView = Collections.unmodifiableSet(this.programViews);
    protected Map<Long, DBTraceProgramView> fixedProgramViews = new CopyOnWrite.WeakValueHashCowMap();
    protected ListenerSet<Trace.TraceProgramViewListener> viewListeners = new ListenerSet(Trace.TraceProgramViewListener.class, true);
    private volatile boolean closing;

    public DBTrace(String name, CompilerSpec baseCompilerSpec, Object consumer) throws IOException, LanguageNotFoundException {
        super(new DBHandle(), OpenMode.CREATE, TaskMonitor.DUMMY, name, 500, 1000, consumer);
        this.storeFactory = new DBCachedObjectStoreFactory((DBCachedDomainObjectAdapter)this);
        this.baseLanguage = baseCompilerSpec.getLanguage();
        this.baseCompilerSpec = this.baseLanguage.getCompilerSpecByID(baseCompilerSpec.getCompilerSpecID());
        this.baseAddressFactory = new TraceAddressFactory(this.baseLanguage, this.baseCompilerSpec, space -> this.getAddressSet(space));
        try (Transaction tx = this.openTransaction("Create");){
            this.initOptions(OpenMode.CREATE);
            this.init();
        }
        catch (CancelledException | VersionException e) {
            throw new AssertionError((Object)e);
        }
        catch (ServiceConstructionException e) {
            e.unwrap(LanguageNotFoundException.class);
            throw new AssertionError((Object)e);
        }
        this.clearUndo(false);
        this.traceChangeSet = new DBTraceChangeSet();
        this.changeSet = this.traceChangeSet;
        this.recordChanges = true;
        this.programView = this.createProgramView(0L);
    }

    private AddressSetView getAddressSet(OverlayAddressSpace space) {
        return new AddressSet(space.getMinAddress(), space.getMaxAddress());
    }

    public DBTrace(DBHandle dbh, OpenMode openMode, TaskMonitor monitor, Object consumer) throws CancelledException, VersionException, IOException, LanguageNotFoundException {
        super(dbh, openMode, monitor, "Untitled", 500, 1000, consumer);
        this.storeFactory = new DBCachedObjectStoreFactory((DBCachedDomainObjectAdapter)this);
        try (Transaction tx = this.openTransaction("Create");){
            this.initOptions(openMode);
            this.init();
        }
        catch (ServiceConstructionException e) {
            e.unwrap(LanguageNotFoundException.class);
            throw new AssertionError((Object)e);
        }
        this.clearUndo(false);
        this.traceChangeSet = new DBTraceChangeSet();
        this.changeSet = this.traceChangeSet;
        this.recordChanges = true;
        this.programView = this.createProgramView(0L);
    }

    protected void initOptions(OpenMode openMode) throws IOException, CancelledException {
        Options traceInfo = this.getOptions(TRACE_INFO);
        if (openMode == OpenMode.CREATE) {
            traceInfo.setString(NAME, this.name);
            traceInfo.setDate(DATE_CREATED, new Date());
            traceInfo.setString(BASE_LANGUAGE, this.baseLanguage.getLanguageID().getIdAsString());
            traceInfo.setString(BASE_COMPILER, this.baseCompilerSpec.getCompilerSpecID().getIdAsString());
        } else {
            this.name = traceInfo.getString(NAME, "Unnamed?");
            this.baseLanguage = DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(traceInfo.getString(BASE_LANGUAGE, null)));
            this.baseCompilerSpec = this.baseLanguage.getCompilerSpecByID(new CompilerSpecID(traceInfo.getString(BASE_COMPILER, null)));
            this.baseAddressFactory = new TraceAddressFactory(this.baseLanguage, this.baseCompilerSpec, space -> this.getAddressSet(space));
        }
    }

    public void dbError(IOException e) {
        if (e instanceof ClosedException) {
            throw new TraceClosedException(e);
        }
        super.dbError(e);
    }

    @Internal
    public void assertValidAddress(Address pc) {
        if (pc == null) {
            return;
        }
        this.assertValidSpace(pc.getAddressSpace());
    }

    @Internal
    public void assertValidSpace(AddressSpace as) {
        if (as == AddressSpace.OTHER_SPACE) {
            return;
        }
        if (as == Address.NO_ADDRESS.getAddressSpace()) {
            return;
        }
        if (this.baseAddressFactory.getAddressSpace(as.getSpaceID()) != as) {
            throw new IllegalArgumentException("AddressSpace '" + String.valueOf(as) + "' is not in this trace (language=" + String.valueOf(this.getBaseLanguage()) + ")");
        }
    }

    public DBTraceChangeSet getChangeSet() {
        return this.traceChangeSet;
    }

    public DBCachedObjectStoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public String getDescription() {
        return "Trace";
    }

    protected <T extends DBTraceManager> T createTraceManager(String managerName, DBDomainObjectSupport.ManagerSupplier<T> supplier) throws CancelledException, IOException {
        DBTraceManager manager = (DBTraceManager)this.createManager(managerName, supplier);
        this.managers.add(manager);
        return (T)manager;
    }

    @DependentService
    protected DBTraceAddressPropertyManager createAddressPropertyManager(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceAddressPropertyManager)this.createTraceManager("Address Property Manager", (openMode, monitor) -> new DBTraceAddressPropertyManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTraceBookmarkManager createBookmarkManager(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceBookmarkManager)this.createTraceManager("Bookmark Manager", (openMode, monitor) -> new DBTraceBookmarkManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTraceBreakpointManager createBreakpointManager(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceBreakpointManager)this.createTraceManager("Breakpoint Manager", (openMode, monitor) -> new DBTraceBreakpointManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTraceCodeManager createCodeManager(DBTraceThreadManager threadManager, DBTracePlatformManager platformManager, DBTraceDataTypeManager dataTypeManager, DBTraceOverlaySpaceAdapter overlayAdapter, DBTraceReferenceManager referenceManager) throws CancelledException, IOException {
        return (DBTraceCodeManager)this.createTraceManager("Code Manager", (openMode, monitor) -> new DBTraceCodeManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager, platformManager, dataTypeManager, overlayAdapter, referenceManager));
    }

    @DependentService
    protected DBTraceCommentAdapter createCommentAdapter(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceCommentAdapter)this.createTraceManager("Comment Adapter", (openMode, monitor) -> new DBTraceCommentAdapter(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTraceDataSettingsAdapter createDataSettingsAdapter(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceDataSettingsAdapter)this.createTraceManager("Data Settings Adapter", (openMode, monitor) -> new DBTraceDataSettingsAdapter(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTraceDataTypeManager createDataTypeManager(DBTracePlatformManager platformManager) throws CancelledException, IOException {
        return (DBTraceDataTypeManager)this.createTraceManager("Data Type Manager", (openMode, monitor) -> new DBTraceDataTypeManager(this.dbh, openMode, this.rwLock, monitor, this, platformManager.getHostPlatform()));
    }

    @DependentService
    protected DBTraceEquateManager createEquateManager(DBTraceThreadManager threadManager) throws CancelledException, IOException {
        return (DBTraceEquateManager)this.createTraceManager("Equate Manager", (openMode, monitor) -> new DBTraceEquateManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager));
    }

    @DependentService
    protected DBTracePlatformManager createPlatformManager() throws CancelledException, IOException {
        return (DBTracePlatformManager)this.createTraceManager("Platform Manager", (openMode, monitor) -> new DBTracePlatformManager(this.dbh, openMode, this.rwLock, monitor, this.baseCompilerSpec, this));
    }

    @DependentService
    protected DBTraceMemoryManager createMemoryManager(DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws IOException, CancelledException {
        return (DBTraceMemoryManager)this.createTraceManager("Memory Manager", (openMode, monitor) -> new DBTraceMemoryManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager, overlayAdapter));
    }

    @DependentService
    protected DBTraceModuleManager createModuleManager() throws CancelledException, IOException {
        return (DBTraceModuleManager)this.createTraceManager("Module Manager", (openMode, monitor) -> new DBTraceModuleManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this));
    }

    @DependentService
    protected DBTraceObjectManager createObjectManager() throws CancelledException, IOException {
        return (DBTraceObjectManager)this.createTraceManager("Object Manager", (openMode, monitor) -> new DBTraceObjectManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this));
    }

    @DependentService
    protected DBTraceOverlaySpaceAdapter createOverlaySpaceAdapter() throws CancelledException, IOException {
        return (DBTraceOverlaySpaceAdapter)this.createTraceManager("Overlay Space Adapter", (openMode, monitor) -> new DBTraceOverlaySpaceAdapter(this.dbh, openMode, this.rwLock, monitor, this));
    }

    @DependentService
    protected DBTraceReferenceManager createReferenceManager(DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws CancelledException, IOException {
        return (DBTraceReferenceManager)this.createTraceManager("Reference Manager", (openMode, monitor) -> new DBTraceReferenceManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager, overlayAdapter));
    }

    @DependentService
    protected DBTraceRegisterContextManager createRegisterContextManager(DBTraceThreadManager threadManager, DBTracePlatformManager platformManager) throws CancelledException, IOException {
        return (DBTraceRegisterContextManager)this.createTraceManager("Context Manager", (openMode, monitor) -> new DBTraceRegisterContextManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager, platformManager));
    }

    @DependentService
    protected DBTraceStackManager createStackManager(DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws CancelledException, IOException {
        return (DBTraceStackManager)this.createTraceManager("Stack Manager", (openMode, monitor) -> new DBTraceStackManager(this.dbh, openMode, this.rwLock, monitor, this, threadManager, overlayAdapter));
    }

    @DependentService
    protected DBTraceStaticMappingManager createStaticMappingManager(DBTraceOverlaySpaceAdapter overlayAdapter) throws CancelledException, IOException {
        return (DBTraceStaticMappingManager)this.createTraceManager("Static Mapping Manager", (openMode, monitor) -> new DBTraceStaticMappingManager(this.dbh, openMode, this.rwLock, monitor, this, overlayAdapter));
    }

    @DependentService
    protected DBTraceSymbolManager createSymbolManager(DBTraceThreadManager threadManager, DBTraceDataTypeManager dataTypeManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws CancelledException, IOException {
        return (DBTraceSymbolManager)this.createTraceManager("Symbol Manager", (openMode, monitor) -> new DBTraceSymbolManager(this.dbh, openMode, this.rwLock, monitor, this.baseLanguage, this, threadManager, dataTypeManager, overlayAdapter));
    }

    @DependentService
    protected DBTraceThreadManager createThreadManager(DBTraceObjectManager objectManager) throws IOException, CancelledException {
        return (DBTraceThreadManager)this.createTraceManager("Thread Manager", (openMode, monitor) -> new DBTraceThreadManager(this.dbh, openMode, this.rwLock, monitor, this, objectManager));
    }

    @DependentService
    protected DBTraceTimeManager createTimeManager(DBTraceThreadManager threadManager) throws IOException, CancelledException {
        return (DBTraceTimeManager)this.createTraceManager("Time Manager", (openMode, monitor) -> new DBTraceTimeManager(this.dbh, openMode, this.rwLock, monitor, this, threadManager));
    }

    @Override
    public Language getBaseLanguage() {
        return this.baseLanguage;
    }

    @Override
    public CompilerSpec getBaseCompilerSpec() {
        return this.baseCompilerSpec;
    }

    protected void setTraceUserData(DBTraceUserData traceUserData) {
    }

    protected void setChanged(boolean b) {
        super.setChanged(b);
    }

    public boolean isChangeable() {
        return true;
    }

    @Override
    public AddressFactory getBaseAddressFactory() {
        return this.baseAddressFactory;
    }

    @Internal
    public TraceAddressFactory getInternalAddressFactory() {
        return this.baseAddressFactory;
    }

    @Override
    public TraceAddressPropertyManager getAddressPropertyManager() {
        return this.addressPropertyManager.getApiPropertyManager();
    }

    @Internal
    public DBTraceAddressPropertyManager getInternalAddressPropertyManager() {
        return this.addressPropertyManager;
    }

    @Override
    public DBTraceBookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public DBTraceBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Override
    public DBTraceCodeManager getCodeManager() {
        return this.codeManager;
    }

    @Internal
    public DBTraceCommentAdapter getCommentAdapter() {
        return this.commentAdapter;
    }

    @Internal
    public DBTraceDataSettingsAdapter getDataSettingsAdapter() {
        return this.dataSettingsAdapter;
    }

    @Override
    public DBTraceDataTypeManager getBaseDataTypeManager() {
        return this.dataTypeManager;
    }

    @Override
    public DBTraceEquateManager getEquateManager() {
        return this.equateManager;
    }

    @Override
    public DBTracePlatformManager getPlatformManager() {
        return this.platformManager;
    }

    @Override
    public DBTraceMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public DBTraceModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public DBTraceObjectManager getObjectManager() {
        return this.objectManager;
    }

    @Internal
    public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
        return this.overlaySpaceAdapter;
    }

    @Override
    public DBTraceReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    @Override
    public DBTraceRegisterContextManager getRegisterContextManager() {
        return this.registerContextManager;
    }

    @Override
    public DBTraceStackManager getStackManager() {
        return this.stackManager;
    }

    @Override
    public DBTraceStaticMappingManager getStaticMappingManager() {
        return this.staticMappingManager;
    }

    @Override
    public DBTraceSymbolManager getSymbolManager() {
        return this.symbolManager;
    }

    @Override
    public DBTraceThreadManager getThreadManager() {
        return this.threadManager;
    }

    @Override
    public DBTraceTimeManager getTimeManager() {
        return this.timeManager;
    }

    @Override
    public void setChanged(TraceChangeRecord<?, ?> event) {
        this.changed = true;
        DBTraceObjectRegisterSupport.INSTANCE.processEvent(event);
        this.fireEvent(event);
    }

    public void fireEvent(DomainObjectChangeRecord ev) {
        super.fireEvent(ev);
        if (this.directListeners != null) {
            ((DBTraceDirectChangeListener)this.directListeners.invoke()).changed(ev);
        }
    }

    public void addDirectChangeListener(DBTraceDirectChangeListener listener) {
        this.directListeners.add((Object)listener);
    }

    public void removeDirectChangeListener(DBTraceDirectChangeListener listener) {
        this.directListeners.remove((Object)listener);
    }

    @Override
    public DBTraceProgramView getFixedProgramView(long snap) {
        DBTraceProgramView view;
        try (LockHold hold = this.lockRead();){
            view = this.fixedProgramViews.computeIfAbsent(snap, s -> {
                Msg.trace((Object)this, (Object)("Creating fixed view at snap=" + snap));
                return new DBTraceProgramView(this, snap, this.baseCompilerSpec);
            });
        }
        ((Trace.TraceProgramViewListener)this.viewListeners.invoke()).viewCreated(view);
        return view;
    }

    @Override
    public DBTraceVariableSnapProgramView createProgramView(long snap) {
        DBTraceVariableSnapProgramView view;
        try (LockHold hold = this.lockRead();){
            view = new DBTraceVariableSnapProgramView(this, snap, this.baseCompilerSpec);
            this.programViews.add(view);
        }
        ((Trace.TraceProgramViewListener)this.viewListeners.invoke()).viewCreated(view);
        return view;
    }

    @Override
    public DBTraceVariableSnapProgramView getProgramView() {
        return this.programView;
    }

    @Override
    public DBTraceTimeViewport createTimeViewport() {
        try (LockHold hold = this.lockRead();){
            DBTraceTimeViewport view = new DBTraceTimeViewport(this);
            this.viewports.add(view);
            DBTraceTimeViewport dBTraceTimeViewport = view;
            return dBTraceTimeViewport;
        }
    }

    @Override
    public LockHold lockRead() {
        return LockHold.lock((Lock)this.rwLock.readLock());
    }

    @Override
    public LockHold lockWrite() {
        return LockHold.lock((Lock)this.rwLock.writeLock());
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        if (this.recordChanges) {
            this.traceChangeSet.sourceArchiveChanged(sourceArchiveID.getValue());
        }
        this.setChanged(new TraceChangeRecord<UniversalID, Void>(TraceEvents.SOURCE_TYPE_ARCHIVE_CHANGED, null, sourceArchiveID));
    }

    public void sourceArchiveAdded(UniversalID sourceArchiveID) {
        if (this.recordChanges) {
            this.traceChangeSet.sourceArchiveAdded(sourceArchiveID.getValue());
        }
        this.setChanged(new TraceChangeRecord<UniversalID, Void>(TraceEvents.SOURCE_TYPE_ARCHIVE_ADDED, null, sourceArchiveID));
    }

    public void dataTypeChanged(long changedID, DataType changedType) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeChanged(changedID);
        }
        this.setChanged(new TraceChangeRecord<Long, DataType>(TraceEvents.DATA_TYPE_CHANGED, null, changedID, changedType));
    }

    public void dataTypeAdded(long addedID, DataType addedType) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeAdded(addedID);
        }
        this.setChanged(new TraceChangeRecord<Long, DataType>(TraceEvents.DATA_TYPE_ADDED, null, addedID, addedType));
    }

    public void dataTypeReplaced(long replacedID, DataTypePath replacedPath, DataTypePath newPath) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeChanged(replacedID);
        }
        this.setChanged(new TraceChangeRecord<Long, DataTypePath>(TraceEvents.DATA_TYPE_REPLACED, null, replacedID, replacedPath, newPath));
    }

    public void dataTypeMoved(long movedID, DataTypePath oldPath, DataTypePath newPath) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeChanged(movedID);
        }
        this.setChanged(new TraceChangeRecord<Long, DataTypePath>(TraceEvents.DATA_TYPE_MOVED, null, movedID, oldPath, newPath));
    }

    public void dataTypeNameChanged(long renamedID, String oldName, String newName) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeChanged(renamedID);
        }
        this.setChanged(new TraceChangeRecord<Long, String>(TraceEvents.DATA_TYPE_RENAMED, null, renamedID, oldName, newName));
    }

    public void dataTypeDeleted(long deletedID, DataTypePath deletedPath) {
        if (this.recordChanges) {
            this.traceChangeSet.dataTypeChanged(deletedID);
        }
        this.setChanged(new TraceChangeRecord<Long, Object>(TraceEvents.DATA_TYPE_DELETED, null, deletedID, deletedPath, null));
    }

    public void categoryAdded(long addedID, Category addedCategory) {
        if (this.recordChanges) {
            this.traceChangeSet.categoryAdded(addedID);
        }
        this.setChanged(new TraceChangeRecord<Long, Category>(TraceEvents.TYPE_CATEGORY_ADDED, null, addedID, addedCategory));
    }

    public void categoryMoved(long movedID, CategoryPath oldPath, CategoryPath newPath) {
        if (this.recordChanges) {
            this.traceChangeSet.categoryChanged(movedID);
        }
        this.setChanged(new TraceChangeRecord<Long, CategoryPath>(TraceEvents.TYPE_CATEGORY_MOVED, null, movedID, oldPath, newPath));
    }

    public void categoryRenamed(long renamedID, String oldName, String newName) {
        if (this.recordChanges) {
            this.traceChangeSet.categoryChanged(renamedID);
        }
        this.setChanged(new TraceChangeRecord<Long, String>(TraceEvents.TYPE_CATEGORY_RENAMED, null, renamedID, oldName, newName));
    }

    public void categoryDeleted(long deletedID, CategoryPath deletedPath) {
        if (this.recordChanges) {
            this.traceChangeSet.categoryChanged(deletedID);
        }
        this.setChanged(new TraceChangeRecord<Long, Object>(TraceEvents.TYPE_CATEGORY_DELETED, null, deletedID, deletedPath, null));
    }

    protected void clearCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.rwLock.writeLock());){
            for (DBTraceManager m : this.managers) {
                m.invalidateCache(all);
            }
        }
    }

    public void setExecutablePath(String path) {
        this.getOptions(TRACE_INFO).setString(EXECUTABLE_PATH, path);
    }

    public String getExecutablePath() {
        return this.getOptions(TRACE_INFO).getString(EXECUTABLE_PATH, null);
    }

    public Date getCreationDate() {
        return this.getOptions(TRACE_INFO).getDate(DATE_CREATED, new Date(0L));
    }

    @Override
    public void setEmulatorCacheVersion(long version) {
        this.getOptions(TRACE_INFO).setLong(EMU_CACHE_VERSION, version);
    }

    @Override
    public long getEmulatorCacheVersion() {
        return this.getOptions(TRACE_INFO).getLong(EMU_CACHE_VERSION, 0L);
    }

    @Override
    public Collection<TraceProgramView> getAllProgramViews() {
        return new CompositeCollection(this.programViewsView, Collections.unmodifiableCollection(this.fixedProgramViews.values()));
    }

    protected void allViewports(Consumer<DBTraceTimeViewport> action) {
        for (DBTraceTimeViewport viewport : this.viewports) {
            action.accept(viewport);
        }
    }

    protected void allViews(Consumer<DBTraceProgramView> action) {
        for (DBTraceProgramView dBTraceProgramView : this.programViews) {
            action.accept(dBTraceProgramView);
        }
        for (DBTraceProgramView dBTraceProgramView : this.fixedProgramViews.values()) {
            action.accept(dBTraceProgramView);
        }
    }

    @Override
    public void addProgramViewListener(Trace.TraceProgramViewListener listener) {
        this.viewListeners.add((Object)listener);
    }

    @Override
    public void removeProgramViewListener(Trace.TraceProgramViewListener listener) {
        this.viewListeners.remove((Object)listener);
    }

    public void updateViewsAddRegionBlock(TraceMemoryRegion region) {
        this.allViews(v -> v.updateMemoryAddRegionBlock(region));
    }

    public void updateViewsChangeRegionBlockName(TraceMemoryRegion region) {
        this.allViews(v -> v.updateMemoryChangeRegionBlockName(region));
    }

    public void updateViewsChangeRegionBlockFlags(TraceMemoryRegion region, Lifespan lifespan) {
        this.allViews(v -> v.updateMemoryChangeRegionBlockFlags(region, lifespan));
    }

    public void updateViewsChangeRegionBlockRange(TraceMemoryRegion region, AddressRange oldRange, AddressRange newRange) {
        this.allViews(v -> v.updateMemoryChangeRegionBlockRange(region, oldRange, newRange));
    }

    public void updateViewsChangeRegionBlockLifespan(TraceMemoryRegion region, Lifespan oldLifespan, Lifespan newLifespan) {
        this.allViews(v -> v.updateMemoryChangeRegionBlockLifespan(region, oldLifespan, newLifespan));
    }

    public void updateViewsDeleteRegionBlock(TraceMemoryRegion region) {
        this.allViews(v -> v.updateMemoryDeleteRegionBlock(region));
    }

    public void updateViewsAddSpaceBlock(AddressSpace space) {
        this.allViews(v -> v.updateMemoryAddSpaceBlock(space));
    }

    public void updateViewsDeleteSpaceBlock(AddressSpace space) {
        this.allViews(v -> v.updateMemoryDeleteSpaceBlock(space));
    }

    public void updateViewsRefreshBlocks() {
        this.allViews(v -> v.updateMemoryRefreshBlocks());
    }

    public void updateViewsBytesChanged(AddressRange range) {
        this.allViews(v -> v.updateBytesChanged(range));
    }

    public void updateViewportsSnapshotAdded(TraceSnapshot snapshot) {
        this.allViewports(v -> v.updateSnapshotAdded(snapshot));
    }

    public void updateViewportsSnapshotChanged(TraceSnapshot snapshot) {
        this.allViewports(v -> v.updateSnapshotChanged(snapshot));
    }

    public void updateViewportsSnapshotDeleted(TraceSnapshot snapshot) {
        this.allViewports(v -> v.updateSnapshotDeleted(snapshot));
    }

    public void save(String comment, TaskMonitor monitor) throws IOException, CancelledException {
        this.objectManager.flushWbCaches();
        super.save(comment, monitor);
    }

    public void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        this.objectManager.flushWbCaches();
        super.saveToPackedFile(outputFile, monitor);
    }

    public boolean isClosing() {
        return this.closing;
    }

    protected void close() {
        this.closing = true;
        this.objectManager.flushWbCaches();
        super.close();
        this.objectManager.waitWbWorkers();
    }

    protected void domainObjectRestored() {
        super.domainObjectRestored();
        this.dataTypeManager.notifyRestored();
    }
}

