/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.framework.DockingApplicationConfiguration;
import docking.widgets.label.GDLabel;
import generic.application.GenericApplicationLayout;
import generic.theme.Gui;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import resources.ResourceManager;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class UserAgreementDialog
extends DialogComponentProvider {
    private static final String USER_AGREEMENT_FILENAME = "UserAgreement.html";
    private static final String FONT_ID = "font.user.agreement";
    private boolean exitOnCancel;

    public UserAgreementDialog(boolean showAgreementChoices, boolean exitOnCancel) {
        super("", true, false, true, false);
        this.exitOnCancel = exitOnCancel;
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        if (showAgreementChoices) {
            this.setOkButtonText("I Agree");
            this.addCancelButton();
            this.setCancelButtonText("I Don't Agree");
        } else {
            this.setOkButtonText("OK");
        }
        this.setPreferredSize(1000, 500);
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        GDLabel label = new GDLabel("Ghidra User Agreement", 0);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        label.getAccessibleContext().setAccessibleName("Ghidra User Agreement");
        Gui.registerFont((Component)label, (String)FONT_ID);
        panel.add((Component)label, "North");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 40, 40, 40));
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.setMargin(new Insets(10, 10, 10, 10));
        editorPane.getAccessibleContext().setAccessibleName("Agreement");
        editorPane.setText(this.getUserAgreementText());
        editorPane.setCaretPosition(0);
        editorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.getAccessibleContext().setAccessibleName("Editor");
        panel.add((Component)scrollPane, "Center");
        JPanel checkBoxPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        checkBoxPanel.getAccessibleContext().setAccessibleName("Checkbox");
        panel.add((Component)checkBoxPanel, "South");
        panel.getAccessibleContext().setAccessibleName("User Agreement");
        return panel;
    }

    private String getUserAgreementText() {
        String string;
        block9: {
            InputStream in = ResourceManager.getResourceAsStream((String)USER_AGREEMENT_FILENAME);
            try {
                String text = FileUtilities.getText((InputStream)in);
                if (!HTMLUtilities.isHTML((String)text)) {
                    text = HTMLUtilities.toHTML((String)text);
                }
                string = text = text.replace('\n', ' ');
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Msg.debug((Object)((Object)this), (Object)"Unable to read user agreement text from: UserAgreement.html");
                    return "UserAgreement.html file is missing!";
                }
            }
            in.close();
        }
        return string;
    }

    protected void okCallback() {
        this.close();
    }

    protected void cancelCallback() {
        if (this.exitOnCancel) {
            System.exit(0);
        }
        this.close();
    }

    public static void main(String[] args) throws Exception {
        GenericApplicationLayout layout = new GenericApplicationLayout("User Agreement Main", "1.0");
        DockingApplicationConfiguration config = new DockingApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)config);
        UserAgreementDialog dialog = new UserAgreementDialog(true, true);
        DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
    }
}

