/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.GTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.framework.task.GTaskMonitor;

public class GScheduledTask
implements Comparable<GScheduledTask> {
    private static long nextID = 1L;
    private GTask task;
    private int priority;
    private Thread thread;
    private long id;
    private GTaskGroup group;
    private GTaskMonitor monitor;

    public GScheduledTask(GTaskGroup group, GTask task, int priority) {
        this.group = group;
        this.task = task;
        this.priority = priority;
        this.id = nextID++;
        this.monitor = new GTaskMonitor();
    }

    public GTask getTask() {
        return this.task;
    }

    public int getPriority() {
        return this.priority;
    }

    public GTaskMonitor getTaskMonitor() {
        return this.monitor;
    }

    @Override
    public int compareTo(GScheduledTask other) {
        if (this == other) {
            return 0;
        }
        if (this.priority == other.priority) {
            return this.id > other.id ? 1 : -1;
        }
        return this.priority - other.priority;
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    boolean isRunningInCurrentThread() {
        return this.thread == Thread.currentThread();
    }

    public String toString() {
        return this.task.getName() + " : " + this.priority;
    }

    public GTaskGroup getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.task.getName();
    }
}

