/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.CellEditorUtils;
import docking.widgets.textfield.IntegerTextField;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class HexBigIntegerTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private IntegerTextField input;

    @Override
    public BigInteger getCellEditorValue() {
        return this.input.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            MouseEvent evt = (MouseEvent)e;
            return evt.getClickCount() >= 2 && super.isCellEditable(e);
        }
        return super.isCellEditable(e);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.input = new IntegerTextField();
        this.input.getComponent().setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.input.setAllowNegativeValues(true);
        this.input.setHexMode();
        this.input.setAllowsHexPrefix(false);
        this.input.setShowNumberMode(true);
        this.input.setHorizontalAlignment(4);
        if (value != null) {
            this.input.setValue((BigInteger)value);
            CellEditorUtils.onOneFocus(this.input.getComponent(), () -> this.input.selectAll());
        }
        this.input.addActionListener(e -> this.stopCellEditing());
        return this.input.getComponent();
    }
}

