/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.help.UnsupportedOperationException;

public abstract class SQLComplexTable {
    protected final String tableName;
    protected final String idColumnName;
    protected Connection db = null;
    private final CachedStatement<PreparedStatement> deleteStatement;

    public SQLComplexTable(String tableName, String idColumnName) {
        this.tableName = tableName;
        this.idColumnName = idColumnName;
        this.deleteStatement = idColumnName != null ? new CachedStatement() : null;
    }

    public void setConnection(Connection db) {
        this.db = db;
    }

    public void close() {
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        this.db = null;
    }

    public abstract void create(Statement var1) throws SQLException;

    public int delete(long id) throws SQLException {
        if (this.idColumnName == null) {
            throw new UnsupportedOperationException("delete not supported without id column");
        }
        PreparedStatement s = this.deleteStatement.prepareIfNeeded(() -> this.db.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.idColumnName + " = ?"));
        s.setLong(1, id);
        return s.executeUpdate();
    }

    public void drop(Statement st) throws SQLException {
        String sql = "DROP TABLE " + this.tableName;
        st.executeUpdate(sql);
    }

    public abstract long insert(Object ... var1) throws SQLException;
}

