/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import generic.jar.ResourceFile;
import ghidra.util.MonitoredInputStream;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ItemDeserializer {
    private static final long MAGIC_NUMBER = 3328196572606966816L;
    private static final int FORMAT_VERSION = 1;
    private static final String ZIP_ENTRY_NAME = "FOLDER_ITEM";
    private static final int IO_BUFFER_SIZE = 32768;
    private InputStream in;
    private String itemName;
    private String contentType;
    private int fileType;
    private long length;
    private boolean saved = false;

    public ItemDeserializer(File packedFile) throws IOException {
        this(new ResourceFile(packedFile));
    }

    public ItemDeserializer(ResourceFile packedFile) throws IOException {
        this.in = new BufferedInputStream(packedFile.getInputStream());
        boolean success = false;
        try {
            ObjectInputStream objIn = new ObjectInputStream(this.in);
            if (objIn.readLong() != 3328196572606966816L) {
                throw new IOException("Invalid data");
            }
            if (objIn.readInt() != 1) {
                throw new IOException("Unsupported data format");
            }
            this.itemName = objIn.readUTF();
            this.contentType = objIn.readUTF();
            if (this.contentType.length() == 0) {
                this.contentType = null;
            }
            this.fileType = objIn.readInt();
            this.length = objIn.readLong();
            success = true;
        }
        catch (UTFDataFormatException e) {
            throw new IOException("Invalid item data");
        }
        finally {
            if (!success) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getFileType() {
        return this.fileType;
    }

    public long getLength() {
        return this.length;
    }

    public void saveItem(OutputStream out, TaskMonitor monitor) throws IOCancelledException, IOException {
        if (this.saved) {
            throw new IllegalStateException("Already saved");
        }
        this.saved = true;
        ZipInputStream zipIn = new ZipInputStream(this.in);
        ZipEntry entry = zipIn.getNextEntry();
        if (entry == null || !ZIP_ENTRY_NAME.equals(entry.getName())) {
            throw new IOException("Data error");
        }
        ZipInputStream itemIn = zipIn;
        if (monitor != null) {
            itemIn = new MonitoredInputStream((InputStream)zipIn, monitor);
            monitor.initialize((long)((int)this.length));
        }
        long len = this.length;
        byte[] buffer = new byte[32768];
        int cnt = (int)(len < 32768L ? len : 32768L);
        while ((cnt = ((InputStream)itemIn).read(buffer, 0, cnt)) > 0) {
            out.write(buffer, 0, cnt);
            cnt = (int)((len -= (long)cnt) < 32768L ? len : 32768L);
        }
    }
}

