/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.png;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PNGChunk
implements StructConverter {
    private int length;
    private int chunkID;
    private byte[] data;
    private int crc32;
    private int totalLength;

    public PNGChunk(BinaryReader reader) throws IOException {
        this.length = reader.readNextInt();
        this.chunkID = reader.readNextInt();
        this.data = reader.readNextByteArray(this.length);
        this.crc32 = reader.readNextInt();
        this.totalLength += 12 + this.data.length;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getLengthBytes() {
        return ByteBuffer.allocate(4).putInt(this.length).array();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getChunkID() {
        return this.chunkID;
    }

    public byte[] getChunkIDBytes() {
        return ByteBuffer.allocate(4).putInt(this.chunkID).array();
    }

    public void setChunkID(int chunkID) {
        this.chunkID = chunkID;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public byte[] getCrc32Bytes() {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(this.crc32).array();
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public byte[] getChunkBytes() {
        return ByteBuffer.allocate(this.totalLength).putInt(this.length).putInt(this.chunkID).put(this.data).putInt(this.crc32).array();
    }

    public String getIDString() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(this.chunkID);
        byte[] bArr = byteBuffer.array();
        return new String(bArr);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("iOS Crushed PNG", 0);
        struc.add(BYTE, "Length", "Length of the chunk data field");
        struc.add(BYTE, "Chunk ID", "The name of the chunk");
        struc.add((DataType)new ArrayDataType(BYTE, this.data.length, 1), "Data", "Chunk data");
        struc.add(BYTE, "CRC32", "Chunk CRC32");
        return struc;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Length: 0x" + Integer.toHexString(this.length) + "\n");
        buff.append("Chunk ID: " + this.getIDString() + "\n");
        buff.append("Chunk Data:" + new String(this.data) + "\n");
        buff.append("CRC32: 0x" + Integer.toHexString(this.crc32) + "\n");
        return buff.toString();
    }
}

