/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;

public abstract class Bearing {
    public static double calculateDegrees(DataPoint dataPoint, DataPoint dataPoint2) {
        double d = Math.toRadians(dataPoint2.getLongitude().getDouble() - dataPoint.getLongitude().getDouble());
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = Math.toRadians(dataPoint.getLatitude().getDouble());
        double d5 = Math.toRadians(dataPoint2.getLatitude().getDouble());
        double d6 = Math.atan2(d2 * Math.cos(d5), Math.cos(d4) * Math.sin(d5) - Math.sin(d4) * Math.cos(d5) * d3);
        return Math.toDegrees(d6);
    }

    public static double calculateDegreeChange(DataPoint dataPoint, DataPoint dataPoint2, DataPoint dataPoint3) {
        if (dataPoint == null || dataPoint2 == null || dataPoint3 == null) {
            return 180.0;
        }
        double d = Bearing.calculateDegrees(dataPoint, dataPoint2);
        double d2 = Bearing.calculateDegrees(dataPoint2, dataPoint3);
        return Bearing.angleDifferenceDegrees(d, d2);
    }

    public static double angleDifferenceDegrees(double d, double d2) {
        double d3 = Math.abs(d - d2) % 360.0;
        return d3 > 180.0 ? 360.0 - d3 : d3;
    }
}

