/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.File;
import tim.prune.function.filesleuth.extract.ContentExtractor;
import tim.prune.function.filesleuth.extract.GzipFileExtractor;
import tim.prune.function.filesleuth.extract.TextFileExtractor;
import tim.prune.function.filesleuth.extract.XmlFileExtractor;
import tim.prune.function.filesleuth.extract.ZipFileExtractor;

public abstract class ExtractorFactory {
    public static ContentExtractor createExtractor(File file) {
        String string;
        String string2 = string = file == null ? null : file.getName().toLowerCase();
        if (string == null || !string.contains(".")) {
            return null;
        }
        if (string.endsWith(".txt") || string.endsWith(".csv")) {
            return new TextFileExtractor(file);
        }
        if (string.endsWith(".gpx") || string.endsWith(".kml")) {
            return new XmlFileExtractor(file);
        }
        if (string.endsWith(".kmz") || string.endsWith(".zip")) {
            return new ZipFileExtractor(file);
        }
        if (string.endsWith(".gz")) {
            return new GzipFileExtractor(file);
        }
        return null;
    }
}

