/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.weather;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.browser.BrowserLauncher;
import tim.prune.function.weather.IconRenderer;
import tim.prune.function.weather.OWMCurrentHandler;
import tim.prune.function.weather.OWMForecastHandler;
import tim.prune.function.weather.OnlineStreamProvider;
import tim.prune.function.weather.ResultSet;
import tim.prune.function.weather.StreamProvider;
import tim.prune.function.weather.WeatherResults;
import tim.prune.function.weather.WeatherTableModel;

public class GetWeatherForecastFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _locationLabel = null;
    private JLabel _updateTimeLabel = null;
    private JLabel _sunriseLabel = null;
    private JRadioButton _currentForecastRadio = null;
    private JRadioButton _dailyForecastRadio = null;
    private JComboBox<String> _tempUnitsDropdown = null;
    private JTable _forecastsTable = null;
    private final WeatherTableModel _tableModel = new WeatherTableModel();
    private final ResultSet _resultSet = new ResultSet();
    private String _locationId = null;
    private StreamProvider _streamProvider = new OnlineStreamProvider();
    private boolean _isRunning = false;

    public GetWeatherForecastFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.getweatherforecast";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._locationId = null;
        this._tableModel.clear();
        this._locationLabel.setText(I18nManager.getText("confirm.running"));
        this._updateTimeLabel.setText("");
        this._sunriseLabel.setText("");
        this._currentForecastRadio.setSelected(true);
        new Thread(this::run).start();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 4));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this._locationLabel = new JLabel(I18nManager.getText("confirm.running"));
        this._locationLabel.setAlignmentX(0.0f);
        jPanel2.add(this._locationLabel);
        this._updateTimeLabel = new JLabel(" ");
        this._updateTimeLabel.setAlignmentX(0.0f);
        jPanel2.add(this._updateTimeLabel);
        this._sunriseLabel = new JLabel(" ");
        this._sunriseLabel.setAlignmentX(0.0f);
        jPanel2.add(this._sunriseLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        ButtonGroup buttonGroup = new ButtonGroup();
        this._currentForecastRadio = new JRadioButton(I18nManager.getText("dialog.weather.currentforecast"));
        this._dailyForecastRadio = new JRadioButton(I18nManager.getText("dialog.weather.dailyforecast"));
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.weather.3hourlyforecast"));
        buttonGroup.add(this._currentForecastRadio);
        buttonGroup.add(this._dailyForecastRadio);
        buttonGroup.add(jRadioButton);
        jPanel3.add(this._currentForecastRadio);
        jPanel3.add(this._dailyForecastRadio);
        jPanel3.add(jRadioButton);
        this._currentForecastRadio.setSelected(true);
        ActionListener actionListener = actionEvent -> {
            if (!this._isRunning) {
                new Thread(this::run).start();
            }
        };
        this._currentForecastRadio.addActionListener(actionListener);
        this._dailyForecastRadio.addActionListener(actionListener);
        jRadioButton.addActionListener(actionListener);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(Box.createHorizontalStrut(40));
        jPanel3.add(new JLabel(String.valueOf(I18nManager.getText("dialog.weather.temperatureunits")) + ": "));
        this._tempUnitsDropdown = new JComboBox<String>(new String[]{I18nManager.getText("units.degreescelsius"), I18nManager.getText("units.degreesfahrenheit")});
        this._tempUnitsDropdown.setMaximumSize(this._tempUnitsDropdown.getPreferredSize());
        this._tempUnitsDropdown.addActionListener(actionListener);
        jPanel3.add(this._tempUnitsDropdown);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        final IconRenderer iconRenderer = new IconRenderer(this.getIconManager());
        this._forecastsTable = new JTable(this._tableModel){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n == 3) {
                    return iconRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this._forecastsTable.setRowSelectionAllowed(false);
        this._forecastsTable.setRowHeight(2, 55);
        this._forecastsTable.setAutoResizeMode(0);
        this._forecastsTable.getTableHeader().setReorderingAllowed(false);
        this._forecastsTable.setShowHorizontalLines(false);
        JScrollPane jScrollPane = new JScrollPane(this._forecastsTable);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(new Dimension(500, 210));
        jScrollPane.getViewport().setBackground(Color.white);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.showwebpage"));
        jButton.addActionListener(actionEvent -> BrowserLauncher.launchBrowser("http://openweathermap.org/city/" + (this._locationId == null ? "" : this._locationId)));
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.close"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel4.add(jButton2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(new JLabel(I18nManager.getText("dialog.weather.creditnotice")));
        jPanel5.add(jPanel4);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    public void run() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (this._isRunning) {
            return;
        }
        this._isRunning = true;
        boolean bl4 = this._locationId == null || this._currentForecastRadio.isSelected();
        WeatherResults weatherResults = this._resultSet.getWeather(this._locationId, bl4, bl3 = this._dailyForecastRadio.isSelected() && !bl4, bl2 = !bl4 && !bl3, bl = this._tempUnitsDropdown.getSelectedIndex() == 0);
        if (weatherResults == null) {
            if (bl4) {
                weatherResults = this.getCurrentWeather(bl);
                if (!this._currentForecastRadio.isSelected()) {
                    this._currentForecastRadio.setSelected(true);
                }
            } else {
                weatherResults = this.getWeatherForecast(bl3, bl);
            }
            if (weatherResults != null) {
                this._resultSet.setWeather(weatherResults, this._locationId, bl4, bl3, bl2, bl);
            }
        }
        if (weatherResults != null) {
            WeatherResults weatherResults2 = weatherResults;
            SwingUtilities.invokeLater(() -> {
                this._tableModel.setResults(weatherResults2);
                this.adjustTable();
            });
            this._locationLabel.setText(String.valueOf(I18nManager.getText("dialog.weather.location")) + ": " + weatherResults.getLocationName());
            String string = weatherResults.getUpdateTime();
            this._updateTimeLabel.setText(String.valueOf(I18nManager.getText("dialog.weather.update")) + ": " + (string == null ? "" : string));
            if (weatherResults.getSunriseTime() != null && weatherResults.getSunsetTime() != null) {
                this._sunriseLabel.setText(String.valueOf(I18nManager.getText("dialog.weather.sunrise")) + ": " + weatherResults.getSunriseTime() + ", " + I18nManager.getText("dialog.weather.sunset") + ": " + weatherResults.getSunsetTime());
            } else {
                this._sunriseLabel.setText("");
            }
        }
        this._isRunning = false;
    }

    private void adjustTable() {
        if (!this._tableModel.isEmpty()) {
            int n = 0;
            while (n < this._forecastsTable.getColumnCount()) {
                double d = 0.0;
                int n2 = 0;
                while (n2 < this._forecastsTable.getRowCount()) {
                    String string = this._tableModel.getValueAt(n2, n).toString();
                    d = Math.max(d, this._forecastsTable.getCellRenderer(0, 0).getTableCellRendererComponent(this._forecastsTable, string, false, false, 0, 0).getPreferredSize().getWidth());
                    ++n2;
                }
                this._forecastsTable.getColumnModel().getColumn(n).setMinWidth((int)d + 2);
                ++n;
            }
            n = (int)(this._forecastsTable.getCellRenderer(0, 0).getTableCellRendererComponent(this._forecastsTable, "M", false, false, 0, 0).getMinimumSize().getHeight() * (double)1.2f + 4.0);
            int n3 = 0;
            while (n3 < this._forecastsTable.getRowCount()) {
                if (n3 == 3) {
                    this._forecastsTable.setRowHeight(n3, 55);
                } else {
                    this._forecastsTable.setRowHeight(n3, n);
                }
                ++n3;
            }
        }
    }

    WeatherResults getCurrentWeather(boolean bl) {
        Object object;
        double d;
        double d2;
        Track track = this._app.getTrackInfo().getTrack();
        if (track.getNumPoints() < 1) {
            return null;
        }
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint != null) {
            d2 = dataPoint.getLatitude().getDouble();
            d = dataPoint.getLongitude().getDouble();
        } else {
            d2 = track.getLatRange().getMidValue();
            d = track.getLonRange().getMidValue();
        }
        OWMCurrentHandler oWMCurrentHandler = new OWMCurrentHandler();
        try {
            object = null;
            Object var10_10 = null;
            try (InputStream inputStream = this._streamProvider.getCurrentWeatherStream(d2, d, this._locationId, bl);){
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)oWMCurrentHandler);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage());
            this._isRunning = false;
            return null;
        }
        if (oWMCurrentHandler.getLocationId() != null) {
            this._locationId = oWMCurrentHandler.getLocationId();
        }
        object = new WeatherResults();
        ((WeatherResults)object).setForecast(oWMCurrentHandler.getCurrentWeather());
        ((WeatherResults)object).setLocationName(oWMCurrentHandler.getLocationName());
        ((WeatherResults)object).setUpdateTime(oWMCurrentHandler.getUpdateTime());
        ((WeatherResults)object).setSunriseSunsetTimes(oWMCurrentHandler.getSunriseTime(), oWMCurrentHandler.getSunsetTime());
        ((WeatherResults)object).setTempsCelsius(bl);
        return object;
    }

    WeatherResults getWeatherForecast(boolean bl, boolean bl2) {
        Object object;
        if (this._locationId == null) {
            return null;
        }
        OWMForecastHandler oWMForecastHandler = new OWMForecastHandler();
        try {
            object = null;
            Object var5_7 = null;
            try (InputStream inputStream = this._streamProvider.getForecastStream(this._locationId, bl, bl2);){
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)oWMForecastHandler);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (Exception exception) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage());
            this._isRunning = false;
            return null;
        }
        object = new WeatherResults();
        ((WeatherResults)object).setForecasts(oWMForecastHandler.getForecasts());
        ((WeatherResults)object).setLocationName(oWMForecastHandler.getLocationName());
        ((WeatherResults)object).setUpdateTime(oWMForecastHandler.getUpdateTime());
        ((WeatherResults)object).setTempsCelsius(bl2);
        return object;
    }

    void setStreamProvider(StreamProvider streamProvider) {
        this._streamProvider = streamProvider;
    }
}

