/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.reporting.listener;

import java.io.File;
import org.jspecify.annotations.Nullable;

public class OnInterceptedMethodInsFormatter {
    public String format(@Nullable File source, String sourceFileName, String className, String methodCallOwner, String methodName, String methodDescriptor, int lineNumber) {
        String methodCallOwnerClassName = methodCallOwner.replace("/", ".");
        className = sourceFileName.endsWith("gradle.kts") ? sourceFileName.replace(".kts", "") : className.replace("/", ".");
        sourceFileName = source != null && OnInterceptedMethodInsFormatter.isAnyBuildScript(sourceFileName) ? "file://" + source.getAbsolutePath() : sourceFileName;
        return String.format("%s.%s(): at %s(%s:%d)", methodCallOwnerClassName, methodName, className, sourceFileName, lineNumber);
    }

    private static boolean isAnyBuildScript(String sourceFileName) {
        switch (sourceFileName) {
            case "init.gradle.kts": 
            case "settings.gradle.kts": 
            case "build.gradle.kts": 
            case "init.gradle": 
            case "settings.gradle": 
            case "build.gradle": {
                return true;
            }
        }
        return false;
    }
}

