/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.dsl.FileSystemPublishArtifact;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DecoratingPublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

@ServiceScope(value={Scope.Project.class})
public class PublishArtifactNotationParserFactory
implements Factory<NotationParser<Object, ConfigurablePublishArtifact>> {
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider metaDataProvider;
    private final FileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public PublishArtifactNotationParserFactory(ObjectFactory objectFactory, DependencyMetaDataProvider metaDataProvider, FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory) {
        this.objectFactory = objectFactory;
        this.metaDataProvider = metaDataProvider;
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public NotationParser<Object, ConfigurablePublishArtifact> create() {
        FileNotationConverter fileConverter = new FileNotationConverter();
        return NotationParserBuilder.toType(ConfigurablePublishArtifact.class).converter((NotationConverter)new DecoratingConverter()).converter((NotationConverter)new ArchiveTaskNotationConverter()).converter((NotationConverter)new FileProviderNotationConverter()).converter((NotationConverter)new FileSystemLocationNotationConverter()).converter((NotationConverter)fileConverter).converter((NotationConverter)new FileMapNotationConverter(fileConverter)).toComposite();
    }

    private class FileNotationConverter
    extends TypedNotationConverter<File, ConfigurablePublishArtifact> {
        private FileNotationConverter() {
            super(File.class);
        }

        protected ConfigurablePublishArtifact parseType(File file) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            ArtifactFile artifactFile = new ArtifactFile(file, module.getVersion());
            DefaultPublishArtifact defaultPublishArtifact = (DefaultPublishArtifact)PublishArtifactNotationParserFactory.this.objectFactory.newInstance(DefaultPublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskDependencyFactory});
            defaultPublishArtifact.setName(artifactFile.getName());
            defaultPublishArtifact.setExtension(artifactFile.getExtension());
            defaultPublishArtifact.setType(artifactFile.getExtension());
            defaultPublishArtifact.setClassifier(artifactFile.getClassifier());
            defaultPublishArtifact.setDate(null);
            defaultPublishArtifact.setFile(file);
            return defaultPublishArtifact;
        }
    }

    private class DecoratingConverter
    extends TypedNotationConverter<PublishArtifact, ConfigurablePublishArtifact> {
        private DecoratingConverter() {
            super(PublishArtifact.class);
        }

        protected ConfigurablePublishArtifact parseType(PublishArtifact notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.objectFactory.newInstance(DecoratingPublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskDependencyFactory, notation});
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, ConfigurablePublishArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }

        protected ConfigurablePublishArtifact parseType(AbstractArchiveTask notation) {
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.objectFactory.newInstance(ArchivePublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskDependencyFactory, notation});
        }
    }

    private class FileProviderNotationConverter
    extends TypedNotationConverter<Provider<?>, ConfigurablePublishArtifact> {
        FileProviderNotationConverter() {
            super(Provider.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of Provider<RegularFile>.");
            visitor.candidate("Instances of Provider<Directory>.");
            visitor.candidate("Instances of Provider<File>.");
        }

        protected ConfigurablePublishArtifact parseType(Provider<?> notation) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.objectFactory.newInstance(DecoratingPublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskDependencyFactory, new LazyPublishArtifact(notation, module.getVersion(), PublishArtifactNotationParserFactory.this.fileResolver, PublishArtifactNotationParserFactory.this.taskDependencyFactory)});
        }
    }

    private class FileSystemLocationNotationConverter
    extends TypedNotationConverter<FileSystemLocation, ConfigurablePublishArtifact> {
        FileSystemLocationNotationConverter() {
            super(FileSystemLocation.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of RegularFile.");
            visitor.candidate("Instances of Directory.");
        }

        protected ConfigurablePublishArtifact parseType(FileSystemLocation notation) {
            Module module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            return (ConfigurablePublishArtifact)PublishArtifactNotationParserFactory.this.objectFactory.newInstance(DecoratingPublishArtifact.class, new Object[]{PublishArtifactNotationParserFactory.this.taskDependencyFactory, new FileSystemPublishArtifact(notation, module.getVersion())});
        }
    }

    private static class FileMapNotationConverter
    extends MapNotationConverter<ConfigurablePublishArtifact> {
        private final FileNotationConverter fileConverter;

        private FileMapNotationConverter(FileNotationConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps with 'file' key");
        }

        protected PublishArtifact parseMap(@MapKey(value="file") File file) {
            return this.fileConverter.parseType(file);
        }
    }
}

