/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TestNGTestGroup
extends TestNGTestObject {
    public TestNGTestGroup(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestData data = this.myConfig.getPersistantData();
        SourceScope sourceScope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig);
        TestClassFilter classFilter = new TestClassFilter(sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)this.myConfig.getProject()), this.myConfig.getProject(), true, true);
        PsiClass[] testClasses = TestNGUtil.getAllTestClasses(classFilter, false);
        if (testClasses != null) {
            for (PsiClass c : testClasses) {
                classes.put(c, new LinkedHashMap());
            }
        }
    }

    @Override
    public String getGeneratedName() {
        return this.myConfig.getPersistantData().getGroupName();
    }

    @Override
    public String getActionName() {
        return this.myConfig.getPersistantData().getGroupName();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
    }
}

