/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.typing.CurriedSignature;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;
import org.jetbrains.plugins.groovy.util.FunctionsKt;

final class GroovyCurriedClosureType
extends GroovyClosureType {
    private final GroovyClosureType myOriginal;
    private final int myPosition;
    private final List<? extends Argument> myArguments;
    private final int myCurriedArgumentCount;
    private final Lazy<List<CallSignature<?>>> mySignatures;

    GroovyCurriedClosureType(@NotNull GroovyClosureType original, int position, @NotNull List<? extends Argument> arguments2, int curriedArgumentCount, @NotNull PsiElement context) {
        if (original == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(0);
        }
        if (arguments2 == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(2);
        }
        super(context);
        this.myOriginal = original;
        this.myPosition = position;
        this.myArguments = arguments2;
        this.myCurriedArgumentCount = curriedArgumentCount;
        this.mySignatures = FunctionsKt.recursionAwareLazy(() -> ContainerUtil.mapNotNull(this.myOriginal.getSignatures(), this::curry));
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myOriginal.isValid();
    }

    @NotNull
    public List<CallSignature<?>> getSignatures() {
        List list = (List)this.mySignatures.getValue();
        if (list == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private CallSignature<?> curry(CallSignature<?> original) {
        int position;
        if (original.isVararg()) {
            return new CurriedSignature(original, this.myPosition, this.myArguments);
        }
        int n = position = this.myPosition < 0 ? this.myPosition + original.getParameterCount() - this.myCurriedArgumentCount : this.myPosition;
        if (position < 0) {
            return null;
        }
        return new CurriedSignature(original, position, this.myArguments);
    }

    @Override
    @NotNull
    public PsiType curry(int position, @NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        if (arguments2 == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GroovyCurriedClosureType.$$$reportNull$$$0(5);
        }
        return new GroovyCurriedClosureType(this, position, arguments2, this.myCurriedArgumentCount + this.myArguments.size(), context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/typing/GroovyCurriedClosureType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/typing/GroovyCurriedClosureType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "curry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

