/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonData;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class ComparisonFailureData {
    public static final String JUNIT_3_COMPARISON_FAILURE = "junit.framework.ComparisonFailure";
    public static final String JUNIT_4_COMPARISON_FAILURE = "org.junit.ComparisonFailure";
    private static final String JUNIT_COMPARISON_FAILURE_EXPECTED = "fExpected";
    private static final String JUNIT_COMPARISON_FAILURE_ACTUAL = "fActual";
    private static final String ASSERTION_CLASS_NAME = "java.lang.AssertionError";
    private static final String ASSERTION_FAILED_CLASS_NAME = "junit.framework.AssertionFailedError";
    private static final String OPENTEST4J_ASSERTION = "org.opentest4j.AssertionFailedError";
    private static final String OPENTEST4J_ASSERTION_EXPECTED_DEFINED = "isExpectedDefined";
    private static final String OPENTEST4J_ASSERTION_ACTUAL_DEFINED = "isActualDefined";
    private static final String OPENTEST4J_ASSERTION_EXPECTED = "getExpected";
    private static final String OPENTEST4J_ASSERTION_ACTUAL = "getActual";
    private static final String OPENTEST4J_VALUE_WRAPPER = "org.opentest4j.ValueWrapper";
    private static final String OPENTEST4J_VALUE_WRAPPER_VALUE = "getValue";
    private static final String OPENTEST4J_VALUE_WRAPPER_STRING_REPRESENTATION = "getStringRepresentation";
    private static final String OPENTEST4J_FILE_INFO = "org.opentest4j.FileInfo";
    private static final String OPENTEST4J_FILE_INFO_PATH = "getPath";
    private static final String OPENTEST4J_FILE_INFO_CONTENT_AS_STRING = "getContentsAsString";
    private static final Charset OPENTEST4J_FILE_CONTENT_CHARSET = StandardCharsets.UTF_8;
    private final String myExpected;
    private final String myActual;
    private final String myExpectedFilePath;
    private final String myActualFilePath;
    private static final Map<Class<?>, Field> EXPECTED = new HashMap();
    private static final Map<Class<?>, Field> ACTUAL = new HashMap();

    private static void init(String exceptionClassName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> exceptionClass = Class.forName(exceptionClassName, false, ComparisonFailureData.class.getClassLoader());
        Field expectedField = exceptionClass.getDeclaredField(JUNIT_COMPARISON_FAILURE_EXPECTED);
        expectedField.setAccessible(true);
        EXPECTED.put(exceptionClass, expectedField);
        Field actualField = exceptionClass.getDeclaredField(JUNIT_COMPARISON_FAILURE_ACTUAL);
        actualField.setAccessible(true);
        ACTUAL.put(exceptionClass, actualField);
    }

    public ComparisonFailureData(AssertionValue expected, AssertionValue actual) {
        this(expected.text, actual.text, expected.path, actual.path);
    }

    public ComparisonFailureData(String expected, String actual) {
        this(expected, actual, null);
    }

    public ComparisonFailureData(String expected, String actual, String expectedFilePath) {
        this(expected, actual, expectedFilePath, null);
    }

    public ComparisonFailureData(String expected, String actual, String expectedFilePath, String actualFilePath) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myExpectedFilePath = expectedFilePath != null ? new File(expectedFilePath).getAbsolutePath() : null;
        this.myActualFilePath = actualFilePath != null ? new File(actualFilePath).getAbsolutePath() : null;
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map<String, String> attrs, Throwable throwable) {
        ComparisonFailureData.registerSMAttributes(notification, trace, failureMessage, attrs, throwable, "Comparison Failure: ", "expected:<");
    }

    public static void registerSMAttributes(ComparisonFailureData notification, String trace, String failureMessage, Map<String, String> attrs, Throwable throwable, String comparisonFailurePrefix, String expectedPrefix) {
        String details;
        int failureIdx = failureMessage != null ? trace.indexOf(failureMessage) : -1;
        int failureMessageLength = failureMessage != null ? failureMessage.length() : 0;
        String string = details = failureIdx > -1 ? trace.substring(failureIdx + failureMessageLength) : trace;
        if (notification != null) {
            int expectedIdx = trace.indexOf(expectedPrefix);
            String comparisonFailureMessage = expectedIdx > 0 ? trace.substring(0, expectedIdx) : (failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessageLength > 0 ? failureMessage + "\n" : "") + comparisonFailurePrefix);
            if (!attrs.containsKey("message")) {
                attrs.put("message", comparisonFailureMessage);
            }
            String expectedFilePath = notification.getExpectedFilePath();
            String actualFilePath = notification.getActualFilePath();
            String expected = notification.getExpected();
            String actual = notification.getActual();
            int fullLength = (expectedFilePath == null && expected != null ? expected.length() : 0) + (actualFilePath == null && actual != null ? actual.length() : 0) + details.length() + comparisonFailureMessage.length() + 100;
            if (expectedFilePath != null) {
                attrs.put("expectedFile", expectedFilePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "expected", expected, fullLength);
            }
            if (actualFilePath != null) {
                attrs.put("actualFile", actualFilePath);
            } else {
                ComparisonFailureData.writeDiffSide(attrs, "actual", actual, fullLength);
            }
        } else {
            Throwable throwableCause = null;
            try {
                throwableCause = throwable.getCause();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            if (!ComparisonFailureData.isAssertionError(throwable.getClass()) && !ComparisonFailureData.isAssertionError(throwableCause != null ? throwableCause.getClass() : null)) {
                attrs.put("error", "true");
            }
            attrs.put("message", failureIdx > -1 ? trace.substring(0, failureIdx + failureMessageLength) : (failureMessage != null ? failureMessage : ""));
        }
        attrs.put("details", details);
    }

    private static void writeDiffSide(Map<String, String> attrs, String expectedOrActualPrefix, String text, int fullLength) {
        int threshold;
        String property = System.getProperty("idea.test.cyclic.buffer.size");
        try {
            threshold = Integer.parseInt(property);
        }
        catch (NumberFormatException ignored) {
            threshold = -1;
        }
        if (threshold > 0 && fullLength > threshold) {
            try {
                File tempFile = File.createTempFile(expectedOrActualPrefix, "");
                try (OutputStream stream = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                    stream.write(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
                }
                attrs.put(expectedOrActualPrefix + "File", tempFile.getAbsolutePath());
                attrs.put(expectedOrActualPrefix + "IsTempFile", "true");
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        attrs.put(expectedOrActualPrefix, text);
    }

    public static boolean isInstance(Class<?> aClass, String className) {
        if (aClass == null) {
            return false;
        }
        if (className.equals(aClass.getName())) {
            return true;
        }
        return ComparisonFailureData.isInstance(aClass.getSuperclass(), className);
    }

    public static boolean isAssertionError(Class<?> throwableClass) {
        return ComparisonFailureData.isInstance(throwableClass, ASSERTION_CLASS_NAME) || ComparisonFailureData.isInstance(throwableClass, ASSERTION_FAILED_CLASS_NAME) || ComparisonFailureData.isInstance(throwableClass, OPENTEST4J_ASSERTION);
    }

    public static boolean isComparisonFailure(Class<?> aClass) {
        return ComparisonFailureData.isInstance(aClass, JUNIT_3_COMPARISON_FAILURE) || ComparisonFailureData.isInstance(aClass, JUNIT_4_COMPARISON_FAILURE) || ComparisonFailureData.isInstance(aClass, OPENTEST4J_ASSERTION);
    }

    public String getExpectedFilePath() {
        return this.myExpectedFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public static ComparisonFailureData create(Throwable assertion) {
        ComparisonFailureData failureData = ComparisonFailureData.createFileComparisonData(assertion);
        if (failureData != null) {
            return failureData;
        }
        failureData = ComparisonFailureData.createJunitComparisonFailure(assertion);
        if (failureData != null) {
            return failureData;
        }
        failureData = ComparisonFailureData.createOpentest4jAssertion(assertion);
        return failureData;
    }

    private static ComparisonFailureData createFileComparisonData(Throwable assertion) {
        if (assertion instanceof FileComparisonData) {
            FileComparisonData comparisonFailure = (FileComparisonData)((Object)assertion);
            String actual = comparisonFailure.getActualStringPresentation();
            String expected = comparisonFailure.getExpectedStringPresentation();
            if (actual != null && expected != null) {
                return new ComparisonFailureData(expected, actual, comparisonFailure.getFilePath(), comparisonFailure.getActualFilePath());
            }
        }
        return null;
    }

    private static ComparisonFailureData createOpentest4jAssertion(Throwable assertion) {
        try {
            if (ComparisonFailureData.isInstance(assertion.getClass(), OPENTEST4J_ASSERTION)) {
                Method isExpectedDefinedMethod = assertion.getClass().getMethod(OPENTEST4J_ASSERTION_EXPECTED_DEFINED, new Class[0]);
                Method isActualDefinedMethod = assertion.getClass().getMethod(OPENTEST4J_ASSERTION_ACTUAL_DEFINED, new Class[0]);
                boolean isExpectedDefined = (Boolean)isExpectedDefinedMethod.invoke((Object)assertion, new Object[0]);
                boolean isActualDefined = (Boolean)isActualDefinedMethod.invoke((Object)assertion, new Object[0]);
                if (isExpectedDefined && isActualDefined) {
                    Method expectedMethod = assertion.getClass().getMethod(OPENTEST4J_ASSERTION_EXPECTED, new Class[0]);
                    Method actualMethod = assertion.getClass().getMethod(OPENTEST4J_ASSERTION_ACTUAL, new Class[0]);
                    Object expectedValueWrapper = expectedMethod.invoke((Object)assertion, new Object[0]);
                    Object actualValueWrapper = actualMethod.invoke((Object)assertion, new Object[0]);
                    AssertionValue expected = ComparisonFailureData.getOpentest4jAssertionValue(expectedValueWrapper);
                    AssertionValue actual = ComparisonFailureData.getOpentest4jAssertionValue(actualValueWrapper);
                    return new ComparisonFailureData(expected, actual);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static AssertionValue getOpentest4jAssertionValue(Object valueWrapper) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (ComparisonFailureData.isInstance(valueWrapper.getClass(), OPENTEST4J_VALUE_WRAPPER)) {
            Method valueMethod = valueWrapper.getClass().getMethod(OPENTEST4J_VALUE_WRAPPER_VALUE, new Class[0]);
            Object value = valueMethod.invoke(valueWrapper, new Object[0]);
            if (value != null && ComparisonFailureData.isInstance(value.getClass(), OPENTEST4J_FILE_INFO)) {
                Method contentAsStringMethod = value.getClass().getMethod(OPENTEST4J_FILE_INFO_CONTENT_AS_STRING, Charset.class);
                String valueString = (String)contentAsStringMethod.invoke(value, OPENTEST4J_FILE_CONTENT_CHARSET);
                Method pathMethod = value.getClass().getMethod(OPENTEST4J_FILE_INFO_PATH, new Class[0]);
                String valuePath = (String)pathMethod.invoke(value, new Object[0]);
                return new AssertionValue(valueString, valuePath);
            }
            Method stringRepresentationMethod = valueWrapper.getClass().getMethod(OPENTEST4J_VALUE_WRAPPER_STRING_REPRESENTATION, new Class[0]);
            String valueString = (String)stringRepresentationMethod.invoke(valueWrapper, new Object[0]);
            return new AssertionValue(valueString, null);
        }
        return null;
    }

    private static ComparisonFailureData createJunitComparisonFailure(Throwable assertion) {
        try {
            String expected = ComparisonFailureData.getExpected(assertion);
            String actual = ComparisonFailureData.getActual(assertion);
            return new ComparisonFailureData(expected, actual);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static String getActual(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, ACTUAL, JUNIT_COMPARISON_FAILURE_ACTUAL);
    }

    public static String getExpected(Throwable assertion) throws IllegalAccessException, NoSuchFieldException {
        return ComparisonFailureData.get(assertion, EXPECTED, JUNIT_COMPARISON_FAILURE_EXPECTED);
    }

    private static String get(Throwable assertion, Map<Class<?>, Field> staticMap, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Class<?> assertionClass = assertion.getClass();
        for (Class<?> comparisonClass : staticMap.keySet()) {
            if (!comparisonClass.isAssignableFrom(assertionClass)) continue;
            return (String)staticMap.get(comparisonClass).get(assertion);
        }
        Field field = assertionClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (String)field.get(assertion);
    }

    static {
        try {
            ComparisonFailureData.init(JUNIT_3_COMPARISON_FAILURE);
            ComparisonFailureData.init(JUNIT_4_COMPARISON_FAILURE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class AssertionValue {
        public final String text;
        public final String path;

        public AssertionValue(String text, String path) {
            this.text = text;
            this.path = path;
        }
    }
}

