/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0016\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u00060\u0003j\u0002`\u0004H&J*\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\n0\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH&J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H&J\b\u0010\u001e\u001a\u00020\u0011H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/vcs/log/data/VcsLogStorage;", "", "getCommitIndex", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCommitId", "Lcom/intellij/vcs/log/CommitId;", "commitIndex", "getCommitIds", "", "commitIds", "", "iterateCommits", "", "consumer", "Ljava/util/function/Predicate;", "containsCommit", "", "id", "findCommitId", "condition", "getRefIndex", "ref", "Lcom/intellij/vcs/log/VcsRef;", "getVcsRef", "refIndex", "flush", "intellij.platform.vcs.log.impl"})
public interface VcsLogStorage {
    public int getCommitIndex(@NotNull Hash var1, @NotNull VirtualFile var2);

    @Nullable
    public CommitId getCommitId(int var1);

    @NotNull
    default public Map<Integer, CommitId> getCommitIds(@NotNull Collection<Integer> commitIds2) {
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        Iterator<Integer> iterator = commitIds2.iterator();
        while (iterator.hasNext()) {
            CommitId it;
            int commitIndex = ((Number)iterator.next()).intValue();
            if (this.getCommitId(commitIndex) == null) continue;
            boolean bl = false;
            CommitId cfr_ignored_0 = (CommitId)result.put(commitIndex, (Object)it);
        }
        return (Map)result;
    }

    public void iterateCommits(@NotNull Predicate<? super CommitId> var1);

    public boolean containsCommit(@NotNull CommitId var1);

    @Nullable
    default public CommitId findCommitId(@NotNull Predicate<? super CommitId> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Ref.ObjectRef result = new Ref.ObjectRef();
        this.iterateCommits(arg_0 -> VcsLogStorage.findCommitId$lambda$1(arg_0 -> VcsLogStorage.findCommitId$lambda$0(condition, result, arg_0), arg_0));
        return (CommitId)result.element;
    }

    public int getRefIndex(@NotNull VcsRef var1);

    @Nullable
    public VcsRef getVcsRef(int var1);

    public void flush();

    private static boolean findCommitId$lambda$0(Predicate $condition, Ref.ObjectRef $result, CommitId commitId) {
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        boolean matches = $condition.test(commitId);
        if (matches) {
            $result.element = commitId;
        }
        return !matches;
    }

    private static boolean findCommitId$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

