/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.List;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.io.AbstractPrimitiveTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.tools.I18n;

public class DownloadPrimitivesTask
extends AbstractPrimitiveTask {
    private final List<PrimitiveId> ids;

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation) {
        this(layer, ids, fullRelation, null);
    }

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation, ProgressMonitor progressMonitor) {
        super(I18n.tr("Download objects", new Object[0]), progressMonitor, layer);
        this.ids = ids;
        this.setZoom(true);
        this.setDownloadRelations(fullRelation);
    }

    @Override
    protected void initMultiFetchReader(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to download ...", new Object[0]));
        reader.setRecurseDownRelations(this.fullRelation);
        if (this.ids != null) {
            this.ids.forEach(reader::append);
        }
    }
}

