/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.tuple;

import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class TupleResultAssembler<J>
implements DomainResultAssembler<J> {
    private final int[] valuesArrayPositions;
    private final JavaType<J> assembledJavaType;

    public TupleResultAssembler(int[] valuesArrayPositions, JavaType<J> assembledJavaType) {
        this.valuesArrayPositions = valuesArrayPositions;
        this.assembledJavaType = assembledJavaType;
    }

    public int[] getValuesArrayPositions() {
        return this.valuesArrayPositions;
    }

    public Object[] extractRawValue(RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.valuesArrayPositions.length];
        for (int i = 0; i < this.valuesArrayPositions.length; ++i) {
            values[i] = rowProcessingState.getJdbcValue(this.valuesArrayPositions[i]);
        }
        return values;
    }

    @Override
    public J assemble(RowProcessingState rowProcessingState) {
        Object[] jdbcValues = this.extractRawValue(rowProcessingState);
        if (ResultsLogger.RESULTS_MESSAGE_LOGGER.isTraceEnabled()) {
            for (int i = 0; i < this.valuesArrayPositions.length; ++i) {
                ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("Extracted JDBC value [%d] - [%s]", this.valuesArrayPositions[i], jdbcValues[i]);
            }
        }
        return (J)jdbcValues;
    }

    @Override
    public JavaType<J> getAssembledJavaType() {
        return this.assembledJavaType;
    }
}

