/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.CodeImpl;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.Util;

public class AbstractBoundLocalVariable
extends AbstractElement
implements Util.WritableLocalVariable {
    protected final CodeImpl code;
    protected final int offset;
    private Utf8Entry nameEntry;
    private Utf8Entry secondaryEntry;

    public AbstractBoundLocalVariable(CodeImpl code, int offset) {
        this.code = code;
        this.offset = offset;
    }

    protected int nameIndex() {
        return this.code.classReader.readU2(this.offset + 4);
    }

    public Utf8Entry name() {
        if (this.nameEntry == null) {
            this.nameEntry = this.code.constantPool().entryByIndex(this.nameIndex(), Utf8Entry.class);
        }
        return this.nameEntry;
    }

    protected int secondaryIndex() {
        return this.code.classReader.readU2(this.offset + 6);
    }

    protected Utf8Entry secondaryEntry() {
        if (this.secondaryEntry == null) {
            this.secondaryEntry = this.code.constantPool().entryByIndex(this.secondaryIndex(), Utf8Entry.class);
        }
        return this.secondaryEntry;
    }

    public Label startScope() {
        return this.code.getLabel(this.startPc());
    }

    public Label endScope() {
        return this.code.getLabel(this.startPc() + this.length());
    }

    public int startPc() {
        return this.code.classReader.readU2(this.offset);
    }

    public int length() {
        return this.code.classReader.readU2(this.offset + 2);
    }

    public int slot() {
        return this.code.classReader.readU2(this.offset + 8);
    }

    @Override
    public boolean writeLocalTo(BufWriterImpl b) {
        LabelContext lc = b.labelContext();
        int startBci = lc.labelToBci(this.startScope());
        int endBci = lc.labelToBci(this.endScope());
        if (startBci == -1 || endBci == -1) {
            return false;
        }
        int length = endBci - startBci;
        b.writeU2U2(startBci, length);
        if (b.canWriteDirect(this.code.constantPool())) {
            b.writeU2U2(this.nameIndex(), this.secondaryIndex());
        } else {
            b.writeU2U2(b.cpIndex(this.name()), b.cpIndex(this.secondaryEntry()));
        }
        b.writeU2(this.slot());
        return true;
    }
}

