/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.languagetool.ExtendedSentenceRange;
import org.languagetool.Range;
import org.languagetool.SentenceRange;
import org.languagetool.rules.RuleMatch;

public class CheckResults {
    private List<RuleMatch> ruleMatches;
    private final List<Range> ignoredRanges;
    private final List<ExtendedSentenceRange> extendedSentenceRanges;
    private final List<SentenceRange> sentenceRanges = new ArrayList<SentenceRange>();

    public CheckResults(List<RuleMatch> ruleMatches, List<Range> ignoredRanges) {
        this(ruleMatches, ignoredRanges, Collections.emptyList());
    }

    public CheckResults(List<RuleMatch> ruleMatches, List<Range> ignoredRanges, List<ExtendedSentenceRange> extendedSentenceRanges) {
        this.ruleMatches = Objects.requireNonNull(ruleMatches);
        this.ignoredRanges = Objects.requireNonNull(ignoredRanges);
        this.extendedSentenceRanges = Objects.requireNonNull(extendedSentenceRanges.stream().sorted().collect(Collectors.toList()));
    }

    @NotNull
    public List<SentenceRange> getSentenceRanges() {
        return Collections.unmodifiableList(this.sentenceRanges);
    }

    public void addSentenceRanges(List<SentenceRange> sentenceRanges) {
        this.sentenceRanges.addAll(sentenceRanges);
    }

    public void setRuleMatches(List<RuleMatch> ruleMatches) {
        this.ruleMatches = Objects.requireNonNull(ruleMatches);
    }

    @Generated
    public List<RuleMatch> getRuleMatches() {
        return this.ruleMatches;
    }

    @Generated
    public List<Range> getIgnoredRanges() {
        return this.ignoredRanges;
    }

    @Generated
    public List<ExtendedSentenceRange> getExtendedSentenceRanges() {
        return this.extendedSentenceRanges;
    }
}

