/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

public class CustomPopup
extends Popup
implements WindowFocusListener,
ComponentListener {
    private JWindow displayWindow;
    private CustomPopupCloseListener optionalCustomPopupCloseListener;
    private Window topWindow;
    private boolean enableHideWhenFocusIsLost = false;

    public CustomPopup(Component contentsComponent, Window topWindow, CustomPopupCloseListener optionalCustomPopupCloseListener, Border optionalBorder) {
        this.topWindow = topWindow;
        this.optionalCustomPopupCloseListener = optionalCustomPopupCloseListener;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add(contentsComponent, "Center");
        if (optionalBorder == null) {
            LineBorder outsideBorder = new LineBorder(new Color(99, 130, 191));
            MatteBorder insideBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.white);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
            mainPanel.setBorder(compoundBorder);
        } else {
            mainPanel.setBorder(optionalBorder);
        }
        this.displayWindow = new JWindow(topWindow);
        this.displayWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                CustomPopup.this.enableHideWhenFocusIsLost = true;
            }
        });
        this.displayWindow.getContentPane().add(mainPanel);
        this.displayWindow.setFocusable(true);
        this.displayWindow.setAlwaysOnTop(true);
        this.displayWindow.pack();
        this.displayWindow.validate();
        String cancelName = "cancel";
        InputMap inputMap = mainPanel.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = mainPanel.getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPopup.this.hide();
            }
        });
        this.registerListeners();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.hide();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.hide();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.hide();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public Rectangle getBounds() {
        return this.displayWindow.getBounds();
    }

    @Override
    public void hide() {
        if (this.displayWindow != null) {
            this.displayWindow.setVisible(false);
            this.displayWindow.removeWindowFocusListener(this);
            this.displayWindow = null;
        }
        if (this.topWindow != null) {
            this.topWindow.removeComponentListener(this);
            this.topWindow = null;
        }
        if (this.optionalCustomPopupCloseListener != null) {
            this.optionalCustomPopupCloseListener.zEventCustomPopupWasClosed(this);
            this.optionalCustomPopupCloseListener = null;
        }
    }

    private void registerListeners() {
        this.displayWindow.addWindowFocusListener(this);
        this.topWindow.addComponentListener(this);
    }

    public void setLocation(int popupX, int popupY) {
        this.displayWindow.setLocation(popupX, popupY);
    }

    @Override
    public void show() {
        this.displayWindow.setVisible(true);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (!this.enableHideWhenFocusIsLost) {
            e.getWindow().requestFocus();
            return;
        }
        if (InternalUtilities.isMouseWithinComponent(this.displayWindow)) {
            return;
        }
        this.hide();
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.displayWindow.setMinimumSize(minimumSize);
    }

    public static interface CustomPopupCloseListener {
        public void zEventCustomPopupWasClosed(CustomPopup var1);
    }
}

