/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing.oracle;

import java.sql.Connection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.routing.oracle.OracleShardRoutingCache;
import oracle.ucp.routing.oracle.ShardManager;

public class ShardManagerImpl
implements ShardManager {
    private OracleShardRoutingCache shardRoutingCache;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    public ShardManagerImpl(ONS ons, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        this.shardRoutingCache = new OracleShardRoutingCache(ons, diagnosticsCollector);
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    @Override
    public void connectionOpened(Connection conn, JDBCConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.shardRoutingCache.onConnectionCreation(conn, cri);
    }

    @Override
    public Set<RACInstance> getInstancesForShardKey(JDBCConnectionRetrievalInfo cri) {
        return this.shardRoutingCache.getInstancesForShardKey(cri).stream().map(inst -> new RACInstanceImpl(inst.service(), inst.name(), inst.host(), inst.database())).collect(Collectors.toSet());
    }
}

