/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.repository;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.index.store.StoreFileMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/replication/action/repository/GetFileChunkResponse;", "Lorg/opensearch/core/action/ActionResponse;", "storeFileMetadata", "Lorg/opensearch/index/store/StoreFileMetadata;", "offset", "", "data", "Lorg/opensearch/core/common/bytes/BytesReference;", "<init>", "(Lorg/opensearch/index/store/StoreFileMetadata;JLorg/opensearch/core/common/bytes/BytesReference;)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getStoreFileMetadata", "()Lorg/opensearch/index/store/StoreFileMetadata;", "getOffset", "()J", "getData", "()Lorg/opensearch/core/common/bytes/BytesReference;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
public final class GetFileChunkResponse
extends ActionResponse {
    @NotNull
    private final StoreFileMetadata storeFileMetadata;
    private final long offset;
    @NotNull
    private final BytesReference data;

    @NotNull
    public final StoreFileMetadata getStoreFileMetadata() {
        return this.storeFileMetadata;
    }

    public final long getOffset() {
        return this.offset;
    }

    @NotNull
    public final BytesReference getData() {
        return this.data;
    }

    public GetFileChunkResponse(@NotNull StoreFileMetadata storeFileMetadata, long offset, @NotNull BytesReference data) {
        Intrinsics.checkNotNullParameter((Object)storeFileMetadata, (String)"storeFileMetadata");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.storeFileMetadata = storeFileMetadata;
        this.offset = offset;
        this.data = data;
    }

    public GetFileChunkResponse(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.storeFileMetadata = new StoreFileMetadata(inp);
        this.offset = inp.readLong();
        BytesReference bytesReference = inp.readBytesReference();
        Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"readBytesReference(...)");
        this.data = bytesReference;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.storeFileMetadata.writeTo(out);
        out.writeLong(this.offset);
        out.writeBytesReference(this.data);
    }
}

