/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class Ip2GeoSettings {
    public static final Setting<String> DATASOURCE_ENDPOINT = Setting.simpleString((String)"plugins.geospatial.ip2geo.datasource.endpoint", (String)"https://geoip.maps.opensearch.org/v1/geolite2-city/manifest.json", (Setting.Validator)new DatasourceEndpointValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> DATASOURCE_UPDATE_INTERVAL = Setting.longSetting((String)"plugins.geospatial.ip2geo.datasource.update_interval_in_days", (long)3L, (long)1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> BATCH_SIZE = Setting.intSetting((String)"plugins.geospatial.ip2geo.datasource.batch_size", (int)10000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> TIMEOUT = Setting.timeSetting((String)"plugins.geospatial.ip2geo.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"plugins.geospatial.ip2geo.processor.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<List<String>> DATASOURCE_ENDPOINT_DENYLIST = Setting.listSetting((String)"plugins.geospatial.ip2geo.datasource.endpoint.denylist", Arrays.asList("127.0.0.0/8", "169.254.0.0/16", "10.0.0.0/8", "172.16.0.0/12", "192.168.0.0/16", "0.0.0.0/8", "100.64.0.0/10", "192.0.0.0/24", "192.0.2.0/24", "198.18.0.0/15", "192.88.99.0/24", "198.51.100.0/24", "203.0.113.0/24", "224.0.0.0/4", "240.0.0.0/4", "255.255.255.255/32", "::1/128", "fe80::/10", "fc00::/7", "::/128", "2001:db8::/32", "ff00::/8"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public static final List<Setting<?>> settings() {
        return List.of(DATASOURCE_ENDPOINT, DATASOURCE_UPDATE_INTERVAL, BATCH_SIZE, TIMEOUT, CACHE_SIZE, DATASOURCE_ENDPOINT_DENYLIST);
    }

    protected static class DatasourceEndpointValidator
    implements Setting.Validator<String> {
        protected DatasourceEndpointValidator() {
        }

        public void validate(String value) {
            try {
                URI.create(value).toURL().toURI();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URL format is provided");
            }
        }
    }
}

