/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelState;

public final class ModelUtil {
    public static void blockCommasInModelDescription(String description) {
        if (description.contains(",")) {
            throw new IllegalArgumentException("Model description cannot contain any commas: ','");
        }
    }

    public static boolean isModelPresent(ModelMetadata modelMetadata) {
        return modelMetadata != null;
    }

    public static boolean isModelCreated(ModelMetadata modelMetadata) {
        if (!ModelUtil.isModelPresent(modelMetadata)) {
            return false;
        }
        return modelMetadata.getState().equals((Object)ModelState.CREATED);
    }

    public static ModelMetadata getModelMetadata(String modelId) {
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return null;
        }
        ModelDao.OpenSearchKNNModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();
        ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
        if (!ModelUtil.isModelCreated(modelMetadata)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model ID '%s' is not created.", modelId));
        }
        return modelMetadata;
    }

    @Generated
    private ModelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

