/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

public class PropertyException
extends RuntimeException {
    private final String instanceName;
    private final String propertyName;
    private final String msg;

    public PropertyException(String instanceName, String msg) {
        this(null, instanceName, null, msg);
    }

    public PropertyException(String instanceName, String propertyName, String msg) {
        this(null, instanceName, propertyName, msg);
    }

    public PropertyException(Throwable cause, String msg) {
        this(cause, null, null, msg);
    }

    public PropertyException(Throwable cause, String instanceName, String msg) {
        this(cause, instanceName, null, msg);
    }

    public PropertyException(Throwable cause, String instanceName, String propertyName, String msg) {
        super(cause);
        this.instanceName = instanceName;
        this.propertyName = propertyName;
        this.msg = cause != null ? msg + " (caused by " + cause.getMessage() + ")" : msg;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.instanceName != null && !this.instanceName.isEmpty()) {
            sb.append("Component: ");
            sb.append(this.instanceName);
            sb.append(", ");
        }
        if (this.propertyName != null && !this.propertyName.isEmpty()) {
            sb.append("Property: ");
            sb.append(this.propertyName);
            sb.append(", ");
        }
        sb.append(this.msg);
        return sb.toString();
    }

    public String getProperty() {
        return this.propertyName;
    }

    @Override
    public String toString() {
        if (this.instanceName != null) {
            if (this.propertyName != null) {
                return "Property Exception component:'" + this.instanceName + "' property:'" + this.propertyName + "' - " + this.msg + '\n' + super.toString();
            }
            return "Property Exception component:'" + this.instanceName + "' - " + this.msg + '\n' + super.toString();
        }
        return "Property Exception - " + this.msg + '\n' + super.toString();
    }
}

