/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class HkdfExtractOutput {
    private final ByteBuffer prk;

    protected HkdfExtractOutput(BuilderImpl builder) {
        this.prk = builder.prk();
    }

    public ByteBuffer prk() {
        return this.prk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer prk;

        protected BuilderImpl() {
        }

        protected BuilderImpl(HkdfExtractOutput model) {
            this.prk = model.prk();
        }

        @Override
        public Builder prk(ByteBuffer prk) {
            this.prk = prk;
            return this;
        }

        @Override
        public ByteBuffer prk() {
            return this.prk;
        }

        @Override
        public HkdfExtractOutput build() {
            if (Objects.isNull(this.prk())) {
                throw new IllegalArgumentException("Missing value for required field `prk`");
            }
            return new HkdfExtractOutput(this);
        }
    }

    public static interface Builder {
        public Builder prk(ByteBuffer var1);

        public ByteBuffer prk();

        public HkdfExtractOutput build();
    }
}

