# ----------------------------------------------------------------------------
#
#  Copyright (C) 2023 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import sys
import signal
import globdef as G
from PyQt6 import QtGui, QtCore, QtWidgets
sys.path.append ('..')
from controls import *
from utils.buttonbase import *


class Mainwindow (QtWidgets.QWidget):


    def __init__(self, nchan, bfilt, label = 'Bandpass'): 
        super (Mainwindow, self).__init__()
        
        # Init main window.
        self.setWindowTitle (label)
        self.nchan = nchan
        self.bfilt = bfilt
        self.move (100, 100)
        self.setFixedSize (145, 100)

        # Button styles.
        pal = self.palette () 
        bgc = pal.color (pal.ColorRole.Window)
        bstyle = ButtonStyle (24, 19, bgc, [G.FG_N,G.COL4,G.COL5], [G.MK_N,G.COL0,G.COL0], G.BUT_FONT, 9)
        rstyle = RotaryStyle (17, bgc, [G.FG_N,G.COL4], [G.MK_N,G.COL0])

        self.hpfreq = 5e2
        self.lpfreq = 2e3
        
        R = Rlogctl (self, rstyle, 20.0, 20e3, 120, 4);
        R.move (20, 8)
        R.valueEvent.connect (self.hpsetval)
        R.set_value (self.hpfreq)
        L = QtWidgets.QLabel (self)
        L.setFont (G.VAL_FONT)
        L.setGeometry (15, 48, 50, 19)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignCenter)
        B = ButtonBase (self, bstyle, True, 0)
        B.set_text ("HP")
        B.move (28, 73)
        B.set_state (0)
        B.bpressEvent.connect (self.hponoff)
        self.hpbut = B
        self.hpctl = R
        self.hplabel = L
        
        R = Rlogctl (self, rstyle, 20.0, 20e3, 120, 4);
        R.move (80, 8)
        R.valueEvent.connect (self.lpsetval)
        R.set_value (self.lpfreq)
        L = QtWidgets.QLabel (self)
        L.setFont (G.VAL_FONT)
        L.setGeometry (75, 48, 50, 19)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignCenter)
        B = ButtonBase (self, bstyle, True, 0)
        B.set_text ("LP")
        B.move (88, 73)
        B.set_state (0)
        B.bpressEvent.connect (self.lponoff)
        self.lpbut = B
        self.lpctl = R
        self.lplabel = L

        self.hpsetval (self.hpctl)
        self.lpsetval (self.lpctl)

        self.show ()

        
    def hponoff (self, args):
        s = self.hpbut.get_state () ^ 1
        self.hpbut.set_state (s)
        self.setfilter ()
        
    def hpsetval (self, R):
        self.hpfreq = R.get_value ()
        self.hplabel.setText (self.valtext (self.hpfreq))
        self.setfilter ()
        
    def lponoff (self, args):
        s = self.lpbut.get_state () ^ 1
        self.lpbut.set_state (s)
        self.setfilter ()

    def lpsetval (self, R):
        self.lpfreq = R.get_value ()
        self.lplabel.setText (self.valtext (self.lpfreq))
        self.setfilter ()

    def valtext (self, v):
        if (v <= 1e2): return "%3.1f" % (v,)
        if (v <= 1e3): return "%3.0f" % (v,)
        if (v <= 1e4): return "%4.2fk" % (1e-3 * v,)
        return "%4.1fk" % (1e-3 * v,)

    def setfilter (self):
        lpf = hpf = 0
        if self.lpbut.get_state (): lpf = self.lpfreq
        if self.hpbut.get_state (): hpf = self.hpfreq
        for i in range (self.nchan):
            self.bfilt.set_filter (i, i, hpf, lpf)
    
