/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.pdfparser.ConformingPDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.persistence.util.COSObjectKey;

public class ConformingPDDocument
extends PDDocument {
    private final Map<COSObjectKey, COSBase> objectPool = new HashMap<COSObjectKey, COSBase>();
    private ConformingPDFParser parser = null;

    public ConformingPDDocument() throws IOException {
    }

    public ConformingPDDocument(COSDocument doc) throws IOException {
        super(doc);
    }

    public static PDDocument load(File input) throws IOException {
        ConformingPDFParser parser = new ConformingPDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    public COSBase getObjectFromPool(COSObjectKey key) throws IOException {
        return this.objectPool.get(key);
    }

    public List<COSObjectKey> getObjectKeysFromPool() throws IOException {
        ArrayList<COSObjectKey> keys = new ArrayList<COSObjectKey>();
        for (COSObjectKey key : this.objectPool.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public COSBase getObjectFromPool(long number, long generation) throws IOException {
        return this.objectPool.get(new COSObjectKey(number, generation));
    }

    public void putObjectInPool(COSBase object, long number, long generation) {
        this.objectPool.put(new COSObjectKey(number, generation), object);
    }

    public ConformingPDFParser getParser() {
        return this.parser;
    }

    public void setParser(ConformingPDFParser parser) {
        this.parser = parser;
    }
}

