/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *  - Ignacy Kuchciński <ignacykuchcinski@gnome.org>
 */

#pragma once

#include <adwaita.h>
#include <libmalcontent/malcontent.h>
#include <polkit/polkit.h>

G_BEGIN_DECLS

#define MCT_TYPE_ACCESS_PAGE (mct_access_page_get_type ())
G_DECLARE_FINAL_TYPE (MctAccessPage, mct_access_page, MCT, ACCESS_PAGE, AdwNavigationPage)

MctAccessPage *mct_access_page_new (void);

MctUser *mct_access_page_get_user (MctAccessPage *self);
void mct_access_page_set_user (MctAccessPage *self, MctUser *user, GPermission *permission);

G_END_DECLS
