// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_marshaling_guest
//
// (header) generated by ../mesa-25.3.1/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.1/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.1/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/lib32-mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "vk_platform_compat.h"

#include "goldfish_vk_marshaling_guest.h"
#include "goldfish_vk_private_defs.h"
#include "VulkanStreamGuest.h"

// Stuff we are not going to use but if included,
// will cause compile errors. These are Android Vulkan
// required extensions, but the approach will be to
// implement them completely on the guest side.
#undef VK_KHR_android_surface
#undef VK_ANDROID_external_memory_android_hardware_buffer


namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
void marshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent2D* forMarshaling);

void unmarshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtent2D* forUnmarshaling);

void marshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent3D* forMarshaling);

void unmarshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtent3D* forUnmarshaling);

void marshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset2D* forMarshaling);

void unmarshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkOffset2D* forUnmarshaling);

void marshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset3D* forMarshaling);

void unmarshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkOffset3D* forUnmarshaling);

void marshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRect2D* forMarshaling);

void unmarshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRect2D* forUnmarshaling);

void marshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseInStructure* forMarshaling);

void unmarshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBaseInStructure* forUnmarshaling);

void marshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseOutStructure* forMarshaling);

void unmarshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBaseOutStructure* forUnmarshaling);

void marshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* forMarshaling);

void unmarshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryBarrier* forUnmarshaling);

void marshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* forMarshaling);

void unmarshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDispatchIndirectCommand* forUnmarshaling);

void marshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* forMarshaling);

void unmarshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrawIndexedIndirectCommand* forUnmarshaling);

void marshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndirectCommand* forMarshaling);

void unmarshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrawIndirectCommand* forUnmarshaling);

void marshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceRange* forMarshaling);

void unmarshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresourceRange* forUnmarshaling);

void marshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier* forMarshaling);

void unmarshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryBarrier* forUnmarshaling);

void marshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier* forMarshaling);

void unmarshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryBarrier* forUnmarshaling);

void marshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* forMarshaling);

void unmarshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCacheHeaderVersionOne* forUnmarshaling);

void marshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAllocationCallbacks* forMarshaling);

void unmarshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAllocationCallbacks* forUnmarshaling);

void marshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkApplicationInfo* forMarshaling);

void unmarshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkApplicationInfo* forUnmarshaling);

void marshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties* forMarshaling);

void unmarshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties* forUnmarshaling);

void marshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties* forMarshaling);

void unmarshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatProperties* forUnmarshaling);

void marshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInstanceCreateInfo* forMarshaling);

void unmarshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkInstanceCreateInfo* forUnmarshaling);

void marshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryHeap* forMarshaling);

void unmarshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryHeap* forUnmarshaling);

void marshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryType* forMarshaling);

void unmarshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryType* forUnmarshaling);

void marshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* forMarshaling);

void unmarshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLimits* forUnmarshaling);

void marshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSparseProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProperties* forUnmarshaling);

void marshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties* forMarshaling);

void unmarshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyProperties* forUnmarshaling);

#define OP_vkCreateInstance 20000
#define OP_vkDestroyInstance 20001
#define OP_vkEnumeratePhysicalDevices 20002
#define OP_vkGetPhysicalDeviceFeatures 20003
#define OP_vkGetPhysicalDeviceFormatProperties 20004
#define OP_vkGetPhysicalDeviceImageFormatProperties 20005
#define OP_vkGetPhysicalDeviceProperties 20006
#define OP_vkGetPhysicalDeviceQueueFamilyProperties 20007
#define OP_vkGetPhysicalDeviceMemoryProperties 20008
#define OP_vkGetInstanceProcAddr 20009
#define OP_vkGetDeviceProcAddr 20010
void marshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* forMarshaling);

void unmarshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueCreateInfo* forUnmarshaling);

void marshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceCreateInfo* forMarshaling);

void unmarshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceCreateInfo* forUnmarshaling);

#define OP_vkCreateDevice 20011
#define OP_vkDestroyDevice 20012
void marshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtensionProperties* forMarshaling);

void unmarshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExtensionProperties* forUnmarshaling);

#define OP_vkEnumerateInstanceExtensionProperties 20013
#define OP_vkEnumerateDeviceExtensionProperties 20014
void marshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkLayerProperties* forMarshaling);

void unmarshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkLayerProperties* forUnmarshaling);

#define OP_vkEnumerateInstanceLayerProperties 20015
#define OP_vkEnumerateDeviceLayerProperties 20016
void marshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo* forMarshaling);

void unmarshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubmitInfo* forUnmarshaling);

#define OP_vkGetDeviceQueue 20017
#define OP_vkQueueSubmit 20018
#define OP_vkQueueWaitIdle 20019
#define OP_vkDeviceWaitIdle 20020
void marshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMappedMemoryRange* forMarshaling);

void unmarshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMappedMemoryRange* forUnmarshaling);

void marshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* forMarshaling);

void unmarshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryAllocateInfo* forUnmarshaling);

#define OP_vkAllocateMemory 20021
#define OP_vkFreeMemory 20022
#define OP_vkMapMemory 20023
#define OP_vkUnmapMemory 20024
#define OP_vkFlushMappedMemoryRanges 20025
#define OP_vkInvalidateMappedMemoryRanges 20026
#define OP_vkGetDeviceMemoryCommitment 20027
void marshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements* forMarshaling);

void unmarshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryRequirements* forUnmarshaling);

#define OP_vkBindBufferMemory 20028
#define OP_vkBindImageMemory 20029
#define OP_vkGetBufferMemoryRequirements 20030
#define OP_vkGetImageMemoryRequirements 20031
void marshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseMemoryBind* forMarshaling);

void unmarshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseMemoryBind* forUnmarshaling);

void marshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* forMarshaling);

void unmarshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseBufferMemoryBindInfo* forUnmarshaling);

void marshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* forMarshaling);

void unmarshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageOpaqueMemoryBindInfo* forUnmarshaling);

void marshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource* forMarshaling);

void unmarshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresource* forUnmarshaling);

void marshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* forMarshaling);

void unmarshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryBind* forUnmarshaling);

void marshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* forMarshaling);

void unmarshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryBindInfo* forUnmarshaling);

void marshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindSparseInfo* forMarshaling);

void unmarshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindSparseInfo* forUnmarshaling);

void marshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* forMarshaling);

void unmarshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageFormatProperties* forUnmarshaling);

void marshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* forMarshaling);

void unmarshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryRequirements* forUnmarshaling);

#define OP_vkGetImageSparseMemoryRequirements 20032
#define OP_vkGetPhysicalDeviceSparseImageFormatProperties 20033
#define OP_vkQueueBindSparse 20034
void marshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceCreateInfo* forMarshaling);

void unmarshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFenceCreateInfo* forUnmarshaling);

#define OP_vkCreateFence 20035
#define OP_vkDestroyFence 20036
#define OP_vkResetFences 20037
#define OP_vkGetFenceStatus 20038
#define OP_vkWaitForFences 20039
void marshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* forMarshaling);

void unmarshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreCreateInfo* forUnmarshaling);

#define OP_vkCreateSemaphore 20040
#define OP_vkDestroySemaphore 20041
void marshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkEventCreateInfo* forMarshaling);

void unmarshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkEventCreateInfo* forUnmarshaling);

#define OP_vkCreateEvent 20042
#define OP_vkDestroyEvent 20043
#define OP_vkGetEventStatus 20044
#define OP_vkSetEvent 20045
#define OP_vkResetEvent 20046
void marshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* forMarshaling);

void unmarshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueryPoolCreateInfo* forUnmarshaling);

#define OP_vkCreateQueryPool 20047
#define OP_vkDestroyQueryPool 20048
#define OP_vkGetQueryPoolResults 20049
void marshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCreateInfo* forMarshaling);

void unmarshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCreateInfo* forUnmarshaling);

#define OP_vkCreateBuffer 20050
#define OP_vkDestroyBuffer 20051
void marshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* forMarshaling);

void unmarshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferViewCreateInfo* forUnmarshaling);

#define OP_vkCreateBufferView 20052
#define OP_vkDestroyBufferView 20053
void marshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCreateInfo* forMarshaling);

void unmarshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCreateInfo* forUnmarshaling);

void marshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout* forMarshaling);

void unmarshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceLayout* forUnmarshaling);

#define OP_vkCreateImage 20054
#define OP_vkDestroyImage 20055
#define OP_vkGetImageSubresourceLayout 20056
void marshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComponentMapping* forMarshaling);

void unmarshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkComponentMapping* forUnmarshaling);

void marshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewCreateInfo* forMarshaling);

void unmarshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageViewCreateInfo* forUnmarshaling);

#define OP_vkCreateImageView 20057
#define OP_vkDestroyImageView 20058
void marshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* forMarshaling);

void unmarshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkShaderModuleCreateInfo* forUnmarshaling);

#define OP_vkCreateShaderModule 20059
#define OP_vkDestroyShaderModule 20060
void marshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* forMarshaling);

void unmarshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCacheCreateInfo* forUnmarshaling);

#define OP_vkCreatePipelineCache 20061
#define OP_vkDestroyPipelineCache 20062
#define OP_vkGetPipelineCacheData 20063
#define OP_vkMergePipelineCaches 20064
void marshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationMapEntry* forMarshaling);

void unmarshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSpecializationMapEntry* forUnmarshaling);

void marshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationInfo* forMarshaling);

void unmarshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSpecializationInfo* forUnmarshaling);

void marshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* forMarshaling);

void unmarshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineShaderStageCreateInfo* forUnmarshaling);

void marshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* forMarshaling);

void unmarshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkComputePipelineCreateInfo* forUnmarshaling);

void marshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* forMarshaling);

void unmarshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputBindingDescription* forUnmarshaling);

void marshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* forMarshaling);

void unmarshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputAttributeDescription* forUnmarshaling);

void marshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineVertexInputStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineInputAssemblyStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineTessellationStateCreateInfo* forUnmarshaling);

void marshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkViewport* forMarshaling);

void unmarshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkViewport* forUnmarshaling);

void marshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineViewportStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineMultisampleStateCreateInfo* forUnmarshaling);

void marshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkStencilOpState* forMarshaling);

void unmarshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkStencilOpState* forUnmarshaling);

void marshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineDepthStencilStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* forMarshaling);

void unmarshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorBlendAttachmentState* forUnmarshaling);

void marshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorBlendStateCreateInfo* forUnmarshaling);

void marshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineDynamicStateCreateInfo* forUnmarshaling);

void marshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* forMarshaling);

void unmarshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkGraphicsPipelineCreateInfo* forUnmarshaling);

#define OP_vkCreateGraphicsPipelines 20065
#define OP_vkCreateComputePipelines 20066
#define OP_vkDestroyPipeline 20067
void marshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantRange* forMarshaling);

void unmarshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushConstantRange* forUnmarshaling);

void marshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* forMarshaling);

void unmarshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineLayoutCreateInfo* forUnmarshaling);

#define OP_vkCreatePipelineLayout 20068
#define OP_vkDestroyPipelineLayout 20069
void marshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCreateInfo* forMarshaling);

void unmarshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerCreateInfo* forUnmarshaling);

#define OP_vkCreateSampler 20070
#define OP_vkDestroySampler 20071
void marshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyDescriptorSet* forMarshaling);

void unmarshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyDescriptorSet* forUnmarshaling);

void marshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* forMarshaling);

void unmarshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorBufferInfo* forUnmarshaling);

void marshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorImageInfo* forMarshaling);

void unmarshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorImageInfo* forUnmarshaling);

void marshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolSize* forMarshaling);

void unmarshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolSize* forUnmarshaling);

void marshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* forMarshaling);

void unmarshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolCreateInfo* forUnmarshaling);

void marshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* forMarshaling);

void unmarshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetAllocateInfo* forUnmarshaling);

void marshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* forMarshaling);

void unmarshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutBinding* forUnmarshaling);

void marshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* forMarshaling);

void unmarshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutCreateInfo* forUnmarshaling);

void marshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSet* forMarshaling);

void unmarshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkWriteDescriptorSet* forUnmarshaling);

#define OP_vkCreateDescriptorSetLayout 20072
#define OP_vkDestroyDescriptorSetLayout 20073
#define OP_vkCreateDescriptorPool 20074
#define OP_vkDestroyDescriptorPool 20075
#define OP_vkResetDescriptorPool 20076
#define OP_vkAllocateDescriptorSets 20077
#define OP_vkFreeDescriptorSets 20078
#define OP_vkUpdateDescriptorSets 20079
void marshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription* forMarshaling);

void unmarshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescription* forUnmarshaling);

void marshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference* forMarshaling);

void unmarshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReference* forUnmarshaling);

void marshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* forMarshaling);

void unmarshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferCreateInfo* forUnmarshaling);

void marshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription* forMarshaling);

void unmarshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescription* forUnmarshaling);

void marshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency* forMarshaling);

void unmarshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDependency* forUnmarshaling);

void marshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* forMarshaling);

void unmarshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassCreateInfo* forUnmarshaling);

#define OP_vkCreateFramebuffer 20080
#define OP_vkDestroyFramebuffer 20081
#define OP_vkCreateRenderPass 20082
#define OP_vkDestroyRenderPass 20083
#define OP_vkGetRenderAreaGranularity 20084
void marshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* forMarshaling);

void unmarshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandPoolCreateInfo* forUnmarshaling);

#define OP_vkCreateCommandPool 20085
#define OP_vkDestroyCommandPool 20086
#define OP_vkResetCommandPool 20087
void marshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* forMarshaling);

void unmarshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferAllocateInfo* forUnmarshaling);

void marshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* forMarshaling);

void unmarshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferInheritanceInfo* forUnmarshaling);

void marshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* forMarshaling);

void unmarshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferBeginInfo* forUnmarshaling);

#define OP_vkAllocateCommandBuffers 20088
#define OP_vkFreeCommandBuffers 20089
#define OP_vkBeginCommandBuffer 20090
#define OP_vkEndCommandBuffer 20091
#define OP_vkResetCommandBuffer 20092
void marshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy* forMarshaling);

void unmarshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCopy* forUnmarshaling);

void marshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceLayers* forMarshaling);

void unmarshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresourceLayers* forUnmarshaling);

void marshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy* forMarshaling);

void unmarshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferImageCopy* forUnmarshaling);

void marshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearColorValue* forMarshaling);

void unmarshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearColorValue* forUnmarshaling);

void marshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearDepthStencilValue* forMarshaling);

void unmarshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearDepthStencilValue* forUnmarshaling);

void marshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearValue* forMarshaling);

void unmarshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearValue* forUnmarshaling);

void marshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearAttachment* forMarshaling);

void unmarshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearAttachment* forUnmarshaling);

void marshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearRect* forMarshaling);

void unmarshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkClearRect* forUnmarshaling);

void marshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit* forMarshaling);

void unmarshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageBlit* forUnmarshaling);

void marshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy* forMarshaling);

void unmarshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCopy* forUnmarshaling);

void marshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve* forMarshaling);

void unmarshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageResolve* forUnmarshaling);

void marshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* forMarshaling);

void unmarshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassBeginInfo* forUnmarshaling);

#define OP_vkCmdBindPipeline 20093
#define OP_vkCmdSetViewport 20094
#define OP_vkCmdSetScissor 20095
#define OP_vkCmdSetLineWidth 20096
#define OP_vkCmdSetDepthBias 20097
#define OP_vkCmdSetBlendConstants 20098
#define OP_vkCmdSetDepthBounds 20099
#define OP_vkCmdSetStencilCompareMask 20100
#define OP_vkCmdSetStencilWriteMask 20101
#define OP_vkCmdSetStencilReference 20102
#define OP_vkCmdBindDescriptorSets 20103
#define OP_vkCmdBindIndexBuffer 20104
#define OP_vkCmdBindVertexBuffers 20105
#define OP_vkCmdDraw 20106
#define OP_vkCmdDrawIndexed 20107
#define OP_vkCmdDrawIndirect 20108
#define OP_vkCmdDrawIndexedIndirect 20109
#define OP_vkCmdDispatch 20110
#define OP_vkCmdDispatchIndirect 20111
#define OP_vkCmdCopyBuffer 20112
#define OP_vkCmdCopyImage 20113
#define OP_vkCmdBlitImage 20114
#define OP_vkCmdCopyBufferToImage 20115
#define OP_vkCmdCopyImageToBuffer 20116
#define OP_vkCmdUpdateBuffer 20117
#define OP_vkCmdFillBuffer 20118
#define OP_vkCmdClearColorImage 20119
#define OP_vkCmdClearDepthStencilImage 20120
#define OP_vkCmdClearAttachments 20121
#define OP_vkCmdResolveImage 20122
#define OP_vkCmdSetEvent 20123
#define OP_vkCmdResetEvent 20124
#define OP_vkCmdWaitEvents 20125
#define OP_vkCmdPipelineBarrier 20126
#define OP_vkCmdBeginQuery 20127
#define OP_vkCmdEndQuery 20128
#define OP_vkCmdResetQueryPool 20129
#define OP_vkCmdWriteTimestamp 20130
#define OP_vkCmdCopyQueryPoolResults 20131
#define OP_vkCmdPushConstants 20132
#define OP_vkCmdBeginRenderPass 20133
#define OP_vkCmdNextSubpass 20134
#define OP_vkCmdEndRenderPass 20135
#define OP_vkCmdExecuteCommands 20136
#endif
#ifdef VK_VERSION_1_1
#define OP_vkEnumerateInstanceVersion 20137
void marshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupProperties* forUnmarshaling);

void marshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* forMarshaling);

void unmarshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindBufferMemoryInfo* forUnmarshaling);

void marshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* forMarshaling);

void unmarshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImageMemoryInfo* forUnmarshaling);

#define OP_vkBindBufferMemory2 20138
#define OP_vkBindImageMemory2 20139
void marshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* forMarshaling);

void unmarshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice16BitStorageFeatures* forUnmarshaling);

void marshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* forMarshaling);

void unmarshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryDedicatedRequirements* forUnmarshaling);

void marshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* forMarshaling);

void unmarshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryDedicatedAllocateInfo* forUnmarshaling);

void marshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* forMarshaling);

void unmarshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryAllocateFlagsInfo* forUnmarshaling);

void marshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* forMarshaling);

void unmarshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupRenderPassBeginInfo* forUnmarshaling);

void marshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* forMarshaling);

void unmarshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupCommandBufferBeginInfo* forUnmarshaling);

void marshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* forMarshaling);

void unmarshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupSubmitInfo* forUnmarshaling);

void marshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* forMarshaling);

void unmarshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupBindSparseInfo* forUnmarshaling);

#define OP_vkGetDeviceGroupPeerMemoryFeatures 20140
#define OP_vkCmdSetDeviceMask 20141
#define OP_vkCmdDispatchBase 20142
void marshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* forMarshaling);

void unmarshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindBufferMemoryDeviceGroupInfo* forUnmarshaling);

void marshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* forMarshaling);

void unmarshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImageMemoryDeviceGroupInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGroupProperties* forUnmarshaling);

void marshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* forMarshaling);

void unmarshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceGroupDeviceCreateInfo* forUnmarshaling);

#define OP_vkEnumeratePhysicalDeviceGroups 20143
void marshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* forMarshaling);

void unmarshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryRequirementsInfo2* forUnmarshaling);

void marshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* forMarshaling);

void unmarshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryRequirementsInfo2* forUnmarshaling);

void marshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* forMarshaling);

void unmarshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSparseMemoryRequirementsInfo2* forUnmarshaling);

void marshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements2* forMarshaling);

void unmarshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryRequirements2* forUnmarshaling);

void marshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* forMarshaling);

void unmarshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageMemoryRequirements2* forUnmarshaling);

#define OP_vkGetImageMemoryRequirements2 20144
#define OP_vkGetBufferMemoryRequirements2 20145
#define OP_vkGetImageSparseMemoryRequirements2 20146
void marshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* forMarshaling);

void unmarshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFeatures2* forUnmarshaling);

void marshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* forMarshaling);

void unmarshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProperties2* forUnmarshaling);

void marshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties2* forMarshaling);

void unmarshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties2* forUnmarshaling);

void marshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties2* forMarshaling);

void unmarshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatProperties2* forUnmarshaling);

void marshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* forMarshaling);

void unmarshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageFormatInfo2* forUnmarshaling);

void marshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* forMarshaling);

void unmarshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyProperties2* forUnmarshaling);

void marshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* forMarshaling);

void unmarshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties2* forUnmarshaling);

void marshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* forMarshaling);

void unmarshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSparseImageFormatProperties2* forUnmarshaling);

void marshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* forMarshaling);

void unmarshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSparseImageFormatInfo2* forUnmarshaling);

#define OP_vkGetPhysicalDeviceFeatures2 20147
#define OP_vkGetPhysicalDeviceProperties2 20148
#define OP_vkGetPhysicalDeviceFormatProperties2 20149
#define OP_vkGetPhysicalDeviceImageFormatProperties2 20150
#define OP_vkGetPhysicalDeviceQueueFamilyProperties2 20151
#define OP_vkGetPhysicalDeviceMemoryProperties2 20152
#define OP_vkGetPhysicalDeviceSparseImageFormatProperties2 20153
#define OP_vkTrimCommandPool 20154
void marshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* forMarshaling);

void unmarshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePointClippingProperties* forUnmarshaling);

void marshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* forMarshaling);

void unmarshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkInputAttachmentAspectReference* forUnmarshaling);

void marshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* forMarshaling);

void unmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassInputAttachmentAspectCreateInfo* forUnmarshaling);

void marshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* forMarshaling);

void unmarshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageViewUsageCreateInfo* forUnmarshaling);

void marshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineTessellationDomainOriginStateCreateInfo* forUnmarshaling);

void marshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* forMarshaling);

void unmarshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassMultiviewCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMultiviewFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMultiviewProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVariablePointersFeatures* forUnmarshaling);

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceVariablePointersFeatures, marshal_VkPhysicalDeviceVariablePointerFeatures)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceVariablePointersFeatures, unmarshal_VkPhysicalDeviceVariablePointerFeatures)

void marshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryProperties* forUnmarshaling);

void marshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* forMarshaling);

void unmarshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueInfo2* forUnmarshaling);

void marshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* forMarshaling);

void unmarshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkProtectedSubmitInfo* forUnmarshaling);

#define OP_vkGetDeviceQueue2 20155
void marshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* forMarshaling);

void unmarshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionCreateInfo* forUnmarshaling);

void marshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* forMarshaling);

void unmarshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionInfo* forUnmarshaling);

void marshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* forMarshaling);

void unmarshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindImagePlaneMemoryInfo* forUnmarshaling);

void marshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* forMarshaling);

void unmarshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImagePlaneMemoryRequirementsInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* forUnmarshaling);

void marshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* forMarshaling);

void unmarshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerYcbcrConversionImageFormatProperties* forUnmarshaling);

#define OP_vkCreateSamplerYcbcrConversion 20156
#define OP_vkDestroySamplerYcbcrConversion 20157
void marshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* forMarshaling);

void unmarshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorUpdateTemplateEntry* forUnmarshaling);

void marshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* forMarshaling);

void unmarshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorUpdateTemplateCreateInfo* forUnmarshaling);

#define OP_vkCreateDescriptorUpdateTemplate 20158
#define OP_vkDestroyDescriptorUpdateTemplate 20159
#define OP_vkUpdateDescriptorSetWithTemplate 20160
void marshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryProperties* forMarshaling);

void unmarshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* forMarshaling);

void unmarshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalImageFormatInfo* forUnmarshaling);

void marshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* forMarshaling);

void unmarshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalImageFormatProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* forMarshaling);

void unmarshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalBufferInfo* forUnmarshaling);

void marshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalBufferProperties* forMarshaling);

void unmarshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalBufferProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceIDProperties* forUnmarshaling);

#define OP_vkGetPhysicalDeviceExternalBufferProperties 20161
void marshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* forMarshaling);

void unmarshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryImageCreateInfo* forUnmarshaling);

void marshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* forMarshaling);

void unmarshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalMemoryBufferCreateInfo* forUnmarshaling);

void marshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* forMarshaling);

void unmarshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportMemoryAllocateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* forMarshaling);

void unmarshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalFenceInfo* forUnmarshaling);

void marshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalFenceProperties* forMarshaling);

void unmarshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalFenceProperties* forUnmarshaling);

#define OP_vkGetPhysicalDeviceExternalFenceProperties 20162
void marshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* forMarshaling);

void unmarshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportFenceCreateInfo* forUnmarshaling);

void marshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* forMarshaling);

void unmarshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExportSemaphoreCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* forMarshaling);

void unmarshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExternalSemaphoreInfo* forUnmarshaling);

void marshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* forMarshaling);

void unmarshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkExternalSemaphoreProperties* forUnmarshaling);

#define OP_vkGetPhysicalDeviceExternalSemaphoreProperties 20163
void marshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance3Properties* forUnmarshaling);

void marshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* forMarshaling);

void unmarshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutSupport* forUnmarshaling);

#define OP_vkGetDescriptorSetLayoutSupport 20164
void marshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderDrawParametersFeatures* forUnmarshaling);

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderDrawParametersFeatures, marshal_VkPhysicalDeviceShaderDrawParameterFeatures)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderDrawParametersFeatures, unmarshal_VkPhysicalDeviceShaderDrawParameterFeatures)

#endif
#ifdef VK_VERSION_1_2
void marshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan11Features* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan11Properties* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan12Features* forUnmarshaling);

void marshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkConformanceVersion* forMarshaling);

void unmarshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkConformanceVersion* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan12Properties* forUnmarshaling);

void marshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* forMarshaling);

void unmarshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageFormatListCreateInfo* forUnmarshaling);

#define OP_vkCmdDrawIndirectCount 282774587
#define OP_vkCmdDrawIndexedIndirectCount 245204359
void marshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription2* forMarshaling);

void unmarshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescription2* forUnmarshaling);

void marshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference2* forMarshaling);

void unmarshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReference2* forUnmarshaling);

void marshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription2* forMarshaling);

void unmarshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescription2* forUnmarshaling);

void marshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency2* forMarshaling);

void unmarshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDependency2* forUnmarshaling);

void marshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* forMarshaling);

void unmarshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassCreateInfo2* forUnmarshaling);

void marshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassBeginInfo* forMarshaling);

void unmarshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassBeginInfo* forUnmarshaling);

void marshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassEndInfo* forMarshaling);

void unmarshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassEndInfo* forUnmarshaling);

#define OP_vkCreateRenderPass2 279590827
#define OP_vkCmdBeginRenderPass2 235222847
#define OP_vkCmdNextSubpass2 244873750
#define OP_vkCmdEndRenderPass2 221297834
void marshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* forMarshaling);

void unmarshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice8BitStorageFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDriverProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderAtomicInt64Features* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderFloat16Int8Features* forUnmarshaling);

void marshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFloatControlsProperties* forUnmarshaling);

void marshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* forMarshaling);

void unmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingProperties* forUnmarshaling);

void marshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* forMarshaling);

void unmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* forUnmarshaling);

void marshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* forMarshaling);

void unmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* forUnmarshaling);

void marshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* forMarshaling);

void unmarshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubpassDescriptionDepthStencilResolve* forUnmarshaling);

void marshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDepthStencilResolveProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceScalarBlockLayoutFeatures* forUnmarshaling);

void marshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* forMarshaling);

void unmarshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageStencilUsageCreateInfo* forUnmarshaling);

void marshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* forMarshaling);

void unmarshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerReductionModeCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkanMemoryModelFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImagelessFramebufferFeatures* forUnmarshaling);

void marshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* forMarshaling);

void unmarshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferAttachmentImageInfo* forUnmarshaling);

void marshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* forMarshaling);

void unmarshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFramebufferAttachmentsCreateInfo* forUnmarshaling);

void marshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* forMarshaling);

void unmarshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassAttachmentBeginInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forUnmarshaling);

void marshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* forMarshaling);

void unmarshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentReferenceStencilLayout* forUnmarshaling);

void marshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* forMarshaling);

void unmarshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkAttachmentDescriptionStencilLayout* forUnmarshaling);

void marshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostQueryResetFeatures* forUnmarshaling);

#define OP_vkResetQueryPool 252097672
void marshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreProperties* forUnmarshaling);

void marshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* forMarshaling);

void unmarshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreTypeCreateInfo* forUnmarshaling);

void marshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* forMarshaling);

void unmarshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkTimelineSemaphoreSubmitInfo* forUnmarshaling);

void marshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* forMarshaling);

void unmarshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreWaitInfo* forUnmarshaling);

void marshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* forMarshaling);

void unmarshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreSignalInfo* forUnmarshaling);

#define OP_vkGetSemaphoreCounterValue 267066974
#define OP_vkWaitSemaphores 224777382
#define OP_vkSignalSemaphore 271024127
void marshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceBufferDeviceAddressFeatures* forUnmarshaling);

void marshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* forMarshaling);

void unmarshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferDeviceAddressInfo* forUnmarshaling);

void marshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* forMarshaling);

void unmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferOpaqueCaptureAddressCreateInfo* forUnmarshaling);

void marshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* forMarshaling);

void unmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryOpaqueCaptureAddressAllocateInfo* forUnmarshaling);

void marshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* forMarshaling);

void unmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceMemoryOpaqueCaptureAddressInfo* forUnmarshaling);

#define OP_vkGetBufferDeviceAddress 222632266
#define OP_vkGetBufferOpaqueCaptureAddress 230188231
#define OP_vkGetDeviceMemoryOpaqueCaptureAddress 260620079
#endif
#ifdef VK_VERSION_1_3
void marshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan13Features* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan13Properties* forUnmarshaling);

void marshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* forMarshaling);

void unmarshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreationFeedback* forUnmarshaling);

void marshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* forMarshaling);

void unmarshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreationFeedbackCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceToolProperties* forUnmarshaling);

#define OP_vkGetPhysicalDeviceToolProperties 286895278
void marshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forUnmarshaling);

void marshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* forMarshaling);

void unmarshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePrivateDataFeatures* forUnmarshaling);

void marshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* forMarshaling);

void unmarshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDevicePrivateDataCreateInfo* forUnmarshaling);

void marshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* forMarshaling);

void unmarshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPrivateDataSlotCreateInfo* forUnmarshaling);

#define OP_vkCreatePrivateDataSlot 262776916
#define OP_vkDestroyPrivateDataSlot 224520231
#define OP_vkSetPrivateData 242146991
#define OP_vkGetPrivateData 237052348
void marshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* forMarshaling);

void unmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* forUnmarshaling);

void marshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier2* forMarshaling);

void unmarshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryBarrier2* forUnmarshaling);

void marshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* forMarshaling);

void unmarshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferMemoryBarrier2* forUnmarshaling);

void marshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* forMarshaling);

void unmarshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageMemoryBarrier2* forUnmarshaling);

void marshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDependencyInfo* forMarshaling);

void unmarshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDependencyInfo* forUnmarshaling);

void marshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* forMarshaling);

void unmarshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreSubmitInfo* forUnmarshaling);

void marshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* forMarshaling);

void unmarshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferSubmitInfo* forUnmarshaling);

void marshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo2* forMarshaling);

void unmarshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubmitInfo2* forUnmarshaling);

void marshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* forMarshaling);

void unmarshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSynchronization2Features* forUnmarshaling);

#define OP_vkCmdSetEvent2 232259114
#define OP_vkCmdResetEvent2 271973131
#define OP_vkCmdWaitEvents2 244672720
#define OP_vkCmdPipelineBarrier2 296709912
#define OP_vkCmdWriteTimestamp2 246322283
#define OP_vkQueueSubmit2 275454371
void marshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageRobustnessFeatures* forUnmarshaling);

void marshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy2* forMarshaling);

void unmarshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferCopy2* forUnmarshaling);

void marshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferInfo2* forMarshaling);

void unmarshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyBufferInfo2* forUnmarshaling);

void marshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy2* forMarshaling);

void unmarshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCopy2* forUnmarshaling);

void marshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageInfo2* forMarshaling);

void unmarshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageInfo2* forUnmarshaling);

void marshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy2* forMarshaling);

void unmarshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferImageCopy2* forUnmarshaling);

void marshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* forMarshaling);

void unmarshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyBufferToImageInfo2* forUnmarshaling);

void marshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* forMarshaling);

void unmarshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToBufferInfo2* forUnmarshaling);

void marshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit2* forMarshaling);

void unmarshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageBlit2* forUnmarshaling);

void marshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBlitImageInfo2* forMarshaling);

void unmarshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBlitImageInfo2* forUnmarshaling);

void marshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve2* forMarshaling);

void unmarshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageResolve2* forUnmarshaling);

void marshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkResolveImageInfo2* forMarshaling);

void unmarshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkResolveImageInfo2* forUnmarshaling);

#define OP_vkCmdCopyBuffer2 236505336
#define OP_vkCmdCopyImage2 247540368
#define OP_vkCmdCopyBufferToImage2 267966219
#define OP_vkCmdCopyImageToBuffer2 215156661
#define OP_vkCmdBlitImage2 275239053
#define OP_vkCmdResolveImage2 282440329
void marshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlProperties* forUnmarshaling);

void marshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forMarshaling);

void unmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockProperties* forUnmarshaling);

void marshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* forMarshaling);

void unmarshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkWriteDescriptorSetInlineUniformBlock* forUnmarshaling);

void marshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* forMarshaling);

void unmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDescriptorPoolInlineUniformBlockCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forUnmarshaling);

void marshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* forMarshaling);

void unmarshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAttachmentInfo* forUnmarshaling);

void marshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInfo* forMarshaling);

void unmarshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingInfo* forUnmarshaling);

void marshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* forMarshaling);

void unmarshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRenderingCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDynamicRenderingFeatures* forUnmarshaling);

void marshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* forMarshaling);

void unmarshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCommandBufferInheritanceRenderingInfo* forUnmarshaling);

#define OP_vkCmdBeginRendering 294618673
#define OP_vkCmdEndRendering 220725158
#define OP_vkCmdSetCullMode 224605861
#define OP_vkCmdSetFrontFace 223122493
#define OP_vkCmdSetPrimitiveTopology 263054804
#define OP_vkCmdSetViewportWithCount 267390210
#define OP_vkCmdSetScissorWithCount 219934891
#define OP_vkCmdBindVertexBuffers2 258656493
#define OP_vkCmdSetDepthTestEnable 209714588
#define OP_vkCmdSetDepthWriteEnable 240260392
#define OP_vkCmdSetDepthCompareOp 245341736
#define OP_vkCmdSetDepthBoundsTestEnable 219709826
#define OP_vkCmdSetStencilTestEnable 286845216
#define OP_vkCmdSetStencilOp 235751186
void marshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentProperties* forUnmarshaling);

void marshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties3* forMarshaling);

void unmarshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFormatProperties3* forUnmarshaling);

#define OP_vkCmdSetRasterizerDiscardEnable 276298238
#define OP_vkCmdSetDepthBiasEnable 267154733
#define OP_vkCmdSetPrimitiveRestartEnable 230252008
void marshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Features* forUnmarshaling);

void marshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Properties* forUnmarshaling);

void marshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* forMarshaling);

void unmarshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceBufferMemoryRequirements* forUnmarshaling);

void marshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* forMarshaling);

void unmarshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceImageMemoryRequirements* forUnmarshaling);

#define OP_vkGetDeviceBufferMemoryRequirements 294177590
#define OP_vkGetDeviceImageMemoryRequirements 282480635
#define OP_vkGetDeviceImageSparseMemoryRequirements 233707261
#endif
#ifdef VK_VERSION_1_4
void marshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan14Features* forUnmarshaling);

void marshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVulkan14Properties* forUnmarshaling);

void marshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* forMarshaling);

void unmarshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceQueueGlobalPriorityCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* forUnmarshaling);

void marshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* forMarshaling);

void unmarshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkQueueFamilyGlobalPriorityProperties* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderFloatControls2Features* forUnmarshaling);

void marshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceShaderExpectAssumeFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationProperties* forUnmarshaling);

void marshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationLineStateCreateInfo* forUnmarshaling);

#define OP_vkCmdSetLineStipple 235403148
void marshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorProperties* forUnmarshaling);

void marshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* forMarshaling);

void unmarshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkVertexInputBindingDivisorDescription* forUnmarshaling);

void marshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* forMarshaling);

void unmarshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineVertexInputDivisorStateCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* forMarshaling);

void unmarshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceIndexTypeUint8Features* forUnmarshaling);

void marshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryMapInfo* forMarshaling);

void unmarshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryMapInfo* forUnmarshaling);

void marshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* forMarshaling);

void unmarshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryUnmapInfo* forUnmarshaling);

#define OP_vkMapMemory2 269932043
#define OP_vkUnmapMemory2 229872812
void marshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance5Features* forUnmarshaling);

void marshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance5Properties* forUnmarshaling);

void marshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAreaInfo* forMarshaling);

void unmarshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAreaInfo* forUnmarshaling);

void marshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource2* forMarshaling);

void unmarshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageSubresource2* forUnmarshaling);

void marshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* forMarshaling);

void unmarshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceImageSubresourceInfo* forUnmarshaling);

void marshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout2* forMarshaling);

void unmarshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceLayout2* forUnmarshaling);

void marshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* forMarshaling);

void unmarshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineCreateFlags2CreateInfo* forUnmarshaling);

void marshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* forMarshaling);

void unmarshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBufferUsageFlags2CreateInfo* forUnmarshaling);

#define OP_vkCmdBindIndexBuffer2 206158434
#define OP_vkGetRenderingAreaGranularity 214660941
#define OP_vkGetDeviceImageSubresourceLayout 216549053
#define OP_vkGetImageSubresourceLayout2 269545412
void marshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* forMarshaling);

void unmarshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePushDescriptorProperties* forUnmarshaling);

#define OP_vkCmdPushDescriptorSet 246922559
#define OP_vkCmdPushDescriptorSetWithTemplate 229886695
void marshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forUnmarshaling);

void marshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* forMarshaling);

void unmarshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingAttachmentLocationInfo* forUnmarshaling);

void marshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* forMarshaling);

void unmarshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingInputAttachmentIndexInfo* forUnmarshaling);

#define OP_vkCmdSetRenderingAttachmentLocations 204730753
#define OP_vkCmdSetRenderingInputAttachmentIndices 285610580
void marshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance6Features* forUnmarshaling);

void marshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* forMarshaling);

void unmarshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMaintenance6Properties* forUnmarshaling);

void marshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindMemoryStatus* forMarshaling);

void unmarshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindMemoryStatus* forUnmarshaling);

void marshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* forMarshaling);

void unmarshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkBindDescriptorSetsInfo* forUnmarshaling);

void marshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantsInfo* forMarshaling);

void unmarshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushConstantsInfo* forUnmarshaling);

void marshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* forMarshaling);

void unmarshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushDescriptorSetInfo* forUnmarshaling);

void marshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* forMarshaling);

void unmarshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPushDescriptorSetWithTemplateInfo* forUnmarshaling);

#define OP_vkCmdBindDescriptorSets2 281461882
#define OP_vkCmdPushConstants2 275905655
#define OP_vkCmdPushDescriptorSet2 269912858
#define OP_vkCmdPushDescriptorSetWithTemplate2 285015421
void marshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* forMarshaling);

void unmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineProtectedAccessFeatures* forUnmarshaling);

void marshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* forMarshaling);

void unmarshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineRobustnessFeatures* forUnmarshaling);

void marshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* forMarshaling);

void unmarshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineRobustnessProperties* forUnmarshaling);

void marshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* forMarshaling);

void unmarshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRobustnessCreateInfo* forUnmarshaling);

void marshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* forMarshaling);

void unmarshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostImageCopyFeatures* forUnmarshaling);

void marshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* forMarshaling);

void unmarshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceHostImageCopyProperties* forUnmarshaling);

void marshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryToImageCopy* forMarshaling);

void unmarshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkMemoryToImageCopy* forUnmarshaling);

void marshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageToMemoryCopy* forMarshaling);

void unmarshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageToMemoryCopy* forUnmarshaling);

void marshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* forMarshaling);

void unmarshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyMemoryToImageInfo* forUnmarshaling);

void marshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* forMarshaling);

void unmarshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToMemoryInfo* forUnmarshaling);

void marshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* forMarshaling);

void unmarshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCopyImageToImageInfo* forUnmarshaling);

void marshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* forMarshaling);

void unmarshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkHostImageLayoutTransitionInfo* forUnmarshaling);

void marshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* forMarshaling);

void unmarshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSubresourceHostMemcpySize* forUnmarshaling);

void marshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* forMarshaling);

void unmarshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkHostImageCopyDevicePerformanceQuery* forUnmarshaling);

#define OP_vkCopyMemoryToImage 263029492
#define OP_vkCopyImageToMemory 204990977
#define OP_vkCopyImageToImage 223491795
#define OP_vkTransitionImageLayout 252133608
#endif
#ifdef VK_KHR_dynamic_rendering
DEFINE_ALIAS_FUNCTION(marshal_VkRenderingInfo, marshal_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderingInfo, unmarshal_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkRenderingAttachmentInfo, marshal_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderingAttachmentInfo, unmarshal_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineRenderingCreateInfo, marshal_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineRenderingCreateInfo, unmarshal_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceDynamicRenderingFeatures, marshal_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceDynamicRenderingFeatures, unmarshal_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkCommandBufferInheritanceRenderingInfo, marshal_VkCommandBufferInheritanceRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCommandBufferInheritanceRenderingInfo, unmarshal_VkCommandBufferInheritanceRenderingInfoKHR)

#define OP_vkCmdBeginRenderingKHR 298092805
#define OP_vkCmdEndRenderingKHR 200651584
#endif
#ifdef VK_KHR_multiview
DEFINE_ALIAS_FUNCTION(marshal_VkRenderPassMultiviewCreateInfo, marshal_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderPassMultiviewCreateInfo, unmarshal_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMultiviewFeatures, marshal_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMultiviewFeatures, unmarshal_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMultiviewProperties, marshal_VkPhysicalDeviceMultiviewPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMultiviewProperties, unmarshal_VkPhysicalDeviceMultiviewPropertiesKHR)

#endif
#ifdef VK_KHR_get_physical_device_properties2
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceFeatures2, marshal_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceFeatures2, unmarshal_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceProperties2, marshal_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceProperties2, unmarshal_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkFormatProperties2, marshal_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkFormatProperties2, unmarshal_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageFormatProperties2, marshal_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageFormatProperties2, unmarshal_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceImageFormatInfo2, marshal_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceImageFormatInfo2, unmarshal_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkQueueFamilyProperties2, marshal_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkQueueFamilyProperties2, unmarshal_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMemoryProperties2, marshal_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMemoryProperties2, unmarshal_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSparseImageFormatProperties2, marshal_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSparseImageFormatProperties2, unmarshal_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceSparseImageFormatInfo2, marshal_VkPhysicalDeviceSparseImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceSparseImageFormatInfo2, unmarshal_VkPhysicalDeviceSparseImageFormatInfo2KHR)

#define OP_vkGetPhysicalDeviceFeatures2KHR 20198
#define OP_vkGetPhysicalDeviceProperties2KHR 20199
#define OP_vkGetPhysicalDeviceFormatProperties2KHR 20200
#define OP_vkGetPhysicalDeviceImageFormatProperties2KHR 20201
#define OP_vkGetPhysicalDeviceQueueFamilyProperties2KHR 20202
#define OP_vkGetPhysicalDeviceMemoryProperties2KHR 20203
#define OP_vkGetPhysicalDeviceSparseImageFormatProperties2KHR 20204
#endif
#ifdef VK_KHR_maintenance1
#define OP_vkTrimCommandPoolKHR 20208
#endif
#ifdef VK_KHR_external_memory_capabilities
DEFINE_ALIAS_FUNCTION(marshal_VkExternalMemoryProperties, marshal_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalMemoryProperties, unmarshal_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceExternalImageFormatInfo, marshal_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceExternalImageFormatInfo, unmarshal_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExternalImageFormatProperties, marshal_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalImageFormatProperties, unmarshal_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceExternalBufferInfo, marshal_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceExternalBufferInfo, unmarshal_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExternalBufferProperties, marshal_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalBufferProperties, unmarshal_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceIDProperties, marshal_VkPhysicalDeviceIDPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceIDProperties, unmarshal_VkPhysicalDeviceIDPropertiesKHR)

#define OP_vkGetPhysicalDeviceExternalBufferPropertiesKHR 20210
#endif
#ifdef VK_KHR_external_memory
DEFINE_ALIAS_FUNCTION(marshal_VkExternalMemoryImageCreateInfo, marshal_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalMemoryImageCreateInfo, unmarshal_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExternalMemoryBufferCreateInfo, marshal_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalMemoryBufferCreateInfo, unmarshal_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExportMemoryAllocateInfo, marshal_VkExportMemoryAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExportMemoryAllocateInfo, unmarshal_VkExportMemoryAllocateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_capabilities
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceExternalSemaphoreInfo, marshal_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceExternalSemaphoreInfo, unmarshal_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExternalSemaphoreProperties, marshal_VkExternalSemaphorePropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalSemaphoreProperties, unmarshal_VkExternalSemaphorePropertiesKHR)

#define OP_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR 20215
#endif
#ifdef VK_KHR_external_semaphore
DEFINE_ALIAS_FUNCTION(marshal_VkExportSemaphoreCreateInfo, marshal_VkExportSemaphoreCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExportSemaphoreCreateInfo, unmarshal_VkExportSemaphoreCreateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_fd
void marshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* forMarshaling);

void unmarshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportSemaphoreFdInfoKHR* forUnmarshaling);

void marshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* forMarshaling);

void unmarshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSemaphoreGetFdInfoKHR* forUnmarshaling);

#define OP_vkImportSemaphoreFdKHR 20218
#define OP_vkGetSemaphoreFdKHR 20219
#endif
#ifdef VK_KHR_shader_float16_int8
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderFloat16Int8Features, marshal_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderFloat16Int8Features, unmarshal_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderFloat16Int8Features, marshal_VkPhysicalDeviceFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderFloat16Int8Features, unmarshal_VkPhysicalDeviceFloat16Int8FeaturesKHR)

#endif
#ifdef VK_KHR_incremental_present
void marshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRectLayerKHR* forMarshaling);

void unmarshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRectLayerKHR* forUnmarshaling);

void marshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionKHR* forMarshaling);

void unmarshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPresentRegionKHR* forUnmarshaling);

void marshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionsKHR* forMarshaling);

void unmarshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPresentRegionsKHR* forUnmarshaling);

#endif
#ifdef VK_KHR_descriptor_update_template
DEFINE_ALIAS_FUNCTION(marshal_VkDescriptorUpdateTemplateEntry, marshal_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDescriptorUpdateTemplateEntry, unmarshal_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDescriptorUpdateTemplateCreateInfo, marshal_VkDescriptorUpdateTemplateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDescriptorUpdateTemplateCreateInfo, unmarshal_VkDescriptorUpdateTemplateCreateInfoKHR)

#define OP_vkCreateDescriptorUpdateTemplateKHR 20222
#define OP_vkDestroyDescriptorUpdateTemplateKHR 20223
#define OP_vkUpdateDescriptorSetWithTemplateKHR 20224
#endif
#ifdef VK_KHR_imageless_framebuffer
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceImagelessFramebufferFeatures, marshal_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceImagelessFramebufferFeatures, unmarshal_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkFramebufferAttachmentsCreateInfo, marshal_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkFramebufferAttachmentsCreateInfo, unmarshal_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkFramebufferAttachmentImageInfo, marshal_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkFramebufferAttachmentImageInfo, unmarshal_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkRenderPassAttachmentBeginInfo, marshal_VkRenderPassAttachmentBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderPassAttachmentBeginInfo, unmarshal_VkRenderPassAttachmentBeginInfoKHR)

#endif
#ifdef VK_KHR_create_renderpass2
DEFINE_ALIAS_FUNCTION(marshal_VkRenderPassCreateInfo2, marshal_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderPassCreateInfo2, unmarshal_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkAttachmentDescription2, marshal_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkAttachmentDescription2, unmarshal_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkAttachmentReference2, marshal_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkAttachmentReference2, unmarshal_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubpassDescription2, marshal_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubpassDescription2, unmarshal_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubpassDependency2, marshal_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubpassDependency2, unmarshal_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubpassBeginInfo, marshal_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubpassBeginInfo, unmarshal_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubpassEndInfo, marshal_VkSubpassEndInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubpassEndInfo, unmarshal_VkSubpassEndInfoKHR)

#define OP_vkCreateRenderPass2KHR 20225
#define OP_vkCmdBeginRenderPass2KHR 20226
#define OP_vkCmdNextSubpass2KHR 20227
#define OP_vkCmdEndRenderPass2KHR 20228
#endif
#ifdef VK_KHR_external_fence_capabilities
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceExternalFenceInfo, marshal_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceExternalFenceInfo, unmarshal_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkExternalFenceProperties, marshal_VkExternalFencePropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExternalFenceProperties, unmarshal_VkExternalFencePropertiesKHR)

#define OP_vkGetPhysicalDeviceExternalFencePropertiesKHR 20230
#endif
#ifdef VK_KHR_external_fence
DEFINE_ALIAS_FUNCTION(marshal_VkExportFenceCreateInfo, marshal_VkExportFenceCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkExportFenceCreateInfo, unmarshal_VkExportFenceCreateInfoKHR)

#endif
#ifdef VK_KHR_external_fence_fd
void marshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* forMarshaling);

void unmarshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportFenceFdInfoKHR* forUnmarshaling);

void marshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* forMarshaling);

void unmarshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkFenceGetFdInfoKHR* forUnmarshaling);

#define OP_vkImportFenceFdKHR 20233
#define OP_vkGetFenceFdKHR 20234
#endif
#ifdef VK_KHR_maintenance2
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDevicePointClippingProperties, marshal_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDevicePointClippingProperties, unmarshal_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkRenderPassInputAttachmentAspectCreateInfo, marshal_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderPassInputAttachmentAspectCreateInfo, unmarshal_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkInputAttachmentAspectReference, marshal_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkInputAttachmentAspectReference, unmarshal_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageViewUsageCreateInfo, marshal_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageViewUsageCreateInfo, unmarshal_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineTessellationDomainOriginStateCreateInfo, marshal_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineTessellationDomainOriginStateCreateInfo, unmarshal_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

#endif
#ifdef VK_KHR_dedicated_allocation
DEFINE_ALIAS_FUNCTION(marshal_VkMemoryDedicatedRequirements, marshal_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryDedicatedRequirements, unmarshal_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkMemoryDedicatedAllocateInfo, marshal_VkMemoryDedicatedAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryDedicatedAllocateInfo, unmarshal_VkMemoryDedicatedAllocateInfoKHR)

#endif
#ifdef VK_KHR_get_memory_requirements2
DEFINE_ALIAS_FUNCTION(marshal_VkBufferMemoryRequirementsInfo2, marshal_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferMemoryRequirementsInfo2, unmarshal_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageMemoryRequirementsInfo2, marshal_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageMemoryRequirementsInfo2, unmarshal_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageSparseMemoryRequirementsInfo2, marshal_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageSparseMemoryRequirementsInfo2, unmarshal_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkMemoryRequirements2, marshal_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryRequirements2, unmarshal_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSparseImageMemoryRequirements2, marshal_VkSparseImageMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSparseImageMemoryRequirements2, unmarshal_VkSparseImageMemoryRequirements2KHR)

#define OP_vkGetImageMemoryRequirements2KHR 20241
#define OP_vkGetBufferMemoryRequirements2KHR 20242
#define OP_vkGetImageSparseMemoryRequirements2KHR 20243
#endif
#ifdef VK_KHR_image_format_list
DEFINE_ALIAS_FUNCTION(marshal_VkImageFormatListCreateInfo, marshal_VkImageFormatListCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageFormatListCreateInfo, unmarshal_VkImageFormatListCreateInfoKHR)

#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
DEFINE_ALIAS_FUNCTION(marshal_VkSamplerYcbcrConversionCreateInfo, marshal_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSamplerYcbcrConversionCreateInfo, unmarshal_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSamplerYcbcrConversionInfo, marshal_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSamplerYcbcrConversionInfo, unmarshal_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBindImagePlaneMemoryInfo, marshal_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBindImagePlaneMemoryInfo, unmarshal_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImagePlaneMemoryRequirementsInfo, marshal_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImagePlaneMemoryRequirementsInfo, unmarshal_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures, marshal_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures, unmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSamplerYcbcrConversionImageFormatProperties, marshal_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSamplerYcbcrConversionImageFormatProperties, unmarshal_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

#define OP_vkCreateSamplerYcbcrConversionKHR 20244
#define OP_vkDestroySamplerYcbcrConversionKHR 20245
#endif
#ifdef VK_KHR_bind_memory2
DEFINE_ALIAS_FUNCTION(marshal_VkBindBufferMemoryInfo, marshal_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBindBufferMemoryInfo, unmarshal_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBindImageMemoryInfo, marshal_VkBindImageMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBindImageMemoryInfo, unmarshal_VkBindImageMemoryInfoKHR)

#define OP_vkBindBufferMemory2KHR 20246
#define OP_vkBindImageMemory2KHR 20247
#endif
#ifdef VK_KHR_maintenance3
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMaintenance3Properties, marshal_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMaintenance3Properties, unmarshal_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDescriptorSetLayoutSupport, marshal_VkDescriptorSetLayoutSupportKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDescriptorSetLayoutSupport, unmarshal_VkDescriptorSetLayoutSupportKHR)

#define OP_vkGetDescriptorSetLayoutSupportKHR 20248
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, marshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, unmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

#endif
#ifdef VK_KHR_global_priority
DEFINE_ALIAS_FUNCTION(marshal_VkDeviceQueueGlobalPriorityCreateInfo, marshal_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDeviceQueueGlobalPriorityCreateInfo, unmarshal_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceGlobalPriorityQueryFeatures, marshal_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures, unmarshal_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkQueueFamilyGlobalPriorityProperties, marshal_VkQueueFamilyGlobalPriorityPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkQueueFamilyGlobalPriorityProperties, unmarshal_VkQueueFamilyGlobalPriorityPropertiesKHR)

#endif
#ifdef VK_KHR_vulkan_memory_model
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceVulkanMemoryModelFeatures, marshal_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures, unmarshal_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

#endif
#ifdef VK_KHR_shader_terminate_invocation
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderTerminateInvocationFeatures, marshal_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures, unmarshal_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

#endif
#ifdef VK_KHR_buffer_device_address
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceBufferDeviceAddressFeatures, marshal_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures, unmarshal_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferDeviceAddressInfo, marshal_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferDeviceAddressInfo, unmarshal_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferOpaqueCaptureAddressCreateInfo, marshal_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferOpaqueCaptureAddressCreateInfo, unmarshal_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkMemoryOpaqueCaptureAddressAllocateInfo, marshal_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo, unmarshal_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDeviceMemoryOpaqueCaptureAddressInfo, marshal_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo, unmarshal_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

#define OP_vkGetBufferDeviceAddressKHR 219261480
#define OP_vkGetBufferOpaqueCaptureAddressKHR 285631711
#define OP_vkGetDeviceMemoryOpaqueCaptureAddressKHR 294671624
#endif
#ifdef VK_KHR_pipeline_executable_properties
void marshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forMarshaling);

void unmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forUnmarshaling);

void marshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInfoKHR* forMarshaling);

void unmarshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineInfoKHR* forUnmarshaling);

void marshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* forMarshaling);

void unmarshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutablePropertiesKHR* forUnmarshaling);

void marshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* forMarshaling);

void unmarshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableInfoKHR* forUnmarshaling);

void marshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* forMarshaling);

void unmarshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableStatisticValueKHR* forUnmarshaling);

void marshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* forMarshaling);

void unmarshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableStatisticKHR* forUnmarshaling);

void marshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* forMarshaling);

void unmarshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineExecutableInternalRepresentationKHR* forUnmarshaling);

#define OP_vkGetPipelineExecutablePropertiesKHR 269458798
#define OP_vkGetPipelineExecutableStatisticsKHR 271191699
#define OP_vkGetPipelineExecutableInternalRepresentationsKHR 274148497
#endif
#ifdef VK_KHR_shader_integer_dot_product
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderIntegerDotProductFeatures, marshal_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures, unmarshal_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderIntegerDotProductProperties, marshal_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties, unmarshal_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

#endif
#ifdef VK_KHR_synchronization2
DEFINE_ALIAS_FUNCTION(marshal_VkMemoryBarrier2, marshal_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryBarrier2, unmarshal_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferMemoryBarrier2, marshal_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferMemoryBarrier2, unmarshal_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageMemoryBarrier2, marshal_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageMemoryBarrier2, unmarshal_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDependencyInfo, marshal_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDependencyInfo, unmarshal_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubmitInfo2, marshal_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubmitInfo2, unmarshal_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSemaphoreSubmitInfo, marshal_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSemaphoreSubmitInfo, unmarshal_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkCommandBufferSubmitInfo, marshal_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCommandBufferSubmitInfo, unmarshal_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceSynchronization2Features, marshal_VkPhysicalDeviceSynchronization2FeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceSynchronization2Features, unmarshal_VkPhysicalDeviceSynchronization2FeaturesKHR)

#define OP_vkCmdSetEvent2KHR 270411360
#define OP_vkCmdResetEvent2KHR 283215906
#define OP_vkCmdWaitEvents2KHR 244967758
#define OP_vkCmdPipelineBarrier2KHR 201310066
#define OP_vkCmdWriteTimestamp2KHR 252552241
#define OP_vkQueueSubmit2KHR 293024240
#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, marshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, unmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

#endif
#ifdef VK_KHR_copy_commands2
DEFINE_ALIAS_FUNCTION(marshal_VkCopyBufferInfo2, marshal_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyBufferInfo2, unmarshal_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyImageInfo2, marshal_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyImageInfo2, unmarshal_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyBufferToImageInfo2, marshal_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyBufferToImageInfo2, unmarshal_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyImageToBufferInfo2, marshal_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyImageToBufferInfo2, unmarshal_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBlitImageInfo2, marshal_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBlitImageInfo2, unmarshal_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkResolveImageInfo2, marshal_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkResolveImageInfo2, unmarshal_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferCopy2, marshal_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferCopy2, unmarshal_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageCopy2, marshal_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageCopy2, unmarshal_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageBlit2, marshal_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageBlit2, unmarshal_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferImageCopy2, marshal_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferImageCopy2, unmarshal_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageResolve2, marshal_VkImageResolve2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageResolve2, unmarshal_VkImageResolve2KHR)

#define OP_vkCmdCopyBuffer2KHR 247893766
#define OP_vkCmdCopyImage2KHR 227008250
#define OP_vkCmdCopyBufferToImage2KHR 248841963
#define OP_vkCmdCopyImageToBuffer2KHR 252249060
#define OP_vkCmdBlitImage2KHR 259838288
#define OP_vkCmdResolveImage2KHR 254857232
#endif
#ifdef VK_KHR_format_feature_flags2
DEFINE_ALIAS_FUNCTION(marshal_VkFormatProperties3, marshal_VkFormatProperties3KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkFormatProperties3, unmarshal_VkFormatProperties3KHR)

#endif
#ifdef VK_KHR_maintenance4
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMaintenance4Features, marshal_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMaintenance4Features, unmarshal_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMaintenance4Properties, marshal_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMaintenance4Properties, unmarshal_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDeviceBufferMemoryRequirements, marshal_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDeviceBufferMemoryRequirements, unmarshal_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDeviceImageMemoryRequirements, marshal_VkDeviceImageMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDeviceImageMemoryRequirements, unmarshal_VkDeviceImageMemoryRequirementsKHR)

#define OP_vkGetDeviceBufferMemoryRequirementsKHR 201613635
#define OP_vkGetDeviceImageMemoryRequirementsKHR 243155021
#define OP_vkGetDeviceImageSparseMemoryRequirementsKHR 275585477
#endif
#ifdef VK_KHR_maintenance5
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMaintenance5Features, marshal_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMaintenance5Features, unmarshal_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceMaintenance5Properties, marshal_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceMaintenance5Properties, unmarshal_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkRenderingAreaInfo, marshal_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkRenderingAreaInfo, unmarshal_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkDeviceImageSubresourceInfo, marshal_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDeviceImageSubresourceInfo, unmarshal_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkImageSubresource2, marshal_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageSubresource2, unmarshal_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(marshal_VkSubresourceLayout2, marshal_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubresourceLayout2, unmarshal_VkSubresourceLayout2KHR)

#define OP_vkCmdBindIndexBuffer2KHR 202856085
#define OP_vkGetRenderingAreaGranularityKHR 238658496
#define OP_vkGetDeviceImageSubresourceLayoutKHR 252830318
#define OP_vkGetImageSubresourceLayout2KHR 243334937
DEFINE_ALIAS_FUNCTION(marshal_VkPipelineCreateFlags2CreateInfo, marshal_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineCreateFlags2CreateInfo, unmarshal_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkBufferUsageFlags2CreateInfo, marshal_VkBufferUsageFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkBufferUsageFlags2CreateInfo, unmarshal_VkBufferUsageFlags2CreateInfoKHR)

#endif
#ifdef VK_KHR_line_rasterization
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceLineRasterizationFeatures, marshal_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceLineRasterizationFeatures, unmarshal_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceLineRasterizationProperties, marshal_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceLineRasterizationProperties, unmarshal_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineRasterizationLineStateCreateInfo, marshal_VkPipelineRasterizationLineStateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineRasterizationLineStateCreateInfo, unmarshal_VkPipelineRasterizationLineStateCreateInfoKHR)

#define OP_vkCmdSetLineStippleKHR 219923286
#endif
#ifdef VK_ANDROID_native_buffer
void marshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* forMarshaling);

void unmarshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkNativeBufferUsage2ANDROID* forUnmarshaling);

void marshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferANDROID* forMarshaling);

void unmarshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkNativeBufferANDROID* forUnmarshaling);

void marshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* forMarshaling);

void unmarshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSwapchainImageCreateInfoANDROID* forUnmarshaling);

void marshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* forMarshaling);

void unmarshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePresentationPropertiesANDROID* forUnmarshaling);

#define OP_vkGetSwapchainGrallocUsageANDROID 20251
#define OP_vkAcquireImageANDROID 20252
#define OP_vkQueueSignalReleaseImageANDROID 20253
#define OP_vkGetSwapchainGrallocUsage2ANDROID 287960452
#endif
#ifdef VK_EXT_transform_feedback
void marshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* forUnmarshaling);

void marshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* forMarshaling);

void unmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationStateStreamCreateInfoEXT* forUnmarshaling);

#define OP_vkCmdBindTransformFeedbackBuffersEXT 267779978
#define OP_vkCmdBeginTransformFeedbackEXT 294396901
#define OP_vkCmdEndTransformFeedbackEXT 272333731
#define OP_vkCmdBeginQueryIndexedEXT 275810601
#define OP_vkCmdEndQueryIndexedEXT 279821337
#define OP_vkCmdDrawIndirectByteCountEXT 285235943
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, marshal_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, unmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

#endif
#ifdef VK_EXT_depth_clip_enable
void marshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* forUnmarshaling);

void marshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* forMarshaling);

void unmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_inline_uniform_block
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceInlineUniformBlockFeatures, marshal_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceInlineUniformBlockFeatures, unmarshal_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceInlineUniformBlockProperties, marshal_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceInlineUniformBlockProperties, unmarshal_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkWriteDescriptorSetInlineUniformBlock, marshal_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkWriteDescriptorSetInlineUniformBlock, unmarshal_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkDescriptorPoolInlineUniformBlockCreateInfo, marshal_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo, unmarshal_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

#endif
#ifdef VK_EXT_image_drm_format_modifier
void marshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* forMarshaling);

void unmarshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesEXT* forUnmarshaling);

void marshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* forMarshaling);

void unmarshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesListEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forUnmarshaling);

void marshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* forMarshaling);

void unmarshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierListCreateInfoEXT* forUnmarshaling);

void marshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* forMarshaling);

void unmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* forUnmarshaling);

void marshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* forMarshaling);

void unmarshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageDrmFormatModifierPropertiesEXT* forUnmarshaling);

#define OP_vkGetImageDrmFormatModifierPropertiesEXT 251301237
void marshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* forMarshaling);

void unmarshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierProperties2EXT* forUnmarshaling);

void marshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* forMarshaling);

void unmarshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDrmFormatModifierPropertiesList2EXT* forUnmarshaling);

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void marshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forUnmarshaling);

DEFINE_ALIAS_FUNCTION(marshal_VkVertexInputBindingDivisorDescription, marshal_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkVertexInputBindingDivisorDescription, unmarshal_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineVertexInputDivisorStateCreateInfo, marshal_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineVertexInputDivisorStateCreateInfo, unmarshal_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceVertexAttributeDivisorFeatures, marshal_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures, unmarshal_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

#endif
#ifdef VK_EXT_pipeline_creation_feedback
DEFINE_ALIAS_FUNCTION(marshal_VkPipelineCreationFeedbackCreateInfo, marshal_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineCreationFeedbackCreateInfo, unmarshal_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineCreationFeedback, marshal_VkPipelineCreationFeedbackEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineCreationFeedback, unmarshal_VkPipelineCreationFeedbackEXT)

#endif
#ifdef VK_EXT_fragment_density_map
void marshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forUnmarshaling);

void marshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* forMarshaling);

void unmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderPassFragmentDensityMapCreateInfoEXT* forUnmarshaling);

void marshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* forMarshaling);

void unmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_scalar_block_layout
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceScalarBlockLayoutFeatures, marshal_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures, unmarshal_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

#endif
#ifdef VK_EXT_subgroup_size_control
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceSubgroupSizeControlFeatures, marshal_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures, unmarshal_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceSubgroupSizeControlProperties, marshal_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceSubgroupSizeControlProperties, unmarshal_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, marshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, unmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

#endif
#ifdef VK_EXT_memory_budget
void marshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_tooling_info
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceToolProperties, marshal_VkPhysicalDeviceToolPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceToolProperties, unmarshal_VkPhysicalDeviceToolPropertiesEXT)

#define OP_vkGetPhysicalDeviceToolPropertiesEXT 282247593
#endif
#ifdef VK_EXT_provoking_vertex
void marshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* forUnmarshaling);

void marshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forMarshaling);

void unmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_line_rasterization
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceLineRasterizationFeatures, marshal_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceLineRasterizationFeatures, unmarshal_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceLineRasterizationProperties, marshal_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceLineRasterizationProperties, unmarshal_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPipelineRasterizationLineStateCreateInfo, marshal_VkPipelineRasterizationLineStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPipelineRasterizationLineStateCreateInfo, unmarshal_VkPipelineRasterizationLineStateCreateInfoEXT)

#define OP_vkCmdSetLineStippleEXT 263855692
#endif
#ifdef VK_EXT_index_type_uint8
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceIndexTypeUint8Features, marshal_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceIndexTypeUint8Features, unmarshal_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

#endif
#ifdef VK_EXT_extended_dynamic_state
void marshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forUnmarshaling);

#define OP_vkCmdSetCullModeEXT 266285895
#define OP_vkCmdSetFrontFaceEXT 212644406
#define OP_vkCmdSetPrimitiveTopologyEXT 260783979
#define OP_vkCmdSetViewportWithCountEXT 257105245
#define OP_vkCmdSetScissorWithCountEXT 204588120
#define OP_vkCmdBindVertexBuffers2EXT 243419921
#define OP_vkCmdSetDepthTestEnableEXT 233771166
#define OP_vkCmdSetDepthWriteEnableEXT 218663304
#define OP_vkCmdSetDepthCompareOpEXT 247761589
#define OP_vkCmdSetDepthBoundsTestEnableEXT 223213519
#define OP_vkCmdSetStencilTestEnableEXT 286438749
#define OP_vkCmdSetStencilOpEXT 277159578
#endif
#ifdef VK_EXT_host_image_copy
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceHostImageCopyFeatures, marshal_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceHostImageCopyFeatures, unmarshal_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceHostImageCopyProperties, marshal_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceHostImageCopyProperties, unmarshal_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkMemoryToImageCopy, marshal_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkMemoryToImageCopy, unmarshal_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkImageToMemoryCopy, marshal_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageToMemoryCopy, unmarshal_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyMemoryToImageInfo, marshal_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyMemoryToImageInfo, unmarshal_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyImageToMemoryInfo, marshal_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyImageToMemoryInfo, unmarshal_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkCopyImageToImageInfo, marshal_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkCopyImageToImageInfo, unmarshal_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkHostImageLayoutTransitionInfo, marshal_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkHostImageLayoutTransitionInfo, unmarshal_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkSubresourceHostMemcpySize, marshal_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubresourceHostMemcpySize, unmarshal_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkHostImageCopyDevicePerformanceQuery, marshal_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkHostImageCopyDevicePerformanceQuery, unmarshal_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkSubresourceLayout2, marshal_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkSubresourceLayout2, unmarshal_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(marshal_VkImageSubresource2, marshal_VkImageSubresource2EXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkImageSubresource2, unmarshal_VkImageSubresource2EXT)

#define OP_vkCopyMemoryToImageEXT 218832495
#define OP_vkCopyImageToMemoryEXT 204695490
#define OP_vkCopyImageToImageEXT 223534798
#define OP_vkTransitionImageLayoutEXT 242817558
#define OP_vkGetImageSubresourceLayout2EXT 296152177
#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, marshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, unmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

#endif
#ifdef VK_EXT_texel_buffer_alignment
void marshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forUnmarshaling);

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceTexelBufferAlignmentProperties, marshal_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties, unmarshal_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

#endif
#ifdef VK_EXT_device_memory_report
void marshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forUnmarshaling);

void marshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* forMarshaling);

void unmarshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceMemoryReportCallbackDataEXT* forUnmarshaling);

void marshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* forMarshaling);

void unmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkDeviceDeviceMemoryReportCreateInfoEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_robustness2
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceRobustness2FeaturesKHR, marshal_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceRobustness2FeaturesKHR, unmarshal_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceRobustness2PropertiesKHR, marshal_VkPhysicalDeviceRobustness2PropertiesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceRobustness2PropertiesKHR, unmarshal_VkPhysicalDeviceRobustness2PropertiesEXT)

#endif
#ifdef VK_EXT_custom_border_color
void marshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* forMarshaling);

void unmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkSamplerCustomBorderColorCreateInfoEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_private_data
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDevicePrivateDataFeatures, marshal_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDevicePrivateDataFeatures, unmarshal_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkDevicePrivateDataCreateInfo, marshal_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkDevicePrivateDataCreateInfo, unmarshal_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(marshal_VkPrivateDataSlotCreateInfo, marshal_VkPrivateDataSlotCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPrivateDataSlotCreateInfo, unmarshal_VkPrivateDataSlotCreateInfoEXT)

#define OP_vkCreatePrivateDataSlotEXT 236374049
#define OP_vkDestroyPrivateDataSlotEXT 208891309
#define OP_vkSetPrivateDataEXT 225259406
#define OP_vkGetPrivateDataEXT 291399427
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDevicePipelineCreationCacheControlFeatures, marshal_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures, unmarshal_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

#endif
#ifdef VK_EXT_graphics_pipeline_library
void marshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forUnmarshaling);

void marshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forUnmarshaling);

void marshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* forMarshaling);

void unmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkGraphicsPipelineLibraryCreateInfoEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void marshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_image_robustness
DEFINE_ALIAS_FUNCTION(marshal_VkPhysicalDeviceImageRobustnessFeatures, marshal_VkPhysicalDeviceImageRobustnessFeaturesEXT)

DEFINE_ALIAS_FUNCTION(unmarshal_VkPhysicalDeviceImageRobustnessFeatures, unmarshal_VkPhysicalDeviceImageRobustnessFeaturesEXT)

#endif
#ifdef VK_EXT_image_compression_control
void marshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* forUnmarshaling);

void marshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* forMarshaling);

void unmarshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCompressionControlEXT* forUnmarshaling);

void marshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* forMarshaling);

void unmarshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImageCompressionPropertiesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_4444_formats
void marshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevice4444FormatsFeaturesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void marshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forUnmarshaling);

#endif
#ifdef VK_EXT_extended_dynamic_state2
void marshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forUnmarshaling);

#define OP_vkCmdSetPatchControlPointsEXT 208680354
#define OP_vkCmdSetRasterizerDiscardEnableEXT 245221405
#define OP_vkCmdSetDepthBiasEnableEXT 259472348
#define OP_vkCmdSetLogicOpEXT 267481927
#define OP_vkCmdSetPrimitiveRestartEnableEXT 299567883
#endif
#ifdef VK_EXT_color_write_enable
void marshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* forUnmarshaling);

void marshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* forMarshaling);

void unmarshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPipelineColorWriteCreateInfoEXT* forUnmarshaling);

#define OP_vkCmdSetColorWriteEnableEXT 202223297
#endif
#ifdef VK_GOOGLE_gfxstream
void marshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* forMarshaling);

void unmarshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportColorBufferGOOGLE* forUnmarshaling);

void marshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* forMarshaling);

void unmarshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkImportBufferGOOGLE* forUnmarshaling);

void marshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* forMarshaling);

void unmarshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkCreateBlobGOOGLE* forUnmarshaling);

#define OP_vkMapMemoryIntoAddressSpaceGOOGLE 20317
#define OP_vkUpdateDescriptorSetWithTemplateSizedGOOGLE 20320
#define OP_vkBeginCommandBufferAsyncGOOGLE 20321
#define OP_vkEndCommandBufferAsyncGOOGLE 20322
#define OP_vkResetCommandBufferAsyncGOOGLE 20323
#define OP_vkCommandBufferHostSyncGOOGLE 20324
#define OP_vkCreateImageWithRequirementsGOOGLE 20325
#define OP_vkCreateBufferWithRequirementsGOOGLE 20326
#define OP_vkGetMemoryHostAddressInfoGOOGLE 20327
#define OP_vkFreeMemorySyncGOOGLE 20328
#define OP_vkQueueHostSyncGOOGLE 20329
#define OP_vkQueueSubmitAsyncGOOGLE 20330
#define OP_vkQueueWaitIdleAsyncGOOGLE 20331
#define OP_vkQueueBindSparseAsyncGOOGLE 20332
#define OP_vkGetLinearImageLayoutGOOGLE 20333
#define OP_vkGetLinearImageLayout2GOOGLE 282325414
#define OP_vkQueueFlushCommandsGOOGLE 20340
#define OP_vkQueueCommitDescriptorSetUpdatesGOOGLE 267932433
#define OP_vkCollectDescriptorPoolIdsGOOGLE 213659202
#define OP_vkQueueSignalReleaseImageANDROIDAsyncGOOGLE 243985229
#define OP_vkQueueFlushCommandsFromAuxMemoryGOOGLE 290633483
#define OP_vkGetBlobGOOGLE 20341
#define OP_vkUpdateDescriptorSetWithTemplateSized2GOOGLE 244782974
#define OP_vkQueueSubmitAsync2GOOGLE 292092830
#define OP_vkGetSemaphoreGOOGLE 20342
#define OP_vkTraceAsyncGOOGLE 286553566
#endif
#ifdef VK_EXT_image_compression_control_swapchain
void marshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forMarshaling);

void unmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forUnmarshaling);

#endif
const char* api_opcode_to_string(
    const uint32_t opcode);

#define OP_vkFirst_old 20000
#define OP_vkLast_old 30000
#define OP_vkFirst 200000000
#define OP_vkLast 300000000

}  // namespace vk
}  // namespace gfxstream
