/*
 * Copyright (C) 2016 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */


/* Instructions, enums and structures for RT.
 *
 * This file has been generated, do not hand edit.
 */

#ifndef GFX20_RT_PACK_H
#define GFX20_RT_PACK_H

#ifndef __OPENCL_VERSION__
#include <stdio.h>
#include "util/bitpack_helpers.h"
#include "genX_helpers.h"
#else
#include "genX_cl_helpers.h"
#endif


#define GFX20_BINDLESS_SHADER_RECORD_length      2
struct GFX20_BINDLESS_SHADER_RECORD {
   uint32_t                             OffsetToLocalArguments;
   uint32_t                             BindlessShaderDispatchMode;
#define RT_SIMD16                                0
#define RT_SIMD8                                 1
   uint64_t                             KernelStartPointer;
};

static inline __attribute__((always_inline)) void
GFX20_BINDLESS_SHADER_RECORD_pack(__attribute__((unused)) __gen_user_data *data,
                                  __attribute__((unused)) void * restrict dst,
                                  __attribute__((unused)) const struct GFX20_BINDLESS_SHADER_RECORD * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   dw[0] =
      util_bitpack_uint(values->OffsetToLocalArguments, 0, 2) |
      util_bitpack_uint(values->BindlessShaderDispatchMode, 4, 4) |
      __gen_offset(values->KernelStartPointer, 6, 31);

   dw[1] = 0;
}

#define GFX20_RT_SHADER_TABLE_length           2
struct GFX20_RT_SHADER_TABLE {
   __gen_address_type                   BaseAddress;
   uint32_t                             Stride;
};

static inline __attribute__((always_inline)) void
GFX20_RT_SHADER_TABLE_pack(__attribute__((unused)) __gen_user_data *data,
                           __attribute__((unused)) void * restrict dst,
                           __attribute__((unused)) const struct GFX20_RT_SHADER_TABLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0 =
      util_bitpack_uint(values->Stride, 48, 63);
   const uint64_t v0_address =
      __gen_address(data, &dw[0], values->BaseAddress, v0, 0, 47);
   dw[0] = v0_address;
   dw[1] = (v0_address >> 32) | (v0 >> 32);
}

#define GFX20_RT_DISPATCH_GLOBALS_length      20
struct GFX20_RT_DISPATCH_GLOBALS {
   __gen_address_type                   MemBaseAddress;
   struct GFX20_BINDLESS_SHADER_RECORD  CallStackHandler;
   uint32_t                             AsyncRTStackSize;
   uint32_t                             NumDSSRTStacks;
   uint32_t                             MaxBVHLevels;
   uint32_t                             Flags;
#define RT_DEPTH_TEST_LESS_EQUAL                 1
   struct GFX20_RT_SHADER_TABLE         HitGroupTable;
   struct GFX20_RT_SHADER_TABLE         MissGroupTable;
   uint32_t                             SWStackSize;
   uint32_t                             LaunchWidth;
   uint32_t                             LaunchHeight;
   uint32_t                             LaunchDepth;
   struct GFX20_RT_SHADER_TABLE         CallableGroupTable;
   __gen_address_type                   ResumeShaderTable;
};

static inline __attribute__((always_inline)) void
GFX20_RT_DISPATCH_GLOBALS_pack(__attribute__((unused)) __gen_user_data *data,
                               __attribute__((unused)) void * restrict dst,
                               __attribute__((unused)) const struct GFX20_RT_DISPATCH_GLOBALS * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   const uint64_t v0_address =
      __gen_address(data, &dw[0], values->MemBaseAddress, 0, 0, 63);
   dw[0] = v0_address;
   dw[1] = v0_address >> 32;

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[2], &values->CallStackHandler);

   dw[4] =
      util_bitpack_uint(values->AsyncRTStackSize, 0, 31);

   dw[5] =
      util_bitpack_uint(values->NumDSSRTStacks, 0, 15);

   dw[6] =
      util_bitpack_uint(values->MaxBVHLevels, 0, 2);

   dw[7] =
      util_bitpack_uint(values->Flags, 0, 0);

   GFX20_RT_SHADER_TABLE_pack(data, &dw[8], &values->HitGroupTable);

   GFX20_RT_SHADER_TABLE_pack(data, &dw[10], &values->MissGroupTable);

   dw[12] =
      util_bitpack_uint(values->SWStackSize, 0, 31);

   dw[13] =
      util_bitpack_uint(values->LaunchWidth, 0, 31);

   dw[14] =
      util_bitpack_uint(values->LaunchHeight, 0, 31);

   dw[15] =
      util_bitpack_uint(values->LaunchDepth, 0, 31);

   GFX20_RT_SHADER_TABLE_pack(data, &dw[16], &values->CallableGroupTable);

   const uint64_t v18_address =
      __gen_address(data, &dw[18], values->ResumeShaderTable, 0, 0, 63);
   dw[18] = v18_address;
   dw[19] = v18_address >> 32;
}

#define GFX20_RT_GENERAL_SBT_HANDLE_length      8
struct GFX20_RT_GENERAL_SBT_HANDLE {
   struct GFX20_BINDLESS_SHADER_RECORD  General;
};

static inline __attribute__((always_inline)) void
GFX20_RT_GENERAL_SBT_HANDLE_pack(__attribute__((unused)) __gen_user_data *data,
                                 __attribute__((unused)) void * restrict dst,
                                 __attribute__((unused)) const struct GFX20_RT_GENERAL_SBT_HANDLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[0], &values->General);

   dw[2] = 0;

   dw[3] = 0;

   dw[4] = 0;

   dw[5] = 0;

   dw[6] = 0;

   dw[7] = 0;
}

#define GFX20_RT_PROCEDURAL_SBT_HANDLE_length      8
struct GFX20_RT_PROCEDURAL_SBT_HANDLE {
   struct GFX20_BINDLESS_SHADER_RECORD  ClosestHit;
   struct GFX20_BINDLESS_SHADER_RECORD  Intersection;
};

static inline __attribute__((always_inline)) void
GFX20_RT_PROCEDURAL_SBT_HANDLE_pack(__attribute__((unused)) __gen_user_data *data,
                                    __attribute__((unused)) void * restrict dst,
                                    __attribute__((unused)) const struct GFX20_RT_PROCEDURAL_SBT_HANDLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[0], &values->ClosestHit);

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[2], &values->Intersection);

   dw[4] = 0;

   dw[5] = 0;

   dw[6] = 0;

   dw[7] = 0;
}

#define GFX20_RT_TRIANGLES_SBT_HANDLE_length      8
struct GFX20_RT_TRIANGLES_SBT_HANDLE {
   struct GFX20_BINDLESS_SHADER_RECORD  ClosestHit;
   struct GFX20_BINDLESS_SHADER_RECORD  AnyHit;
};

static inline __attribute__((always_inline)) void
GFX20_RT_TRIANGLES_SBT_HANDLE_pack(__attribute__((unused)) __gen_user_data *data,
                                   __attribute__((unused)) void * restrict dst,
                                   __attribute__((unused)) const struct GFX20_RT_TRIANGLES_SBT_HANDLE * restrict values)
{
   uint32_t * restrict dw = (uint32_t * restrict) dst;

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[0], &values->ClosestHit);

   GFX20_BINDLESS_SHADER_RECORD_pack(data, &dw[2], &values->AnyHit);

   dw[4] = 0;

   dw[5] = 0;

   dw[6] = 0;

   dw[7] = 0;
}

#endif /* GFX20_RT_PACK_H */
