#include "nv_push_clc06f.h"

#include <stdio.h>





const char *P_PARSE_NVB06F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC06F_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVB06F_MTHD(idx);

                                        case NVC06F_MEM_OP_A:
        return "NVC06F_MEM_OP_A";
    case NVC06F_MEM_OP_B:
        return "NVC06F_MEM_OP_B";
    case NVC06F_MEM_OP_C:
        return "NVC06F_MEM_OP_C";
    case NVC06F_MEM_OP_D:
        return "NVC06F_MEM_OP_D";
        case NVC06F_SYNCPOINTA:
        return "NVC06F_SYNCPOINTA";
    case NVC06F_SYNCPOINTB:
        return "NVC06F_SYNCPOINTB";
            
    }
}

void
P_DUMP_NVC06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVB06F_MTHD_DATA(fp, idx, data, prefix);
    break;

                                      
    case NVC06F_MEM_OP_A:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 5) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC06F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC06F_MEM_OP_B:

    
        parsed = data;
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC06F_MEM_OP_C:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MEMBAR_TYPE = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR:
            fprintf(fp, "SYS_MEMBAR\n");
            break;
        case NVC06F_MEM_OP_C_MEMBAR_TYPE_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_REPLAY = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START:
            fprintf(fp, "START\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL:
            fprintf(fp, "START_ACK_ALL\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED:
            fprintf(fp, "CANCEL_TARGETED\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL:
            fprintf(fp, "CANCEL_GLOBAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACK_TYPE = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY:
            fprintf(fp, "GLOBALLY\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE:
            fprintf(fp, "INTRANODE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PAGE_TABLE_LEVEL = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY:
            fprintf(fp, "PTE_ONLY\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0:
            fprintf(fp, "UP_TO_PDE0\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1:
            fprintf(fp, "UP_TO_PDE1\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2:
            fprintf(fp, "UP_TO_PDE2\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3:
            fprintf(fp, "UP_TO_PDE3\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4:
            fprintf(fp, "UP_TO_PDE4\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5:
            fprintf(fp, "UP_TO_PDE5\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_APERTURE = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        case NVC06F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT:
            fprintf(fp, "SYS_MEM_NONCOHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC06F_MEM_OP_D:

    
        parsed = (data >> 0) & ((1u << 27) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC06F_MEM_OP_D_OPERATION_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        case NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVC06F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED:
            fprintf(fp, "MMU_TLB_INVALIDATE_TARGETED\n");
            break;
        case NVC06F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NVC06F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVC06F_SYNCPOINTA:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC06F_SYNCPOINTB:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC06F_SYNCPOINTB_OPERATION_WAIT:
            fprintf(fp, "WAIT\n");
            break;
        case NVC06F_SYNCPOINTB_OPERATION_INCR:
            fprintf(fp, "INCR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.WAIT_SWITCH = ", prefix);
        switch (parsed) {
        case NVC06F_SYNCPOINTB_WAIT_SWITCH_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC06F_SYNCPOINTB_WAIT_SWITCH_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 12) - 1);
        fprintf(fp, "%s.SYNCPT_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                }
}
