#include "nv_push_clc36f.h"

#include <stdio.h>





const char *P_PARSE_NVC06F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC06F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC36F_MTHD(uint16_t idx)
{
    switch (idx) {

  
        
    case NVC36F_SET_OBJECT:

        
    case NVC36F_ILLEGAL:

        
    case NVC36F_NOP:

        
    case NVC36F_SEMAPHOREA:

        
    case NVC36F_SEMAPHOREB:

        
    case NVC36F_SEMAPHOREC:

        
    case NVC36F_SEMAPHORED:

        
    case NVC36F_NON_STALL_INTERRUPT:

        
    case NVC36F_FB_FLUSH:

        
    case NVC36F_MEM_OP_B:

        
    case NVC36F_SET_REFERENCE:

        
    case NVC36F_CRC_CHECK:


    return P_PARSE_NVC06F_MTHD(idx);

                                        case NVC36F_MEM_OP_A:
        return "NVC36F_MEM_OP_A";
        case NVC36F_MEM_OP_C:
        return "NVC36F_MEM_OP_C";
    case NVC36F_MEM_OP_D:
        return "NVC36F_MEM_OP_D";
        case NVC36F_SEM_ADDR_LO:
        return "NVC36F_SEM_ADDR_LO";
    case NVC36F_SEM_ADDR_HI:
        return "NVC36F_SEM_ADDR_HI";
    case NVC36F_SEM_PAYLOAD_LO:
        return "NVC36F_SEM_PAYLOAD_LO";
    case NVC36F_SEM_PAYLOAD_HI:
        return "NVC36F_SEM_PAYLOAD_HI";
    case NVC36F_SEM_EXECUTE:
        return "NVC36F_SEM_EXECUTE";
    case NVC36F_WFI:
        return "NVC36F_WFI";
        case NVC36F_YIELD:
        return "NVC36F_YIELD";
    case NVC36F_CLEAR_FAULTED:
        return "NVC36F_CLEAR_FAULTED";

    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC36F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
        
    case NVC36F_SET_OBJECT:

        
    case NVC36F_ILLEGAL:

        
    case NVC36F_NOP:

        
    case NVC36F_SEMAPHOREA:

        
    case NVC36F_SEMAPHOREB:

        
    case NVC36F_SEMAPHOREC:

        
    case NVC36F_SEMAPHORED:

        
    case NVC36F_NON_STALL_INTERRUPT:

        
    case NVC36F_FB_FLUSH:

        
    case NVC36F_MEM_OP_B:

        
    case NVC36F_SET_REFERENCE:

        
    case NVC36F_CRC_CHECK:


    P_DUMP_NVC06F_MTHD_DATA(fp, idx, data, prefix);
    break;

                                      
    case NVC36F_MEM_OP_A:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_INVALIDATION_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 5) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 7) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_CANCEL_MMU_ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_SYSMEMBAR = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN:
            fprintf(fp, "EN\n");
            break;
        case NVC36F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_TARGET_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
      
    case NVC36F_MEM_OP_C:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MEMBAR_TYPE = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR:
            fprintf(fp, "SYS_MEMBAR\n");
            break;
        case NVC36F_MEM_OP_C_MEMBAR_TYPE_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_REPLAY = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START:
            fprintf(fp, "START\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL:
            fprintf(fp, "START_ACK_ALL\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED:
            fprintf(fp, "CANCEL_TARGETED\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL:
            fprintf(fp, "CANCEL_GLOBAL\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL:
            fprintf(fp, "CANCEL_VA_GLOBAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACK_TYPE = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY:
            fprintf(fp, "GLOBALLY\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE:
            fprintf(fp, "INTRANODE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_ACCESS_TYPE = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ:
            fprintf(fp, "VIRT_READ\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE:
            fprintf(fp, "VIRT_WRITE\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG:
            fprintf(fp, "VIRT_ATOMIC_STRONG\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD:
            fprintf(fp, "VIRT_RSVRVD\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK:
            fprintf(fp, "VIRT_ATOMIC_WEAK\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL:
            fprintf(fp, "VIRT_ATOMIC_ALL\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC:
            fprintf(fp, "VIRT_WRITE_AND_ATOMIC\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL:
            fprintf(fp, "VIRT_ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PAGE_TABLE_LEVEL = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY:
            fprintf(fp, "PTE_ONLY\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0:
            fprintf(fp, "UP_TO_PDE0\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1:
            fprintf(fp, "UP_TO_PDE1\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2:
            fprintf(fp, "UP_TO_PDE2\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3:
            fprintf(fp, "UP_TO_PDE3\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4:
            fprintf(fp, "UP_TO_PDE4\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5:
            fprintf(fp, "UP_TO_PDE5\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_APERTURE = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM:
            fprintf(fp, "VID_MEM\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT:
            fprintf(fp, "SYS_MEM_COHERENT\n");
            break;
        case NVC36F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT:
            fprintf(fp, "SYS_MEM_NONCOHERENT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 20) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_LO = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.ACCESS_COUNTER_CLR_TARGETED_NOTIFY_TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC36F_MEM_OP_D:

    
        parsed = (data >> 0) & ((1u << 27) - 1);
        fprintf(fp, "%s.TLB_INVALIDATE_PDB_ADDR_HI = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC36F_MEM_OP_D_OPERATION_MEMBAR:
            fprintf(fp, "MEMBAR\n");
            break;
        case NVC36F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVC36F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED:
            fprintf(fp, "MMU_TLB_INVALIDATE_TARGETED\n");
            break;
        case NVC36F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE:
            fprintf(fp, "L2_PEERMEM_INVALIDATE\n");
            break;
        case NVC36F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE:
            fprintf(fp, "L2_SYSMEM_INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVC36F_SEM_ADDR_LO:

    
        parsed = (data >> 2) & ((1u << 30) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC36F_SEM_ADDR_HI:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC36F_SEM_PAYLOAD_LO:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC36F_SEM_PAYLOAD_HI:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC36F_SEM_EXECUTE:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_ACQ_STRICT_GEQ:
            fprintf(fp, "ACQ_STRICT_GEQ\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_ACQ_CIRC_GEQ:
            fprintf(fp, "ACQ_CIRC_GEQ\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_ACQ_NOR:
            fprintf(fp, "ACQ_NOR\n");
            break;
        case NVC36F_SEM_EXECUTE_OPERATION_REDUCTION:
            fprintf(fp, "REDUCTION\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH_TSG = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC36F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC36F_SEM_EXECUTE_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PAYLOAD_SIZE = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT:
            fprintf(fp, "32BIT\n");
            break;
        case NVC36F_SEM_EXECUTE_PAYLOAD_SIZE_64BIT:
            fprintf(fp, "64BIT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 25) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_TIMESTAMP = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_RELEASE_TIMESTAMP_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVC36F_SEM_EXECUTE_RELEASE_TIMESTAMP_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 4) - 1);
        fprintf(fp, "%s.REDUCTION = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_REDUCTION_IMIN:
            fprintf(fp, "IMIN\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_IMAX:
            fprintf(fp, "IMAX\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_IXOR:
            fprintf(fp, "IXOR\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_IAND:
            fprintf(fp, "IAND\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_IOR:
            fprintf(fp, "IOR\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_IADD:
            fprintf(fp, "IADD\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC36F_SEM_EXECUTE_REDUCTION_FORMAT_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVC36F_SEM_EXECUTE_REDUCTION_FORMAT_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC36F_WFI:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCOPE = ", prefix);
        switch (parsed) {
        case NVC36F_WFI_SCOPE_CURRENT_VEID:
            fprintf(fp, "CURRENT_VEID\n");
            break;
        case NVC36F_WFI_SCOPE_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVC36F_YIELD:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC36F_YIELD_OP_NOP:
            fprintf(fp, "NOP\n");
            break;
        case NVC36F_YIELD_OP_RUNLIST_TIMESLICE:
            fprintf(fp, "RUNLIST_TIMESLICE\n");
            break;
        case NVC36F_YIELD_OP_TSG:
            fprintf(fp, "TSG\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC36F_CLEAR_FAULTED:

    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.CHID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC36F_CLEAR_FAULTED_TYPE_PBDMA_FAULTED:
            fprintf(fp, "PBDMA_FAULTED\n");
            break;
        case NVC36F_CLEAR_FAULTED_TYPE_ENG_FAULTED:
            fprintf(fp, "ENG_FAULTED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
