// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/common.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the instance.
	Id int32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *Instance) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

type DownloadProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*DownloadProgress_Start
	//	*DownloadProgress_Update
	//	*DownloadProgress_End
	Message isDownloadProgress_Message `protobuf_oneof:"message"`
}

func (x *DownloadProgress) Reset() {
	*x = DownloadProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadProgress) ProtoMessage() {}

func (x *DownloadProgress) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadProgress.ProtoReflect.Descriptor instead.
func (*DownloadProgress) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{1}
}

func (m *DownloadProgress) GetMessage() isDownloadProgress_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *DownloadProgress) GetStart() *DownloadProgressStart {
	if x, ok := x.GetMessage().(*DownloadProgress_Start); ok {
		return x.Start
	}
	return nil
}

func (x *DownloadProgress) GetUpdate() *DownloadProgressUpdate {
	if x, ok := x.GetMessage().(*DownloadProgress_Update); ok {
		return x.Update
	}
	return nil
}

func (x *DownloadProgress) GetEnd() *DownloadProgressEnd {
	if x, ok := x.GetMessage().(*DownloadProgress_End); ok {
		return x.End
	}
	return nil
}

type isDownloadProgress_Message interface {
	isDownloadProgress_Message()
}

type DownloadProgress_Start struct {
	// Sent when a download is started.
	Start *DownloadProgressStart `protobuf:"bytes,1,opt,name=start,proto3,oneof"`
}

type DownloadProgress_Update struct {
	// Progress updates for a download.
	Update *DownloadProgressUpdate `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type DownloadProgress_End struct {
	// Sent when a download is finished or failed.
	End *DownloadProgressEnd `protobuf:"bytes,3,opt,name=end,proto3,oneof"`
}

func (*DownloadProgress_Start) isDownloadProgress_Message() {}

func (*DownloadProgress_Update) isDownloadProgress_Message() {}

func (*DownloadProgress_End) isDownloadProgress_Message() {}

type DownloadProgressStart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL of the download.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The label to display on the progress bar.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *DownloadProgressStart) Reset() {
	*x = DownloadProgressStart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadProgressStart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadProgressStart) ProtoMessage() {}

func (x *DownloadProgressStart) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadProgressStart.ProtoReflect.Descriptor instead.
func (*DownloadProgressStart) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *DownloadProgressStart) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *DownloadProgressStart) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type DownloadProgressUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Size of the downloaded portion of the file.
	Downloaded int64 `protobuf:"varint,1,opt,name=downloaded,proto3" json:"downloaded,omitempty"`
	// Total size of the file being downloaded.
	TotalSize int64 `protobuf:"varint,2,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *DownloadProgressUpdate) Reset() {
	*x = DownloadProgressUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadProgressUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadProgressUpdate) ProtoMessage() {}

func (x *DownloadProgressUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadProgressUpdate.ProtoReflect.Descriptor instead.
func (*DownloadProgressUpdate) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *DownloadProgressUpdate) GetDownloaded() int64 {
	if x != nil {
		return x.Downloaded
	}
	return 0
}

func (x *DownloadProgressUpdate) GetTotalSize() int64 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

type DownloadProgressEnd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the download is successful.
	Success bool `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	// Info or error message, depending on the value of 'success'. Some examples:
	// "File xxx already downloaded" or "Connection timeout".
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *DownloadProgressEnd) Reset() {
	*x = DownloadProgressEnd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadProgressEnd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadProgressEnd) ProtoMessage() {}

func (x *DownloadProgressEnd) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadProgressEnd.ProtoReflect.Descriptor instead.
func (*DownloadProgressEnd) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{4}
}

func (x *DownloadProgressEnd) GetSuccess() bool {
	if x != nil {
		return x.Success
	}
	return false
}

func (x *DownloadProgressEnd) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type TaskProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the task.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Additional information about the task.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Whether the task is complete.
	Completed bool `protobuf:"varint,3,opt,name=completed,proto3" json:"completed,omitempty"`
	// Amount in percent of the task completion (optional).
	Percent float32 `protobuf:"fixed32,4,opt,name=percent,proto3" json:"percent,omitempty"`
}

func (x *TaskProgress) Reset() {
	*x = TaskProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskProgress) ProtoMessage() {}

func (x *TaskProgress) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskProgress.ProtoReflect.Descriptor instead.
func (*TaskProgress) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{5}
}

func (x *TaskProgress) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TaskProgress) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *TaskProgress) GetCompleted() bool {
	if x != nil {
		return x.Completed
	}
	return false
}

func (x *TaskProgress) GetPercent() float32 {
	if x != nil {
		return x.Percent
	}
	return 0
}

type Programmer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Platform name.
	Platform string `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	// Programmer ID.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Programmer name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Programmer) Reset() {
	*x = Programmer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Programmer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Programmer) ProtoMessage() {}

func (x *Programmer) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Programmer.ProtoReflect.Descriptor instead.
func (*Programmer) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{6}
}

func (x *Programmer) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *Programmer) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Programmer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// MissingProgrammerError is a status error detail that is returned when
// the operation can not be completed due to a missing programmer argument.
type MissingProgrammerError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MissingProgrammerError) Reset() {
	*x = MissingProgrammerError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MissingProgrammerError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MissingProgrammerError) ProtoMessage() {}

func (x *MissingProgrammerError) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MissingProgrammerError.ProtoReflect.Descriptor instead.
func (*MissingProgrammerError) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{7}
}

// Platform is a structure containing all the information about a single
// platform release.
type Platform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generic information about a platform.
	Metadata *PlatformMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Information about a specific release of a platform.
	Release *PlatformRelease `protobuf:"bytes,2,opt,name=release,proto3" json:"release,omitempty"`
}

func (x *Platform) Reset() {
	*x = Platform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Platform) ProtoMessage() {}

func (x *Platform) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Platform.ProtoReflect.Descriptor instead.
func (*Platform) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{8}
}

func (x *Platform) GetMetadata() *PlatformMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Platform) GetRelease() *PlatformRelease {
	if x != nil {
		return x.Release
	}
	return nil
}

// PlatformSummary is a structure containing all the information about
// a platform and all its available releases.
type PlatformSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generic information about a platform.
	Metadata *PlatformMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Maps version to the corresponding PlatformRelease.
	Releases map[string]*PlatformRelease `protobuf:"bytes,2,rep,name=releases,proto3" json:"releases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The installed version of the platform, or empty string if none installed.
	InstalledVersion string `protobuf:"bytes,3,opt,name=installed_version,json=installedVersion,proto3" json:"installed_version,omitempty"`
	// The latest available version of the platform that can be installable, or
	// empty if none available.
	LatestVersion string `protobuf:"bytes,4,opt,name=latest_version,json=latestVersion,proto3" json:"latest_version,omitempty"`
}

func (x *PlatformSummary) Reset() {
	*x = PlatformSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSummary) ProtoMessage() {}

func (x *PlatformSummary) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSummary.ProtoReflect.Descriptor instead.
func (*PlatformSummary) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{9}
}

func (x *PlatformSummary) GetMetadata() *PlatformMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PlatformSummary) GetReleases() map[string]*PlatformRelease {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *PlatformSummary) GetInstalledVersion() string {
	if x != nil {
		return x.InstalledVersion
	}
	return ""
}

func (x *PlatformSummary) GetLatestVersion() string {
	if x != nil {
		return x.LatestVersion
	}
	return ""
}

// PlatformMetadata contains generic information about a platform (not
// correlated to a specific release).
type PlatformMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Platform ID (e.g., `arduino:avr`).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Maintainer of the platform's package.
	Maintainer string `protobuf:"bytes,2,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// A URL provided by the author of the platform's package, intended to point
	// to their website.
	Website string `protobuf:"bytes,3,opt,name=website,proto3" json:"website,omitempty"`
	// Email of the maintainer of the platform's package.
	Email string `protobuf:"bytes,4,opt,name=email,proto3" json:"email,omitempty"`
	// If true this Platform has been installed manually in the user' sketchbook
	// hardware folder.
	ManuallyInstalled bool `protobuf:"varint,5,opt,name=manually_installed,json=manuallyInstalled,proto3" json:"manually_installed,omitempty"`
	// True if the latest release of this Platform has been deprecated.
	Deprecated bool `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// If true the platform is indexed.
	Indexed bool `protobuf:"varint,7,opt,name=indexed,proto3" json:"indexed,omitempty"`
}

func (x *PlatformMetadata) Reset() {
	*x = PlatformMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformMetadata) ProtoMessage() {}

func (x *PlatformMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformMetadata.ProtoReflect.Descriptor instead.
func (*PlatformMetadata) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{10}
}

func (x *PlatformMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PlatformMetadata) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *PlatformMetadata) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *PlatformMetadata) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *PlatformMetadata) GetManuallyInstalled() bool {
	if x != nil {
		return x.ManuallyInstalled
	}
	return false
}

func (x *PlatformMetadata) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *PlatformMetadata) GetIndexed() bool {
	if x != nil {
		return x.Indexed
	}
	return false
}

// PlatformRelease contains information about a specific release of a platform.
type PlatformRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name used to identify the platform to humans (e.g., "Arduino AVR Boards").
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the platform release.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Type of the platform.
	Types []string `protobuf:"bytes,3,rep,name=types,proto3" json:"types,omitempty"`
	// True if the platform is installed.
	Installed bool `protobuf:"varint,4,opt,name=installed,proto3" json:"installed,omitempty"`
	// List of boards provided by the platform. If the platform is installed,
	// this is the boards listed in the platform's boards.txt. If the platform is
	// not installed, this is an arbitrary list of board names provided by the
	// platform author for display and may not match boards.txt.
	Boards []*Board `protobuf:"bytes,5,rep,name=boards,proto3" json:"boards,omitempty"`
	// A URL provided by the author of the platform's package, intended to point
	// to their online help service.
	Help *HelpResources `protobuf:"bytes,6,opt,name=help,proto3" json:"help,omitempty"`
	// This field is true if the platform is missing installation metadata (this
	// happens if the platform has been installed with the legacy Arduino IDE
	// <=1.8.x). If the platform miss metadata and it's not indexed through a
	// package index, it may fail to work correctly in some circumstances, and it
	// may need to be reinstalled. This should be evaluated only when the
	// PlatformRelease is `Installed` otherwise is an undefined behaviour.
	MissingMetadata bool `protobuf:"varint,7,opt,name=missing_metadata,json=missingMetadata,proto3" json:"missing_metadata,omitempty"`
	// True this release is deprecated.
	Deprecated bool `protobuf:"varint,8,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// True if the platform dependencies are available for the current OS/ARCH.
	// This also means that the platform is installable.
	Compatible bool `protobuf:"varint,9,opt,name=compatible,proto3" json:"compatible,omitempty"`
}

func (x *PlatformRelease) Reset() {
	*x = PlatformRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformRelease) ProtoMessage() {}

func (x *PlatformRelease) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformRelease.ProtoReflect.Descriptor instead.
func (*PlatformRelease) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{11}
}

func (x *PlatformRelease) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlatformRelease) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PlatformRelease) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *PlatformRelease) GetInstalled() bool {
	if x != nil {
		return x.Installed
	}
	return false
}

func (x *PlatformRelease) GetBoards() []*Board {
	if x != nil {
		return x.Boards
	}
	return nil
}

func (x *PlatformRelease) GetHelp() *HelpResources {
	if x != nil {
		return x.Help
	}
	return nil
}

func (x *PlatformRelease) GetMissingMetadata() bool {
	if x != nil {
		return x.MissingMetadata
	}
	return false
}

func (x *PlatformRelease) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *PlatformRelease) GetCompatible() bool {
	if x != nil {
		return x.Compatible
	}
	return false
}

type InstalledPlatformReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Platform ID (e.g., `arduino:avr`).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version of the platform.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Installation directory of the platform.
	InstallDir string `protobuf:"bytes,3,opt,name=install_dir,json=installDir,proto3" json:"install_dir,omitempty"`
	// 3rd party platform URL.
	PackageUrl string `protobuf:"bytes,4,opt,name=package_url,json=packageUrl,proto3" json:"package_url,omitempty"`
}

func (x *InstalledPlatformReference) Reset() {
	*x = InstalledPlatformReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstalledPlatformReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstalledPlatformReference) ProtoMessage() {}

func (x *InstalledPlatformReference) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstalledPlatformReference.ProtoReflect.Descriptor instead.
func (*InstalledPlatformReference) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{12}
}

func (x *InstalledPlatformReference) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *InstalledPlatformReference) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *InstalledPlatformReference) GetInstallDir() string {
	if x != nil {
		return x.InstallDir
	}
	return ""
}

func (x *InstalledPlatformReference) GetPackageUrl() string {
	if x != nil {
		return x.PackageUrl
	}
	return ""
}

type Board struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name used to identify the board to humans.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Fully qualified board name used to identify the board to machines. The FQBN
	// is only available for installed boards.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *Board) Reset() {
	*x = Board{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Board) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Board) ProtoMessage() {}

func (x *Board) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Board.ProtoReflect.Descriptor instead.
func (*Board) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{13}
}

func (x *Board) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Board) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type HelpResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URL provided by the author of the platform's package, intended to point
	// to their online help service.
	Online string `protobuf:"bytes,1,opt,name=online,proto3" json:"online,omitempty"`
}

func (x *HelpResources) Reset() {
	*x = HelpResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HelpResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HelpResources) ProtoMessage() {}

func (x *HelpResources) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HelpResources.ProtoReflect.Descriptor instead.
func (*HelpResources) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{14}
}

func (x *HelpResources) GetOnline() string {
	if x != nil {
		return x.Online
	}
	return ""
}

type Sketch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to a main sketch files.
	MainFile string `protobuf:"bytes,1,opt,name=main_file,json=mainFile,proto3" json:"main_file,omitempty"`
	// Absolute path to folder that contains main_file.
	LocationPath string `protobuf:"bytes,2,opt,name=location_path,json=locationPath,proto3" json:"location_path,omitempty"`
	// List of absolute paths to other sketch files.
	OtherSketchFiles []string `protobuf:"bytes,3,rep,name=other_sketch_files,json=otherSketchFiles,proto3" json:"other_sketch_files,omitempty"`
	// List of absolute paths to additional sketch files.
	AdditionalFiles []string `protobuf:"bytes,4,rep,name=additional_files,json=additionalFiles,proto3" json:"additional_files,omitempty"`
	// List of absolute paths to supported files in the sketch root folder, main
	// file excluded.
	RootFolderFiles []string `protobuf:"bytes,5,rep,name=root_folder_files,json=rootFolderFiles,proto3" json:"root_folder_files,omitempty"`
	// Default FQBN set in project file (sketch.yaml).
	DefaultFqbn string `protobuf:"bytes,6,opt,name=default_fqbn,json=defaultFqbn,proto3" json:"default_fqbn,omitempty"`
	// Default Port set in project file (sketch.yaml).
	DefaultPort string `protobuf:"bytes,7,opt,name=default_port,json=defaultPort,proto3" json:"default_port,omitempty"`
	// Default Protocol set in project file (sketch.yaml).
	DefaultProtocol string `protobuf:"bytes,8,opt,name=default_protocol,json=defaultProtocol,proto3" json:"default_protocol,omitempty"`
	// List of profiles present in the project file (sketch.yaml).
	Profiles []*SketchProfile `protobuf:"bytes,9,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// Default profile set in the project file (sketch.yaml).
	DefaultProfile *SketchProfile `protobuf:"bytes,10,opt,name=default_profile,json=defaultProfile,proto3" json:"default_profile,omitempty"`
	// Default Programmer set in project file (sketch.yaml).
	DefaultProgrammer string `protobuf:"bytes,11,opt,name=default_programmer,json=defaultProgrammer,proto3" json:"default_programmer,omitempty"`
	// Default Port configuration set in project file (sketch.yaml).
	DefaultPortConfig *MonitorPortConfiguration `protobuf:"bytes,12,opt,name=default_port_config,json=defaultPortConfig,proto3" json:"default_port_config,omitempty"`
}

func (x *Sketch) Reset() {
	*x = Sketch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sketch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sketch) ProtoMessage() {}

func (x *Sketch) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sketch.ProtoReflect.Descriptor instead.
func (*Sketch) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{15}
}

func (x *Sketch) GetMainFile() string {
	if x != nil {
		return x.MainFile
	}
	return ""
}

func (x *Sketch) GetLocationPath() string {
	if x != nil {
		return x.LocationPath
	}
	return ""
}

func (x *Sketch) GetOtherSketchFiles() []string {
	if x != nil {
		return x.OtherSketchFiles
	}
	return nil
}

func (x *Sketch) GetAdditionalFiles() []string {
	if x != nil {
		return x.AdditionalFiles
	}
	return nil
}

func (x *Sketch) GetRootFolderFiles() []string {
	if x != nil {
		return x.RootFolderFiles
	}
	return nil
}

func (x *Sketch) GetDefaultFqbn() string {
	if x != nil {
		return x.DefaultFqbn
	}
	return ""
}

func (x *Sketch) GetDefaultPort() string {
	if x != nil {
		return x.DefaultPort
	}
	return ""
}

func (x *Sketch) GetDefaultProtocol() string {
	if x != nil {
		return x.DefaultProtocol
	}
	return ""
}

func (x *Sketch) GetProfiles() []*SketchProfile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

func (x *Sketch) GetDefaultProfile() *SketchProfile {
	if x != nil {
		return x.DefaultProfile
	}
	return nil
}

func (x *Sketch) GetDefaultProgrammer() string {
	if x != nil {
		return x.DefaultProgrammer
	}
	return ""
}

func (x *Sketch) GetDefaultPortConfig() *MonitorPortConfiguration {
	if x != nil {
		return x.DefaultPortConfig
	}
	return nil
}

type MonitorPortConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The port configuration parameters.
	Settings []*MonitorPortSetting `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
}

func (x *MonitorPortConfiguration) Reset() {
	*x = MonitorPortConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorPortConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorPortConfiguration) ProtoMessage() {}

func (x *MonitorPortConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorPortConfiguration.ProtoReflect.Descriptor instead.
func (*MonitorPortConfiguration) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{16}
}

func (x *MonitorPortConfiguration) GetSettings() []*MonitorPortSetting {
	if x != nil {
		return x.Settings
	}
	return nil
}

type MonitorPortSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting identifier.
	SettingId string `protobuf:"bytes,1,opt,name=setting_id,json=settingId,proto3" json:"setting_id,omitempty"`
	// The setting value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *MonitorPortSetting) Reset() {
	*x = MonitorPortSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorPortSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorPortSetting) ProtoMessage() {}

func (x *MonitorPortSetting) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorPortSetting.ProtoReflect.Descriptor instead.
func (*MonitorPortSetting) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{17}
}

func (x *MonitorPortSetting) GetSettingId() string {
	if x != nil {
		return x.SettingId
	}
	return ""
}

func (x *MonitorPortSetting) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type SketchProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the profile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// FQBN used by the profile.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Programmer used by the profile.
	Programmer string `protobuf:"bytes,3,opt,name=programmer,proto3" json:"programmer,omitempty"`
	// Default Port in this profile.
	Port string `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Default Port configuration set in project file (sketch.yaml).
	PortConfig *MonitorPortConfiguration `protobuf:"bytes,5,opt,name=port_config,json=portConfig,proto3" json:"port_config,omitempty"`
	// Default Protocol in this profile.
	Protocol string `protobuf:"bytes,6,opt,name=protocol,proto3" json:"protocol,omitempty"`
}

func (x *SketchProfile) Reset() {
	*x = SketchProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SketchProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SketchProfile) ProtoMessage() {}

func (x *SketchProfile) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SketchProfile.ProtoReflect.Descriptor instead.
func (*SketchProfile) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{18}
}

func (x *SketchProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SketchProfile) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *SketchProfile) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

func (x *SketchProfile) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *SketchProfile) GetPortConfig() *MonitorPortConfiguration {
	if x != nil {
		return x.PortConfig
	}
	return nil
}

func (x *SketchProfile) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

type ProfileLibraryReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Library:
	//
	//	*ProfileLibraryReference_IndexLibrary_
	//	*ProfileLibraryReference_LocalLibrary_
	Library isProfileLibraryReference_Library `protobuf_oneof:"library"`
}

func (x *ProfileLibraryReference) Reset() {
	*x = ProfileLibraryReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProfileLibraryReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProfileLibraryReference) ProtoMessage() {}

func (x *ProfileLibraryReference) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProfileLibraryReference.ProtoReflect.Descriptor instead.
func (*ProfileLibraryReference) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{19}
}

func (m *ProfileLibraryReference) GetLibrary() isProfileLibraryReference_Library {
	if m != nil {
		return m.Library
	}
	return nil
}

func (x *ProfileLibraryReference) GetIndexLibrary() *ProfileLibraryReference_IndexLibrary {
	if x, ok := x.GetLibrary().(*ProfileLibraryReference_IndexLibrary_); ok {
		return x.IndexLibrary
	}
	return nil
}

func (x *ProfileLibraryReference) GetLocalLibrary() *ProfileLibraryReference_LocalLibrary {
	if x, ok := x.GetLibrary().(*ProfileLibraryReference_LocalLibrary_); ok {
		return x.LocalLibrary
	}
	return nil
}

type isProfileLibraryReference_Library interface {
	isProfileLibraryReference_Library()
}

type ProfileLibraryReference_IndexLibrary_ struct {
	// The library is installed from the Library Index.
	IndexLibrary *ProfileLibraryReference_IndexLibrary `protobuf:"bytes,1,opt,name=index_library,json=indexLibrary,proto3,oneof"`
}

type ProfileLibraryReference_LocalLibrary_ struct {
	// The library is a local library.
	LocalLibrary *ProfileLibraryReference_LocalLibrary `protobuf:"bytes,2,opt,name=local_library,json=localLibrary,proto3,oneof"`
}

func (*ProfileLibraryReference_IndexLibrary_) isProfileLibraryReference_Library() {}

func (*ProfileLibraryReference_LocalLibrary_) isProfileLibraryReference_Library() {}

type ProfileLibraryReference_IndexLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the library.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the library if taken from the Library Index.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// If true, this library is marked as a dependency.
	IsDependency bool `protobuf:"varint,3,opt,name=is_dependency,json=isDependency,proto3" json:"is_dependency,omitempty"`
}

func (x *ProfileLibraryReference_IndexLibrary) Reset() {
	*x = ProfileLibraryReference_IndexLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProfileLibraryReference_IndexLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProfileLibraryReference_IndexLibrary) ProtoMessage() {}

func (x *ProfileLibraryReference_IndexLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProfileLibraryReference_IndexLibrary.ProtoReflect.Descriptor instead.
func (*ProfileLibraryReference_IndexLibrary) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{19, 0}
}

func (x *ProfileLibraryReference_IndexLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProfileLibraryReference_IndexLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ProfileLibraryReference_IndexLibrary) GetIsDependency() bool {
	if x != nil {
		return x.IsDependency
	}
	return false
}

type ProfileLibraryReference_LocalLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to the library.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ProfileLibraryReference_LocalLibrary) Reset() {
	*x = ProfileLibraryReference_LocalLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProfileLibraryReference_LocalLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProfileLibraryReference_LocalLibrary) ProtoMessage() {}

func (x *ProfileLibraryReference_LocalLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_common_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProfileLibraryReference_LocalLibrary.ProtoReflect.Descriptor instead.
func (*ProfileLibraryReference_LocalLibrary) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP(), []int{19, 1}
}

func (x *ProfileLibraryReference_LocalLibrary) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

var File_cc_arduino_cli_commands_v1_common_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_common_proto_rawDesc = []byte{
	0x0a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x22, 0x1a, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02, 0x69,
	0x64, 0x22, 0xfb, 0x01, 0x0a, 0x10, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x4c, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x43, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x64, 0x48, 0x00, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x3f, 0x0a, 0x15, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x22, 0x57, 0x0a, 0x16, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x49, 0x0a, 0x13, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x64,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x74, 0x0a, 0x0c, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x0a, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x22, 0x9b, 0x01, 0x0a, 0x08, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12,
	0x48, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x22, 0xf0, 0x02, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x12, 0x48, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x55,
	0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x68, 0x0a, 0x0d, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xdb, 0x01, 0x0a, 0x10, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x2d, 0x0a, 0x12, 0x6d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x6c, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x64, 0x22, 0xd8, 0x02, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x06, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x06, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x73, 0x12, 0x3d, 0x0a, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65,
	0x6c, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x04, 0x68, 0x65, 0x6c,
	0x70, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x0a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x88, 0x01, 0x0a,
	0x1a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x5f, 0x64, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x44, 0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x55, 0x72, 0x6c, 0x22, 0x2f, 0x0a, 0x05, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22, 0x27, 0x0a, 0x0d, 0x48, 0x65, 0x6c, 0x70,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x22, 0xf0, 0x04, 0x0a, 0x06, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2c,
	0x0a, 0x12, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x72, 0x6f, 0x6f, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x66,
	0x71, 0x62, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x46, 0x71, 0x62, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x6d, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x12, 0x64,
	0x0a, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x66, 0x0a, 0x18, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4a, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x49, 0x0a, 0x12,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x0d, 0x53, 0x6b, 0x65, 0x74,
	0x63, 0x68, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62,
	0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x22, 0xfd, 0x02, 0x0a, 0x17, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x67, 0x0a, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52,
	0x0c, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x67, 0x0a,
	0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x1a, 0x61, 0x0a, 0x0c, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x22, 0x0a, 0x0c, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x42, 0x09, 0x0a,
	0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63,
	0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_common_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_common_proto_rawDescData = file_cc_arduino_cli_commands_v1_common_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_common_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_common_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_common_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_common_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_cc_arduino_cli_commands_v1_common_proto_goTypes = []any{
	(*Instance)(nil),                             // 0: cc.arduino.cli.commands.v1.Instance
	(*DownloadProgress)(nil),                     // 1: cc.arduino.cli.commands.v1.DownloadProgress
	(*DownloadProgressStart)(nil),                // 2: cc.arduino.cli.commands.v1.DownloadProgressStart
	(*DownloadProgressUpdate)(nil),               // 3: cc.arduino.cli.commands.v1.DownloadProgressUpdate
	(*DownloadProgressEnd)(nil),                  // 4: cc.arduino.cli.commands.v1.DownloadProgressEnd
	(*TaskProgress)(nil),                         // 5: cc.arduino.cli.commands.v1.TaskProgress
	(*Programmer)(nil),                           // 6: cc.arduino.cli.commands.v1.Programmer
	(*MissingProgrammerError)(nil),               // 7: cc.arduino.cli.commands.v1.MissingProgrammerError
	(*Platform)(nil),                             // 8: cc.arduino.cli.commands.v1.Platform
	(*PlatformSummary)(nil),                      // 9: cc.arduino.cli.commands.v1.PlatformSummary
	(*PlatformMetadata)(nil),                     // 10: cc.arduino.cli.commands.v1.PlatformMetadata
	(*PlatformRelease)(nil),                      // 11: cc.arduino.cli.commands.v1.PlatformRelease
	(*InstalledPlatformReference)(nil),           // 12: cc.arduino.cli.commands.v1.InstalledPlatformReference
	(*Board)(nil),                                // 13: cc.arduino.cli.commands.v1.Board
	(*HelpResources)(nil),                        // 14: cc.arduino.cli.commands.v1.HelpResources
	(*Sketch)(nil),                               // 15: cc.arduino.cli.commands.v1.Sketch
	(*MonitorPortConfiguration)(nil),             // 16: cc.arduino.cli.commands.v1.MonitorPortConfiguration
	(*MonitorPortSetting)(nil),                   // 17: cc.arduino.cli.commands.v1.MonitorPortSetting
	(*SketchProfile)(nil),                        // 18: cc.arduino.cli.commands.v1.SketchProfile
	(*ProfileLibraryReference)(nil),              // 19: cc.arduino.cli.commands.v1.ProfileLibraryReference
	nil,                                          // 20: cc.arduino.cli.commands.v1.PlatformSummary.ReleasesEntry
	(*ProfileLibraryReference_IndexLibrary)(nil), // 21: cc.arduino.cli.commands.v1.ProfileLibraryReference.IndexLibrary
	(*ProfileLibraryReference_LocalLibrary)(nil), // 22: cc.arduino.cli.commands.v1.ProfileLibraryReference.LocalLibrary
}
var file_cc_arduino_cli_commands_v1_common_proto_depIdxs = []int32{
	2,  // 0: cc.arduino.cli.commands.v1.DownloadProgress.start:type_name -> cc.arduino.cli.commands.v1.DownloadProgressStart
	3,  // 1: cc.arduino.cli.commands.v1.DownloadProgress.update:type_name -> cc.arduino.cli.commands.v1.DownloadProgressUpdate
	4,  // 2: cc.arduino.cli.commands.v1.DownloadProgress.end:type_name -> cc.arduino.cli.commands.v1.DownloadProgressEnd
	10, // 3: cc.arduino.cli.commands.v1.Platform.metadata:type_name -> cc.arduino.cli.commands.v1.PlatformMetadata
	11, // 4: cc.arduino.cli.commands.v1.Platform.release:type_name -> cc.arduino.cli.commands.v1.PlatformRelease
	10, // 5: cc.arduino.cli.commands.v1.PlatformSummary.metadata:type_name -> cc.arduino.cli.commands.v1.PlatformMetadata
	20, // 6: cc.arduino.cli.commands.v1.PlatformSummary.releases:type_name -> cc.arduino.cli.commands.v1.PlatformSummary.ReleasesEntry
	13, // 7: cc.arduino.cli.commands.v1.PlatformRelease.boards:type_name -> cc.arduino.cli.commands.v1.Board
	14, // 8: cc.arduino.cli.commands.v1.PlatformRelease.help:type_name -> cc.arduino.cli.commands.v1.HelpResources
	18, // 9: cc.arduino.cli.commands.v1.Sketch.profiles:type_name -> cc.arduino.cli.commands.v1.SketchProfile
	18, // 10: cc.arduino.cli.commands.v1.Sketch.default_profile:type_name -> cc.arduino.cli.commands.v1.SketchProfile
	16, // 11: cc.arduino.cli.commands.v1.Sketch.default_port_config:type_name -> cc.arduino.cli.commands.v1.MonitorPortConfiguration
	17, // 12: cc.arduino.cli.commands.v1.MonitorPortConfiguration.settings:type_name -> cc.arduino.cli.commands.v1.MonitorPortSetting
	16, // 13: cc.arduino.cli.commands.v1.SketchProfile.port_config:type_name -> cc.arduino.cli.commands.v1.MonitorPortConfiguration
	21, // 14: cc.arduino.cli.commands.v1.ProfileLibraryReference.index_library:type_name -> cc.arduino.cli.commands.v1.ProfileLibraryReference.IndexLibrary
	22, // 15: cc.arduino.cli.commands.v1.ProfileLibraryReference.local_library:type_name -> cc.arduino.cli.commands.v1.ProfileLibraryReference.LocalLibrary
	11, // 16: cc.arduino.cli.commands.v1.PlatformSummary.ReleasesEntry.value:type_name -> cc.arduino.cli.commands.v1.PlatformRelease
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_common_proto_init() }
func file_cc_arduino_cli_commands_v1_common_proto_init() {
	if File_cc_arduino_cli_commands_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadProgressStart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadProgressUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadProgressEnd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*TaskProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Programmer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*MissingProgrammerError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Platform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*InstalledPlatformReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Board); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*HelpResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Sketch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorPortConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorPortSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*SketchProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*ProfileLibraryReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*ProfileLibraryReference_IndexLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_common_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*ProfileLibraryReference_LocalLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_common_proto_msgTypes[1].OneofWrappers = []any{
		(*DownloadProgress_Start)(nil),
		(*DownloadProgress_Update)(nil),
		(*DownloadProgress_End)(nil),
	}
	file_cc_arduino_cli_commands_v1_common_proto_msgTypes[19].OneofWrappers = []any{
		(*ProfileLibraryReference_IndexLibrary_)(nil),
		(*ProfileLibraryReference_LocalLibrary_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_common_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_common_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_common_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_common_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_common_proto = out.File
	file_cc_arduino_cli_commands_v1_common_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_common_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_common_proto_depIdxs = nil
}
