/* key.c generated by valac 0.56.18, the Vala compiler
 * generated from key.vala, do not modify */

/* key.vala
 *
 * Copyright 2022 Vojtěch Perník
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>

#define WG_KEY_PREV_SIZE 30
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WG_TYPE_KEY (wg_key_get_type ())
#define WG_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_KEY, WGKey))
#define WG_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_KEY, WGKeyClass))
#define WG_IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_KEY))
#define WG_IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_KEY))
#define WG_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_KEY, WGKeyClass))

typedef struct _WGKey WGKey;
typedef struct _WGKeyClass WGKeyClass;
typedef struct _WGKeyPrivate WGKeyPrivate;
typedef enum  {
	WG_CELL_STATE_CORRECT,
	WG_CELL_STATE_WRONG,
	WG_CELL_STATE_WRONG_POSITION,
	WG_CELL_STATE_UNKNOWN,
	WG_CELL_STATE_NONE
} WGCellState;

#define WG_TYPE_CELL_STATE (wg_cell_state_get_type ())
enum  {
	WG_KEY_0_PROPERTY,
	WG_KEY_DISPLAY_VAL_PROPERTY,
	WG_KEY_VAL_PROPERTY,
	WG_KEY_SIZE_PROPERTY,
	WG_KEY_SPACING_PROPERTY,
	WG_KEY_STATE_PROPERTY,
	WG_KEY_NUM_PROPERTIES
};
static GParamSpec* wg_key_properties[WG_KEY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	WG_KEY_CLICKED_SIGNAL,
	WG_KEY_NUM_SIGNALS
};
static guint wg_key_signals[WG_KEY_NUM_SIGNALS] = {0};

struct _WGKey {
	AdwBin parent_instance;
	WGKeyPrivate * priv;
};

struct _WGKeyClass {
	AdwBinClass parent_class;
};

struct _WGKeyPrivate {
	gchar* _display_val;
	gchar* _val;
	gdouble _size;
	gint _spacing;
	WGCellState _state;
	GtkButton* button;
};

static gint WGKey_private_offset;
static gpointer wg_key_parent_class = NULL;

VALA_EXTERN GType wg_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGKey, g_object_unref)
VALA_EXTERN GType wg_cell_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WGKey* wg_key_new (const gchar* display_val,
                   const gchar* val,
                   gdouble size,
                   gint spacing);
VALA_EXTERN WGKey* wg_key_construct (GType object_type,
                         const gchar* display_val,
                         const gchar* val,
                         gdouble size,
                         gint spacing);
static void wg_key_update_styles (WGKey* self);
VALA_EXTERN WGCellState wg_key_get_state (WGKey* self);
VALA_EXTERN const gchar* wg_key_get_display_val (WGKey* self);
static void wg_key_set_display_val (WGKey* self,
                             const gchar* value);
VALA_EXTERN const gchar* wg_key_get_val (WGKey* self);
static void wg_key_set_val (WGKey* self,
                     const gchar* value);
VALA_EXTERN gdouble wg_key_get_size (WGKey* self);
static void wg_key_set_size (WGKey* self,
                      gdouble value);
VALA_EXTERN gint wg_key_get_spacing (WGKey* self);
static void wg_key_set_spacing (WGKey* self,
                         gint value);
VALA_EXTERN void wg_key_set_state (WGKey* self,
                       WGCellState value);
static GObject * wg_key_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties);
static void _wg_key___lambda11_ (WGKey* self);
static void __wg_key___lambda11__gtk_button_clicked (GtkButton* _sender,
                                              gpointer self);
static void _wg_key_update_styles_g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self);
static void wg_key_finalize (GObject * obj);
static GType wg_key_get_type_once (void);
static void _vala_wg_key_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_wg_key_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);

static inline gpointer
wg_key_get_instance_private (WGKey* self)
{
	return G_STRUCT_MEMBER_P (self, WGKey_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

WGKey*
wg_key_construct (GType object_type,
                  const gchar* display_val,
                  const gchar* val,
                  gdouble size,
                  gint spacing)
{
	WGKey * self = NULL;
	gchar* _display_val = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _val = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gdouble _tmp9_ = 0.0;
	gint _tmp10_ = 0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_val_if_fail (display_val != NULL, NULL);
	_tmp0_ = string_strip (display_val);
	_display_val = _tmp0_;
	if (val == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = _display_val;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = string_strip (val);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp1_);
	_val = _tmp5_;
	_tmp6_ = _val;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = _display_val;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (_val);
		_val = _tmp8_;
	}
	if (size < ((gdouble) 1)) {
		_tmp9_ = (gdouble) 1;
	} else {
		_tmp9_ = size;
	}
	if (spacing < 0) {
		_tmp10_ = 0;
	} else {
		_tmp10_ = spacing;
	}
	_tmp11_ = _display_val;
	_tmp12_ = _val;
	self = (WGKey*) g_object_new (object_type, "display-val", _tmp11_, "val", _tmp12_, "size", _tmp9_, "spacing", _tmp10_, NULL);
	_g_free0 (_val);
	_g_free0 (_tmp1_);
	_g_free0 (_display_val);
	return self;
}

WGKey*
wg_key_new (const gchar* display_val,
            const gchar* val,
            gdouble size,
            gint spacing)
{
	return wg_key_construct (WG_TYPE_KEY, display_val, val, size, spacing);
}

static void
wg_key_update_styles (WGKey* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	WGCellState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp0_, "correct");
	_tmp1_ = self->priv->button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp1_, "wrong");
	_tmp2_ = self->priv->button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp2_, "position");
	_tmp3_ = self->priv->_state;
	switch (_tmp3_) {
		case WG_CELL_STATE_CORRECT:
		{
			GtkButton* _tmp4_;
			_tmp4_ = self->priv->button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "correct");
			break;
		}
		case WG_CELL_STATE_WRONG:
		{
			GtkButton* _tmp5_;
			_tmp5_ = self->priv->button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp5_, "wrong");
			break;
		}
		case WG_CELL_STATE_WRONG_POSITION:
		{
			GtkButton* _tmp6_;
			_tmp6_ = self->priv->button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp6_, "position");
			break;
		}
		case WG_CELL_STATE_UNKNOWN:
		case WG_CELL_STATE_NONE:
		{
			break;
		}
		default:
		break;
	}
}

const gchar*
wg_key_get_display_val (WGKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_val;
	result = _tmp0_;
	return result;
}

static void
wg_key_set_display_val (WGKey* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_key_get_display_val (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_val);
		self->priv->_display_val = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wg_key_properties[WG_KEY_DISPLAY_VAL_PROPERTY]);
	}
}

const gchar*
wg_key_get_val (WGKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_val;
	result = _tmp0_;
	return result;
}

static void
wg_key_set_val (WGKey* self,
                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_key_get_val (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_val);
		self->priv->_val = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wg_key_properties[WG_KEY_VAL_PROPERTY]);
	}
}

gdouble
wg_key_get_size (WGKey* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_size;
	return result;
}

static void
wg_key_set_size (WGKey* self,
                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_key_get_size (self);
	if (old_value != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, wg_key_properties[WG_KEY_SIZE_PROPERTY]);
	}
}

gint
wg_key_get_spacing (WGKey* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_spacing;
	return result;
}

static void
wg_key_set_spacing (WGKey* self,
                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_key_get_spacing (self);
	if (old_value != value) {
		self->priv->_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, wg_key_properties[WG_KEY_SPACING_PROPERTY]);
	}
}

WGCellState
wg_key_get_state (WGKey* self)
{
	WGCellState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
wg_key_set_state (WGKey* self,
                  WGCellState value)
{
	WGCellState old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_key_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, wg_key_properties[WG_KEY_STATE_PROPERTY]);
	}
}

static void
_wg_key___lambda11_ (WGKey* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->_val;
	g_signal_emit (self, wg_key_signals[WG_KEY_CLICKED_SIGNAL], 0, _tmp0_);
}

static void
__wg_key___lambda11__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self)
{
	_wg_key___lambda11_ ((WGKey*) self);
}

static void
_wg_key_update_styles_g_object_notify (GObject* _sender,
                                       GParamSpec* pspec,
                                       gpointer self)
{
	wg_key_update_styles ((WGKey*) self);
}

static GObject *
wg_key_constructor (GType type,
                    guint n_construct_properties,
                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WGKey * self;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	gdouble new_size = 0.0;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	parent_class = G_OBJECT_CLASS (wg_key_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_KEY, WGKey);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->button);
	self->priv->button = _tmp0_;
	_tmp1_ = self->priv->button;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "key");
	_tmp3_ = self->priv->button;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->_display_val;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("enter")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp8_;
				GtkButton* _tmp9_;
				_tmp8_ = self->priv->button;
				gtk_button_set_icon_name (_tmp8_, "keyboard-enter-symbolic");
				_tmp9_ = self->priv->button;
				gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "suggested-action");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("backspace")))) {
		switch (0) {
			default:
			{
				GtkButton* _tmp10_;
				GtkButton* _tmp11_;
				_tmp10_ = self->priv->button;
				gtk_button_set_icon_name (_tmp10_, "entry-clear-symbolic");
				_tmp11_ = self->priv->button;
				gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "destructive-action");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkButton* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = self->priv->button;
				_tmp13_ = self->priv->_display_val;
				_tmp14_ = g_utf8_strup (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				gtk_button_set_label (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				break;
			}
		}
	}
	_tmp16_ = self->priv->_size;
	new_size = _tmp16_ * WG_KEY_PREV_SIZE;
	_tmp17_ = self->priv->_size;
	_tmp18_ = self->priv->_spacing;
	new_size = new_size + ((ceil (_tmp17_) - 1) * _tmp18_);
	_tmp19_ = self->priv->_size;
	_tmp20_ = self->priv->_size;
	_tmp21_ = self->priv->_spacing;
	new_size = new_size - ((_tmp19_ - floor (_tmp20_)) * _tmp21_);
	_tmp22_ = self->priv->button;
	g_object_set ((GtkWidget*) _tmp22_, "width-request", (gint) round (new_size), NULL);
	_tmp23_ = self->priv->button;
	g_signal_connect_object (_tmp23_, "clicked", (GCallback) __wg_key___lambda11__gtk_button_clicked, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _wg_key_update_styles_g_object_notify, self, 0);
	wg_key_update_styles (self);
	return obj;
}

static void
wg_key_class_init (WGKeyClass * klass,
                   gpointer klass_data)
{
	wg_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WGKey_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wg_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wg_key_set_property;
	G_OBJECT_CLASS (klass)->constructor = wg_key_constructor;
	G_OBJECT_CLASS (klass)->finalize = wg_key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEY_DISPLAY_VAL_PROPERTY, wg_key_properties[WG_KEY_DISPLAY_VAL_PROPERTY] = g_param_spec_string ("display-val", "display-val", "display-val", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEY_VAL_PROPERTY, wg_key_properties[WG_KEY_VAL_PROPERTY] = g_param_spec_string ("val", "val", "val", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEY_SIZE_PROPERTY, wg_key_properties[WG_KEY_SIZE_PROPERTY] = g_param_spec_double ("size", "size", "size", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEY_SPACING_PROPERTY, wg_key_properties[WG_KEY_SPACING_PROPERTY] = g_param_spec_int ("spacing", "spacing", "spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_KEY_STATE_PROPERTY, wg_key_properties[WG_KEY_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", WG_TYPE_CELL_STATE, WG_CELL_STATE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	wg_key_signals[WG_KEY_CLICKED_SIGNAL] = g_signal_new ("clicked", WG_TYPE_KEY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
wg_key_instance_init (WGKey * self,
                      gpointer klass)
{
	self->priv = wg_key_get_instance_private (self);
	self->priv->_state = WG_CELL_STATE_NONE;
}

static void
wg_key_finalize (GObject * obj)
{
	WGKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_KEY, WGKey);
	_g_free0 (self->priv->_display_val);
	_g_free0 (self->priv->_val);
	_g_object_unref0 (self->priv->button);
	G_OBJECT_CLASS (wg_key_parent_class)->finalize (obj);
}

static GType
wg_key_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WGKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wg_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WGKey), 0, (GInstanceInitFunc) wg_key_instance_init, NULL };
	GType wg_key_type_id;
	wg_key_type_id = g_type_register_static (adw_bin_get_type (), "WGKey", &g_define_type_info, 0);
	WGKey_private_offset = g_type_add_instance_private (wg_key_type_id, sizeof (WGKeyPrivate));
	return wg_key_type_id;
}

GType
wg_key_get_type (void)
{
	static volatile gsize wg_key_type_id__once = 0;
	if (g_once_init_enter (&wg_key_type_id__once)) {
		GType wg_key_type_id;
		wg_key_type_id = wg_key_get_type_once ();
		g_once_init_leave (&wg_key_type_id__once, wg_key_type_id);
	}
	return wg_key_type_id__once;
}

static void
_vala_wg_key_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	WGKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_KEY, WGKey);
	switch (property_id) {
		case WG_KEY_DISPLAY_VAL_PROPERTY:
		g_value_set_string (value, wg_key_get_display_val (self));
		break;
		case WG_KEY_VAL_PROPERTY:
		g_value_set_string (value, wg_key_get_val (self));
		break;
		case WG_KEY_SIZE_PROPERTY:
		g_value_set_double (value, wg_key_get_size (self));
		break;
		case WG_KEY_SPACING_PROPERTY:
		g_value_set_int (value, wg_key_get_spacing (self));
		break;
		case WG_KEY_STATE_PROPERTY:
		g_value_set_enum (value, wg_key_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wg_key_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	WGKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_KEY, WGKey);
	switch (property_id) {
		case WG_KEY_DISPLAY_VAL_PROPERTY:
		wg_key_set_display_val (self, g_value_get_string (value));
		break;
		case WG_KEY_VAL_PROPERTY:
		wg_key_set_val (self, g_value_get_string (value));
		break;
		case WG_KEY_SIZE_PROPERTY:
		wg_key_set_size (self, g_value_get_double (value));
		break;
		case WG_KEY_SPACING_PROPERTY:
		wg_key_set_spacing (self, g_value_get_int (value));
		break;
		case WG_KEY_STATE_PROPERTY:
		wg_key_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

