/* AppSystem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>

#define SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_0_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS
};
static guint slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS] = {0};

struct _SlingshotBackendAppSystemPrivate {
	GeeHashMap* _apps;
	guint refresh_timeout_id;
	GeeArrayList* categories_cache;
	GAppInfoMonitor* app_monitor;
};

static gint SlingshotBackendAppSystem_private_offset;
static gpointer slingshot_backend_app_system_parent_class = NULL;
static GType slingshot_backend_app_system_type_id = 0;

static void slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self);
static gboolean __lambda33_ (SlingshotBackendAppSystem* self);
static void slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self);
static gboolean ___lambda33__gsource_func (gpointer self);
static void slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gint slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                     SlingshotBackendApp* b);
static gint _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                            GeeHashMap* value);
static GObject * slingshot_backend_app_system_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                       gpointer self);
static void slingshot_backend_app_system_finalize (GObject * obj);
static void _vala_slingshot_backend_app_system_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_slingshot_backend_app_system_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_backend_app_system_get_instance_private (SlingshotBackendAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendAppSystem_private_offset);
}

static gboolean
__lambda33_ (SlingshotBackendAppSystem* self)
{
	gboolean result;
	slingshot_backend_app_system_update_app_system (self);
	self->priv->refresh_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda33_ ((SlingshotBackendAppSystem*) self);
	return result;
}

static void
slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->refresh_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->refresh_timeout_id);
		self->priv->refresh_timeout_id = (guint) 0;
	}
	self->priv->refresh_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS, ___lambda33__gsource_func, g_object_ref (self), g_object_unref);
}

static void
slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	g_debug ("AppSystem.vala:64: Updating Applications menu tree…");
	slingshot_backend_app_system_update_categories_index (self);
	g_signal_emit (self, slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL], 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	SlingshotBackendCategory* _tmp9_ = NULL;
	SlingshotBackendCategory* _tmp10_;
	GeeArrayList* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	SlingshotBackendCategory* _tmp14_ = NULL;
	SlingshotBackendCategory* _tmp15_;
	GeeArrayList* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	SlingshotBackendCategory* _tmp19_ = NULL;
	SlingshotBackendCategory* _tmp20_;
	GeeArrayList* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	SlingshotBackendCategory* _tmp26_ = NULL;
	SlingshotBackendCategory* _tmp27_;
	GeeArrayList* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	SlingshotBackendCategory* _tmp34_ = NULL;
	SlingshotBackendCategory* _tmp35_;
	GeeArrayList* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	SlingshotBackendCategory* _tmp39_ = NULL;
	SlingshotBackendCategory* _tmp40_;
	GeeArrayList* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	SlingshotBackendCategory* _tmp44_ = NULL;
	SlingshotBackendCategory* _tmp45_;
	GeeArrayList* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	SlingshotBackendCategory* _tmp49_ = NULL;
	SlingshotBackendCategory* _tmp50_;
	GeeArrayList* _tmp51_;
	gchar* _tmp52_;
	gchar** _tmp53_;
	SlingshotBackendCategory* _tmp54_ = NULL;
	SlingshotBackendCategory* _tmp55_;
	GeeArrayList* _tmp56_;
	gchar* _tmp57_;
	gchar** _tmp58_;
	SlingshotBackendCategory* _tmp59_ = NULL;
	SlingshotBackendCategory* _tmp60_;
	GeeArrayList* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar* _tmp68_;
	gchar** _tmp69_;
	SlingshotBackendCategory* _tmp70_ = NULL;
	SlingshotBackendCategory* _tmp71_;
	SlingshotBackendCategory* other_category = NULL;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar** _tmp75_;
	SlingshotBackendCategory* _tmp76_ = NULL;
	GList* _tmp77_;
	SlingshotBackendCategory* _tmp112_;
	GeeArrayList* _tmp113_;
	GeeArrayList* _tmp114_;
	gint _tmp115_;
	gint _tmp116_;
	GeeHashMap* _tmp119_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->categories_cache;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->categories_cache;
	_tmp2_ = g_strdup ("Utility");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = g_strdup ("Accessibility");
	_tmp5_ = g_strdup ("System");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = g_strdup ("plank.desktop");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = slingshot_backend_category_new (_ ("Accessories"), FALSE);
	_tmp9_->included_categories = (_vala_array_free (_tmp9_->included_categories, _tmp9_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp9_->included_categories = _tmp3_;
	_tmp9_->included_categories_length1 = 1;
	_tmp9_->excluded_categories = (_vala_array_free (_tmp9_->excluded_categories, _tmp9_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp9_->excluded_categories = _tmp6_;
	_tmp9_->excluded_categories_length1 = 2;
	_tmp9_->excluded_applications = (_vala_array_free (_tmp9_->excluded_applications, _tmp9_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp9_->excluded_applications = _tmp8_;
	_tmp9_->excluded_applications_length1 = 1;
	_tmp10_ = _tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->categories_cache;
	_tmp12_ = g_strdup ("Accessibility");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = slingshot_backend_category_new (_ ("Universal Access"), FALSE);
	_tmp14_->included_categories = (_vala_array_free (_tmp14_->included_categories, _tmp14_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp14_->included_categories = _tmp13_;
	_tmp14_->included_categories_length1 = 1;
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->categories_cache;
	_tmp17_ = g_strdup ("Development");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = slingshot_backend_category_new (_ ("Programming"), FALSE);
	_tmp19_->included_categories = (_vala_array_free (_tmp19_->included_categories, _tmp19_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp19_->included_categories = _tmp18_;
	_tmp19_->included_categories_length1 = 1;
	_tmp20_ = _tmp19_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->categories_cache;
	_tmp22_ = g_strdup ("Education");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = g_strdup ("Science");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = slingshot_backend_category_new (_ ("Education"), FALSE);
	_tmp26_->included_categories = (_vala_array_free (_tmp26_->included_categories, _tmp26_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp26_->included_categories = _tmp23_;
	_tmp26_->included_categories_length1 = 1;
	_tmp26_->excluded_categories = (_vala_array_free (_tmp26_->excluded_categories, _tmp26_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp26_->excluded_categories = _tmp25_;
	_tmp26_->excluded_categories_length1 = 1;
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->categories_cache;
	_tmp29_ = g_strdup ("Science");
	_tmp30_ = g_strdup ("Education");
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp29_;
	_tmp31_[1] = _tmp30_;
	_tmp32_ = g_strdup ("libreoffice-math.desktop");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = slingshot_backend_category_new (_ ("Science"), FALSE);
	_tmp34_->included_categories = (_vala_array_free (_tmp34_->included_categories, _tmp34_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp34_->included_categories = _tmp31_;
	_tmp34_->included_categories_length1 = 2;
	_tmp34_->excluded_applications = (_vala_array_free (_tmp34_->excluded_applications, _tmp34_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp34_->excluded_applications = _tmp33_;
	_tmp34_->excluded_applications_length1 = 1;
	_tmp35_ = _tmp34_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->categories_cache;
	_tmp37_ = g_strdup ("Game");
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	_tmp39_ = slingshot_backend_category_new (_ ("Games"), FALSE);
	_tmp39_->included_categories = (_vala_array_free (_tmp39_->included_categories, _tmp39_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp39_->included_categories = _tmp38_;
	_tmp39_->included_categories_length1 = 1;
	_tmp40_ = _tmp39_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = self->priv->categories_cache;
	_tmp42_ = g_strdup ("Graphics");
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	_tmp44_ = slingshot_backend_category_new (_ ("Graphics"), FALSE);
	_tmp44_->included_categories = (_vala_array_free (_tmp44_->included_categories, _tmp44_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp44_->included_categories = _tmp43_;
	_tmp44_->included_categories_length1 = 1;
	_tmp45_ = _tmp44_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp45_);
	_g_object_unref0 (_tmp45_);
	_tmp46_ = self->priv->categories_cache;
	_tmp47_ = g_strdup ("Network");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = slingshot_backend_category_new (_ ("Internet"), FALSE);
	_tmp49_->included_categories = (_vala_array_free (_tmp49_->included_categories, _tmp49_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp49_->included_categories = _tmp48_;
	_tmp49_->included_categories_length1 = 1;
	_tmp50_ = _tmp49_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp50_);
	_g_object_unref0 (_tmp50_);
	_tmp51_ = self->priv->categories_cache;
	_tmp52_ = g_strdup ("AudioVideo");
	_tmp53_ = g_new0 (gchar*, 1 + 1);
	_tmp53_[0] = _tmp52_;
	_tmp54_ = slingshot_backend_category_new (_ ("Sound & Video"), FALSE);
	_tmp54_->included_categories = (_vala_array_free (_tmp54_->included_categories, _tmp54_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp54_->included_categories = _tmp53_;
	_tmp54_->included_categories_length1 = 1;
	_tmp55_ = _tmp54_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = self->priv->categories_cache;
	_tmp57_ = g_strdup ("Office");
	_tmp58_ = g_new0 (gchar*, 1 + 1);
	_tmp58_[0] = _tmp57_;
	_tmp59_ = slingshot_backend_category_new (_ ("Office"), FALSE);
	_tmp59_->included_categories = (_vala_array_free (_tmp59_->included_categories, _tmp59_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp59_->included_categories = _tmp58_;
	_tmp59_->included_categories_length1 = 1;
	_tmp60_ = _tmp59_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp60_);
	_g_object_unref0 (_tmp60_);
	_tmp61_ = self->priv->categories_cache;
	_tmp62_ = g_strdup ("System");
	_tmp63_ = g_strdup ("Administration");
	_tmp64_ = g_strdup ("Settings");
	_tmp65_ = g_new0 (gchar*, 3 + 1);
	_tmp65_[0] = _tmp62_;
	_tmp65_[1] = _tmp63_;
	_tmp65_[2] = _tmp64_;
	_tmp66_ = g_strdup ("Game");
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	_tmp68_ = g_strdup ("onboard-settings.desktop");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = slingshot_backend_category_new (_ ("System Tools"), FALSE);
	_tmp70_->included_categories = (_vala_array_free (_tmp70_->included_categories, _tmp70_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp70_->included_categories = _tmp65_;
	_tmp70_->included_categories_length1 = 3;
	_tmp70_->excluded_categories = (_vala_array_free (_tmp70_->excluded_categories, _tmp70_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp70_->excluded_categories = _tmp67_;
	_tmp70_->excluded_categories_length1 = 1;
	_tmp70_->excluded_applications = (_vala_array_free (_tmp70_->excluded_applications, _tmp70_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp70_->excluded_applications = _tmp69_;
	_tmp70_->excluded_applications_length1 = 1;
	_tmp71_ = _tmp70_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp71_);
	_g_object_unref0 (_tmp71_);
	_tmp72_ = g_strdup ("Core");
	_tmp73_ = g_strdup ("Screensaver");
	_tmp74_ = g_strdup ("Settings");
	_tmp75_ = g_new0 (gchar*, 3 + 1);
	_tmp75_[0] = _tmp72_;
	_tmp75_[1] = _tmp73_;
	_tmp75_[2] = _tmp74_;
	_tmp76_ = slingshot_backend_category_new (_ ("Other"), TRUE);
	_tmp76_->excluded_categories = (_vala_array_free (_tmp76_->excluded_categories, _tmp76_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp76_->excluded_categories = _tmp75_;
	_tmp76_->excluded_categories_length1 = 3;
	other_category = _tmp76_;
	_tmp77_ = g_app_info_get_all ();
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp77_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* _tmp78_;
			GAppInfo* app = NULL;
			_tmp78_ = _g_object_ref0 ((GAppInfo*) app_it->data);
			app = _tmp78_;
			{
				GDesktopAppInfo* desktop_app = NULL;
				GAppInfo* _tmp79_;
				GDesktopAppInfo* _tmp80_;
				GDesktopAppInfo* _tmp81_;
				gchar* control_center = NULL;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gboolean _tmp85_;
				gboolean _tmp87_ = FALSE;
				GAppInfo* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				GAppInfo* _tmp98_;
				const gchar* _tmp99_;
				gboolean found_category = FALSE;
				_tmp79_ = app;
				desktop_app = G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp79_) : NULL;
				_tmp80_ = desktop_app;
				if (_tmp80_ == NULL) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp81_ = desktop_app;
				if (!g_app_info_should_show ((GAppInfo*) _tmp81_)) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp82_ = g_strdup ("gnome-control-center");
				control_center = _tmp82_;
				_tmp83_ = g_find_program_in_path ("budgie-control-center");
				_tmp84_ = _tmp83_;
				_tmp85_ = _tmp84_ != NULL;
				_g_free0 (_tmp84_);
				if (_tmp85_) {
					gchar* _tmp86_;
					_tmp86_ = g_strdup ("budgie-control-center");
					_g_free0 (control_center);
					control_center = _tmp86_;
				}
				_tmp88_ = app;
				_tmp89_ = g_app_info_get_commandline (_tmp88_);
				_tmp90_ = control_center;
				if (string_contains (_tmp89_, _tmp90_)) {
					GAppInfo* _tmp91_;
					const gchar* _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					const gchar* _tmp95_;
					gint _tmp96_;
					gint _tmp97_;
					_tmp91_ = app;
					_tmp92_ = g_app_info_get_commandline (_tmp91_);
					_tmp93_ = strlen (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = control_center;
					_tmp96_ = strlen (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp87_ = _tmp94_ != _tmp97_;
				} else {
					_tmp87_ = FALSE;
				}
				if (_tmp87_) {
					_g_free0 (control_center);
					_g_object_unref0 (app);
					continue;
				}
				_tmp98_ = app;
				_tmp99_ = g_app_info_get_commandline (_tmp98_);
				if (g_strcmp0 (_tmp99_, "plank") == 0) {
					_g_free0 (control_center);
					_g_object_unref0 (app);
					continue;
				}
				found_category = FALSE;
				{
					GeeArrayList* _category_list = NULL;
					GeeArrayList* _tmp100_;
					gint _category_size = 0;
					GeeArrayList* _tmp101_;
					gint _tmp102_;
					gint _tmp103_;
					gint _category_index = 0;
					_tmp100_ = self->priv->categories_cache;
					_category_list = _tmp100_;
					_tmp101_ = _category_list;
					_tmp102_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp101_);
					_tmp103_ = _tmp102_;
					_category_size = _tmp103_;
					_category_index = -1;
					while (TRUE) {
						gint _tmp104_;
						gint _tmp105_;
						SlingshotBackendCategory* category = NULL;
						GeeArrayList* _tmp106_;
						gpointer _tmp107_;
						SlingshotBackendCategory* _tmp108_;
						GDesktopAppInfo* _tmp109_;
						_category_index = _category_index + 1;
						_tmp104_ = _category_index;
						_tmp105_ = _category_size;
						if (!(_tmp104_ < _tmp105_)) {
							break;
						}
						_tmp106_ = _category_list;
						_tmp107_ = gee_abstract_list_get ((GeeAbstractList*) _tmp106_, _category_index);
						category = (SlingshotBackendCategory*) _tmp107_;
						_tmp108_ = category;
						_tmp109_ = desktop_app;
						if (slingshot_backend_category_add_app_if_matches (_tmp108_, _tmp109_)) {
							found_category = TRUE;
						}
						_g_object_unref0 (category);
					}
				}
				if (!found_category) {
					SlingshotBackendCategory* _tmp110_;
					GDesktopAppInfo* _tmp111_;
					_tmp110_ = other_category;
					_tmp111_ = desktop_app;
					slingshot_backend_category_add_app_if_matches (_tmp110_, _tmp111_);
				}
				_g_free0 (control_center);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_list_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp112_ = other_category;
	_tmp113_ = slingshot_backend_category_get_apps (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp114_);
	_tmp116_ = _tmp115_;
	if (_tmp116_ > 0) {
		GeeArrayList* _tmp117_;
		SlingshotBackendCategory* _tmp118_;
		_tmp117_ = self->priv->categories_cache;
		_tmp118_ = other_category;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp117_, _tmp118_);
	}
	_tmp119_ = self->priv->_apps;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp119_);
	{
		GeeArrayList* _cat_list = NULL;
		GeeArrayList* _tmp120_;
		gint _cat_size = 0;
		GeeArrayList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _cat_index = 0;
		_tmp120_ = self->priv->categories_cache;
		_cat_list = _tmp120_;
		_tmp121_ = _cat_list;
		_tmp122_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_cat_size = _tmp123_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp124_;
			gint _tmp125_;
			SlingshotBackendCategory* cat = NULL;
			GeeArrayList* _tmp126_;
			gpointer _tmp127_;
			SlingshotBackendCategory* _tmp128_;
			GeeArrayList* _tmp129_;
			GeeArrayList* _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			_cat_index = _cat_index + 1;
			_tmp124_ = _cat_index;
			_tmp125_ = _cat_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _cat_list;
			_tmp127_ = gee_abstract_list_get ((GeeAbstractList*) _tmp126_, _cat_index);
			cat = (SlingshotBackendCategory*) _tmp127_;
			_tmp128_ = cat;
			_tmp129_ = slingshot_backend_category_get_apps (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp130_);
			_tmp132_ = _tmp131_;
			if (_tmp132_ > 0) {
				GeeHashMap* _tmp133_;
				SlingshotBackendCategory* _tmp134_;
				const gchar* _tmp135_;
				const gchar* _tmp136_;
				SlingshotBackendCategory* _tmp137_;
				GeeArrayList* _tmp138_;
				GeeArrayList* _tmp139_;
				_tmp133_ = self->priv->_apps;
				_tmp134_ = cat;
				_tmp135_ = slingshot_backend_category_get_name (_tmp134_);
				_tmp136_ = _tmp135_;
				_tmp137_ = cat;
				_tmp138_ = slingshot_backend_category_get_apps (_tmp137_);
				_tmp139_ = _tmp138_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp133_, _tmp136_, _tmp139_);
			}
			_g_object_unref0 (cat);
		}
	}
	_g_object_unref0 (other_category);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gint
_slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gint result;
	result = slingshot_backend_app_system_sort_apps_by_name ((SlingshotBackendApp*) a, (SlingshotBackendApp*) b);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GSList*
slingshot_backend_app_system_get_apps_by_name (SlingshotBackendAppSystem* self)
{
	GSList* sorted_apps = NULL;
	gchar** sorted_apps_execs = NULL;
	gchar** _tmp0_;
	gint sorted_apps_execs_length1;
	gint _sorted_apps_execs_size_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	sorted_apps = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	sorted_apps_execs = _tmp0_;
	sorted_apps_execs_length1 = 0;
	_sorted_apps_execs_size_ = sorted_apps_execs_length1;
	{
		GeeIterator* _category_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->_apps;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_category_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GeeArrayList* category = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _category_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _category_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			category = (GeeArrayList*) _tmp9_;
			{
				GeeArrayList* _app_list = NULL;
				GeeArrayList* _tmp10_;
				gint _app_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _app_index = 0;
				_tmp10_ = category;
				_app_list = _tmp10_;
				_tmp11_ = _app_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_app_size = _tmp13_;
				_app_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					SlingshotBackendApp* app = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					SlingshotBackendApp* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					_app_index = _app_index + 1;
					_tmp14_ = _app_index;
					_tmp15_ = _app_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _app_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _app_index);
					app = (SlingshotBackendApp*) _tmp17_;
					_tmp18_ = app;
					_tmp19_ = slingshot_backend_app_get_exec (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = sorted_apps_execs;
					_tmp21__length1 = sorted_apps_execs_length1;
					if (!_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
						SlingshotBackendApp* _tmp22_;
						SlingshotBackendApp* _tmp23_;
						SlingshotBackendApp* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp22_ = app;
						_tmp23_ = _g_object_ref0 (_tmp22_);
						sorted_apps = g_slist_insert_sorted_with_data (sorted_apps, _tmp23_, _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func, NULL);
						_tmp24_ = app;
						_tmp25_ = slingshot_backend_app_get_exec (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strdup (_tmp26_);
						_vala_array_add2 (&sorted_apps_execs, &sorted_apps_execs_length1, &_sorted_apps_execs_size_, _tmp27_);
					}
					_g_object_unref0 (app);
				}
			}
			_g_object_unref0 (category);
		}
		_g_object_unref0 (_category_it);
	}
	result = sorted_apps;
	sorted_apps_execs = (_vala_array_free (sorted_apps_execs, sorted_apps_execs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                SlingshotBackendApp* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = slingshot_backend_app_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = slingshot_backend_app_get_name (b);
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_construct (GType object_type)
{
	SlingshotBackendAppSystem * self = NULL;
	self = (SlingshotBackendAppSystem*) g_object_new (object_type, NULL);
	return self;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_new (void)
{
	return slingshot_backend_app_system_construct (SLINGSHOT_BACKEND_TYPE_APP_SYSTEM);
}

GeeHashMap*
slingshot_backend_app_system_get_apps (SlingshotBackendAppSystem* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                       GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_system_get_apps (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY]);
	}
}

static void
_slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                  gpointer self)
{
	slingshot_backend_app_system_queue_update_app_system ((SlingshotBackendAppSystem*) self);
}

static GObject *
slingshot_backend_app_system_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendAppSystem * self;
	GAppInfoMonitor* _tmp0_;
	GAppInfoMonitor* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeArrayList* _tmp4_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_app_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_tmp0_ = g_app_info_monitor_get ();
	_g_object_unref0 (self->priv->app_monitor);
	self->priv->app_monitor = _tmp0_;
	_tmp1_ = self->priv->app_monitor;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed, self, 0);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	slingshot_backend_app_system_set_apps (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_array_list_new (SLINGSHOT_BACKEND_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->categories_cache);
	self->priv->categories_cache = _tmp4_;
	slingshot_backend_app_system_update_app_system (self);
	return obj;
}

static void
slingshot_backend_app_system_class_init (SlingshotBackendAppSystemClass * klass,
                                         gpointer klass_data)
{
	slingshot_backend_app_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendAppSystem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_app_system_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_app_system_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_app_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_app_system_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL] = g_signal_new ("changed", SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_backend_app_system_instance_init (SlingshotBackendAppSystem * self,
                                            gpointer klass)
{
	self->priv = slingshot_backend_app_system_get_instance_private (self);
	self->priv->_apps = NULL;
	self->priv->refresh_timeout_id = (guint) 0;
	self->priv->categories_cache = NULL;
}

static void
slingshot_backend_app_system_finalize (GObject * obj)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_g_object_unref0 (self->priv->_apps);
	_g_object_unref0 (self->priv->categories_cache);
	_g_object_unref0 (self->priv->app_monitor);
	G_OBJECT_CLASS (slingshot_backend_app_system_parent_class)->finalize (obj);
}

GType
slingshot_backend_app_system_get_type (void)
{
	return slingshot_backend_app_system_type_id;
}

GType
slingshot_backend_app_system_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendAppSystem), 0, (GInstanceInitFunc) slingshot_backend_app_system_instance_init, NULL };
	slingshot_backend_app_system_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SlingshotBackendAppSystem", &g_define_type_info, 0);
	SlingshotBackendAppSystem_private_offset = sizeof (SlingshotBackendAppSystemPrivate);
	return slingshot_backend_app_system_type_id;
}

static void
_vala_slingshot_backend_app_system_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_system_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_app_system_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		slingshot_backend_app_system_set_apps (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

