/* Settings.c generated by valac 0.56.17, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <granite.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define CIANO_CONFIGS_CONSTANTS_ID "com.github.robertsanseries.ciano"
#define CIANO_CONFIGS_CONSTANTS_DIRECTORY_CIANO "/Ciano"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_SERVICES_TYPE_SETTINGS (ciano_services_settings_get_type ())
#define CIANO_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettings))
#define CIANO_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettingsClass))
#define CIANO_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_SERVICES_TYPE_SETTINGS))
#define CIANO_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_SERVICES_TYPE_SETTINGS))
#define CIANO_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettingsClass))

typedef struct _CianoServicesSettings CianoServicesSettings;
typedef struct _CianoServicesSettingsClass CianoServicesSettingsClass;
typedef struct _CianoServicesSettingsPrivate CianoServicesSettingsPrivate;
enum  {
	CIANO_SERVICES_SETTINGS_0_PROPERTY,
	CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY,
	CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY,
	CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY,
	CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY,
	CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY,
	CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY,
	CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY,
	CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY,
	CIANO_SERVICES_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CianoServicesSettings {
	GraniteServicesSettings parent_instance;
	CianoServicesSettingsPrivate * priv;
};

struct _CianoServicesSettingsClass {
	GraniteServicesSettingsClass parent_class;
};

struct _CianoServicesSettingsPrivate {
	gint _window_x;
	gint _window_y;
	gchar* _output_folder;
	gboolean _output_source_file_folder;
	gboolean _shutdown_computer;
	gboolean _open_output_folder;
	gboolean _complete_notify;
	gboolean _error_notify;
};

static gint CianoServicesSettings_private_offset;
static gpointer ciano_services_settings_parent_class = NULL;
static CianoServicesSettings* ciano_services_settings_instance;
static CianoServicesSettings* ciano_services_settings_instance = NULL;

VALA_EXTERN GType ciano_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoServicesSettings, g_object_unref)
static CianoServicesSettings* ciano_services_settings_new (void);
static CianoServicesSettings* ciano_services_settings_construct (GType object_type);
VALA_EXTERN gboolean ciano_utils_string_util_is_empty (const gchar* value);
VALA_EXTERN const gchar* ciano_services_settings_get_output_folder (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_output_folder (CianoServicesSettings* self,
                                                const gchar* value);
VALA_EXTERN CianoServicesSettings* ciano_services_settings_get_instance (void);
VALA_EXTERN gint ciano_services_settings_get_window_x (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_window_x (CianoServicesSettings* self,
                                           gint value);
VALA_EXTERN gint ciano_services_settings_get_window_y (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_window_y (CianoServicesSettings* self,
                                           gint value);
VALA_EXTERN gboolean ciano_services_settings_get_output_source_file_folder (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_output_source_file_folder (CianoServicesSettings* self,
                                                            gboolean value);
VALA_EXTERN gboolean ciano_services_settings_get_shutdown_computer (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_shutdown_computer (CianoServicesSettings* self,
                                                    gboolean value);
VALA_EXTERN gboolean ciano_services_settings_get_open_output_folder (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_open_output_folder (CianoServicesSettings* self,
                                                     gboolean value);
VALA_EXTERN gboolean ciano_services_settings_get_complete_notify (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_complete_notify (CianoServicesSettings* self,
                                                  gboolean value);
VALA_EXTERN gboolean ciano_services_settings_get_error_notify (CianoServicesSettings* self);
VALA_EXTERN void ciano_services_settings_set_error_notify (CianoServicesSettings* self,
                                               gboolean value);
static void ciano_services_settings_finalize (GObject * obj);
static GType ciano_services_settings_get_type_once (void);
static void _vala_ciano_services_settings_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_ciano_services_settings_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
ciano_services_settings_get_instance_private (CianoServicesSettings* self)
{
	return G_STRUCT_MEMBER_P (self, CianoServicesSettings_private_offset);
}

/**
         * Constructs a new {@code Settings} object 
         * and sets the default exit folder.
         * 
         * @see Ciano.Utils.StringUtil#is_empty(string)
         * @see Ciano.Constants
         */
static CianoServicesSettings*
ciano_services_settings_construct (GType object_type)
{
	CianoServicesSettings * self = NULL;
	const gchar* _tmp0_;
	self = (CianoServicesSettings*) granite_services_settings_construct (object_type, CIANO_CONFIGS_CONSTANTS_ID);
	_tmp0_ = self->priv->_output_folder;
	if (ciano_utils_string_util_is_empty (_tmp0_)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_strconcat (_tmp1_, CIANO_CONFIGS_CONSTANTS_DIRECTORY_CIANO, NULL);
		_tmp3_ = _tmp2_;
		ciano_services_settings_set_output_folder (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	return self;
}

static CianoServicesSettings*
ciano_services_settings_new (void)
{
	return ciano_services_settings_construct (CIANO_SERVICES_TYPE_SETTINGS);
}

/**
         * Returns a single instance of this class.
         * 
         * @return {@code Settings}
         */
CianoServicesSettings*
ciano_services_settings_get_instance (void)
{
	CianoServicesSettings* _tmp0_;
	CianoServicesSettings* _tmp2_;
	CianoServicesSettings* result;
	_tmp0_ = ciano_services_settings_instance;
	if (_tmp0_ == NULL) {
		CianoServicesSettings* _tmp1_;
		_tmp1_ = ciano_services_settings_new ();
		_g_object_unref0 (ciano_services_settings_instance);
		ciano_services_settings_instance = _tmp1_;
	}
	_tmp2_ = ciano_services_settings_instance;
	result = _tmp2_;
	return result;
}

gint
ciano_services_settings_get_window_x (CianoServicesSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_x;
	return result;
}

void
ciano_services_settings_set_window_x (CianoServicesSettings* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_window_x (self);
	if (old_value != value) {
		self->priv->_window_x = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY]);
	}
}

gint
ciano_services_settings_get_window_y (CianoServicesSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_y;
	return result;
}

void
ciano_services_settings_set_window_y (CianoServicesSettings* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_window_y (self);
	if (old_value != value) {
		self->priv->_window_y = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY]);
	}
}

const gchar*
ciano_services_settings_get_output_folder (CianoServicesSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_output_folder;
	result = _tmp0_;
	return result;
}

void
ciano_services_settings_set_output_folder (CianoServicesSettings* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_output_folder (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_output_folder);
		self->priv->_output_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY]);
	}
}

gboolean
ciano_services_settings_get_output_source_file_folder (CianoServicesSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_output_source_file_folder;
	return result;
}

void
ciano_services_settings_set_output_source_file_folder (CianoServicesSettings* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_output_source_file_folder (self);
	if (old_value != value) {
		self->priv->_output_source_file_folder = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY]);
	}
}

gboolean
ciano_services_settings_get_shutdown_computer (CianoServicesSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_shutdown_computer;
	return result;
}

void
ciano_services_settings_set_shutdown_computer (CianoServicesSettings* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_shutdown_computer (self);
	if (old_value != value) {
		self->priv->_shutdown_computer = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY]);
	}
}

gboolean
ciano_services_settings_get_open_output_folder (CianoServicesSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_open_output_folder;
	return result;
}

void
ciano_services_settings_set_open_output_folder (CianoServicesSettings* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_open_output_folder (self);
	if (old_value != value) {
		self->priv->_open_output_folder = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY]);
	}
}

gboolean
ciano_services_settings_get_complete_notify (CianoServicesSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_complete_notify;
	return result;
}

void
ciano_services_settings_set_complete_notify (CianoServicesSettings* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_complete_notify (self);
	if (old_value != value) {
		self->priv->_complete_notify = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY]);
	}
}

gboolean
ciano_services_settings_get_error_notify (CianoServicesSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_notify;
	return result;
}

void
ciano_services_settings_set_error_notify (CianoServicesSettings* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ciano_services_settings_get_error_notify (self);
	if (old_value != value) {
		self->priv->_error_notify = value;
		g_object_notify_by_pspec ((GObject *) self, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY]);
	}
}

static void
ciano_services_settings_class_init (CianoServicesSettingsClass * klass,
                                    gpointer klass_data)
{
	ciano_services_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CianoServicesSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_ciano_services_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ciano_services_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = ciano_services_settings_finalize;
	/**
	         * This property will represent the location x of the screen.
	         * Variable of type {@code int} as declared.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY] = g_param_spec_int ("window-x", "window-x", "window-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property will represent the location y of the screen.
	         * Variable of type {@code int} as declared.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY] = g_param_spec_int ("window-y", "window-y", "window-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property will receive the name of the output folder which
	         * can be altered through dialog preferences.
	         * Variable of type {@code string} as declared.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY] = g_param_spec_string ("output-folder", "output-folder", "output-folder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property {@code bool} corresponds to {@code true} if option
	         * save the converted files to the same folder "is active on the 
	         * dialog Preferences. If the option is not activated the value of the same
	         * will be {@code false} and the application will use {@code output_folder} 
	         * as the standard output.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY] = g_param_spec_boolean ("output-source-file-folder", "output-source-file-folder", "output-source-file-folder", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property {@code bool} corresponds to {@code true} if option
	         * "shutdown computer" in dialog preferences is enabled the computer will
	         * shutdown when all conversions are finished. 
	         * Otherwise the value will be {@code false}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY] = g_param_spec_boolean ("shutdown-computer", "shutdown-computer", "shutdown-computer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property {@code bool} corresponds to {@code true} if
	         * the "open output folder" option in dialog preferences is enabled by opening
	         * an output folder after completing all conversions. Otherwise,
	         * the value will be {@code false}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY] = g_param_spec_boolean ("open-output-folder", "open-output-folder", "open-output-folder", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property {@code bool} corresponds to {@code true} if 
	         * the "complete notify" option in the dialog preferences is enabled by
	         * displaying a notification at the end of the conversion.
	         * Otherwise, the value will be {@code false}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY] = g_param_spec_boolean ("complete-notify", "complete-notify", "complete-notify", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * This property {@code bool} corresponds to {@code true} if
	         * the "complete notify" option in the dialog preferences is enabled
	         * by displaying a notification when there is a conversion error. 
	         * Otherwise, the value will be {@code false}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY, ciano_services_settings_properties[CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY] = g_param_spec_boolean ("error-notify", "error-notify", "error-notify", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
ciano_services_settings_instance_init (CianoServicesSettings * self,
                                       gpointer klass)
{
	self->priv = ciano_services_settings_get_instance_private (self);
}

static void
ciano_services_settings_finalize (GObject * obj)
{
	CianoServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettings);
	_g_free0 (self->priv->_output_folder);
	G_OBJECT_CLASS (ciano_services_settings_parent_class)->finalize (obj);
}

/**
     * The {@code Settings} class is responsible for defining all 
     * the texts that are displayed in the application and must be translated.
     *
     * @see Granite.Services.Settings
     * @since 0.1.0
     */
static GType
ciano_services_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CianoServicesSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_services_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoServicesSettings), 0, (GInstanceInitFunc) ciano_services_settings_instance_init, NULL };
	GType ciano_services_settings_type_id;
	ciano_services_settings_type_id = g_type_register_static (GRANITE_SERVICES_TYPE_SETTINGS, "CianoServicesSettings", &g_define_type_info, 0);
	CianoServicesSettings_private_offset = g_type_add_instance_private (ciano_services_settings_type_id, sizeof (CianoServicesSettingsPrivate));
	return ciano_services_settings_type_id;
}

GType
ciano_services_settings_get_type (void)
{
	static volatile gsize ciano_services_settings_type_id__once = 0;
	if (g_once_init_enter (&ciano_services_settings_type_id__once)) {
		GType ciano_services_settings_type_id;
		ciano_services_settings_type_id = ciano_services_settings_get_type_once ();
		g_once_init_leave (&ciano_services_settings_type_id__once, ciano_services_settings_type_id);
	}
	return ciano_services_settings_type_id__once;
}

static void
_vala_ciano_services_settings_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	CianoServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettings);
	switch (property_id) {
		case CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY:
		g_value_set_int (value, ciano_services_settings_get_window_x (self));
		break;
		case CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY:
		g_value_set_int (value, ciano_services_settings_get_window_y (self));
		break;
		case CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY:
		g_value_set_string (value, ciano_services_settings_get_output_folder (self));
		break;
		case CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY:
		g_value_set_boolean (value, ciano_services_settings_get_output_source_file_folder (self));
		break;
		case CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY:
		g_value_set_boolean (value, ciano_services_settings_get_shutdown_computer (self));
		break;
		case CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY:
		g_value_set_boolean (value, ciano_services_settings_get_open_output_folder (self));
		break;
		case CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY:
		g_value_set_boolean (value, ciano_services_settings_get_complete_notify (self));
		break;
		case CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY:
		g_value_set_boolean (value, ciano_services_settings_get_error_notify (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ciano_services_settings_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	CianoServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CIANO_SERVICES_TYPE_SETTINGS, CianoServicesSettings);
	switch (property_id) {
		case CIANO_SERVICES_SETTINGS_WINDOW_X_PROPERTY:
		ciano_services_settings_set_window_x (self, g_value_get_int (value));
		break;
		case CIANO_SERVICES_SETTINGS_WINDOW_Y_PROPERTY:
		ciano_services_settings_set_window_y (self, g_value_get_int (value));
		break;
		case CIANO_SERVICES_SETTINGS_OUTPUT_FOLDER_PROPERTY:
		ciano_services_settings_set_output_folder (self, g_value_get_string (value));
		break;
		case CIANO_SERVICES_SETTINGS_OUTPUT_SOURCE_FILE_FOLDER_PROPERTY:
		ciano_services_settings_set_output_source_file_folder (self, g_value_get_boolean (value));
		break;
		case CIANO_SERVICES_SETTINGS_SHUTDOWN_COMPUTER_PROPERTY:
		ciano_services_settings_set_shutdown_computer (self, g_value_get_boolean (value));
		break;
		case CIANO_SERVICES_SETTINGS_OPEN_OUTPUT_FOLDER_PROPERTY:
		ciano_services_settings_set_open_output_folder (self, g_value_get_boolean (value));
		break;
		case CIANO_SERVICES_SETTINGS_COMPLETE_NOTIFY_PROPERTY:
		ciano_services_settings_set_complete_notify (self, g_value_get_boolean (value));
		break;
		case CIANO_SERVICES_SETTINGS_ERROR_NOTIFY_PROPERTY:
		ciano_services_settings_set_error_notify (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

