// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package bgp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new bgp API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new bgp API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new bgp API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for bgp API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetBgpPeers(params *GetBgpPeersParams, opts ...ClientOption) (*GetBgpPeersOK, error)

	GetBgpRoutePolicies(params *GetBgpRoutePoliciesParams, opts ...ClientOption) (*GetBgpRoutePoliciesOK, error)

	GetBgpRoutes(params *GetBgpRoutesParams, opts ...ClientOption) (*GetBgpRoutesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	GetBgpPeers lists operational state of b g p peers

	Retrieves current operational state of BGP peers created by

Cilium BGP virtual router. This includes session state, uptime,
information per address family, etc.
*/
func (a *Client) GetBgpPeers(params *GetBgpPeersParams, opts ...ClientOption) (*GetBgpPeersOK, error) {
	// NOTE: parameters are not validated before sending
	if params == nil {
		params = NewGetBgpPeersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetBgpPeers",
		Method:             "GET",
		PathPattern:        "/bgp/peers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetBgpPeersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}
	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}

	// only one success response has to be checked
	success, ok := result.(*GetBgpPeersOK)
	if ok {
		return success, nil
	}

	// unexpected success response.

	// no default response is defined.
	//
	// safeguard: normally, in the absence of a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetBgpPeers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetBgpRoutePolicies lists b g p route policies configured in b g p control plane

Retrieves route policies from BGP Control Plane.
*/
func (a *Client) GetBgpRoutePolicies(params *GetBgpRoutePoliciesParams, opts ...ClientOption) (*GetBgpRoutePoliciesOK, error) {
	// NOTE: parameters are not validated before sending
	if params == nil {
		params = NewGetBgpRoutePoliciesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetBgpRoutePolicies",
		Method:             "GET",
		PathPattern:        "/bgp/route-policies",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetBgpRoutePoliciesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}
	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}

	// only one success response has to be checked
	success, ok := result.(*GetBgpRoutePoliciesOK)
	if ok {
		return success, nil
	}

	// unexpected success response.

	// no default response is defined.
	//
	// safeguard: normally, in the absence of a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetBgpRoutePolicies: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetBgpRoutes lists b g p routes from b g p control plane r i b

Retrieves routes from BGP Control Plane RIB filtered by parameters you specify
*/
func (a *Client) GetBgpRoutes(params *GetBgpRoutesParams, opts ...ClientOption) (*GetBgpRoutesOK, error) {
	// NOTE: parameters are not validated before sending
	if params == nil {
		params = NewGetBgpRoutesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetBgpRoutes",
		Method:             "GET",
		PathPattern:        "/bgp/routes",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetBgpRoutesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}
	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}

	// only one success response has to be checked
	success, ok := result.(*GetBgpRoutesOK)
	if ok {
		return success, nil
	}

	// unexpected success response.

	// no default response is defined.
	//
	// safeguard: normally, in the absence of a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetBgpRoutes: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
