/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
)

// ACMEAuthorizationApplyConfiguration represents a declarative configuration of the ACMEAuthorization type for use
// with apply.
type ACMEAuthorizationApplyConfiguration struct {
	URL          *string                           `json:"url,omitempty"`
	Identifier   *string                           `json:"identifier,omitempty"`
	Wildcard     *bool                             `json:"wildcard,omitempty"`
	InitialState *acmev1.State                     `json:"initialState,omitempty"`
	Challenges   []ACMEChallengeApplyConfiguration `json:"challenges,omitempty"`
}

// ACMEAuthorizationApplyConfiguration constructs a declarative configuration of the ACMEAuthorization type for use with
// apply.
func ACMEAuthorization() *ACMEAuthorizationApplyConfiguration {
	return &ACMEAuthorizationApplyConfiguration{}
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *ACMEAuthorizationApplyConfiguration) WithURL(value string) *ACMEAuthorizationApplyConfiguration {
	b.URL = &value
	return b
}

// WithIdentifier sets the Identifier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Identifier field is set to the value of the last call.
func (b *ACMEAuthorizationApplyConfiguration) WithIdentifier(value string) *ACMEAuthorizationApplyConfiguration {
	b.Identifier = &value
	return b
}

// WithWildcard sets the Wildcard field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Wildcard field is set to the value of the last call.
func (b *ACMEAuthorizationApplyConfiguration) WithWildcard(value bool) *ACMEAuthorizationApplyConfiguration {
	b.Wildcard = &value
	return b
}

// WithInitialState sets the InitialState field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the InitialState field is set to the value of the last call.
func (b *ACMEAuthorizationApplyConfiguration) WithInitialState(value acmev1.State) *ACMEAuthorizationApplyConfiguration {
	b.InitialState = &value
	return b
}

// WithChallenges adds the given value to the Challenges field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Challenges field.
func (b *ACMEAuthorizationApplyConfiguration) WithChallenges(values ...*ACMEChallengeApplyConfiguration) *ACMEAuthorizationApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithChallenges")
		}
		b.Challenges = append(b.Challenges, *values[i])
	}
	return b
}
