/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__SEP_H
#define CVC4__OPTIONS__SEP_H

#include "options/options.h"




#define CVC4_OPTIONS__SEP__FOR_OPTION_HOLDER \
  sepCheckNeg__option_t::type sepCheckNeg;\
  bool sepCheckNeg__setByUser__; \
  sepChildRefine__option_t::type sepChildRefine;\
  bool sepChildRefine__setByUser__; \
  sepDisequalC__option_t::type sepDisequalC;\
  bool sepDisequalC__setByUser__; \
  sepExp__option_t::type sepExp;\
  bool sepExp__setByUser__; \
  sepMinimalRefine__option_t::type sepMinimalRefine;\
  bool sepMinimalRefine__setByUser__; \
  sepPreSkolemEmp__option_t::type sepPreSkolemEmp;\
  bool sepPreSkolemEmp__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC sepCheckNeg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepCheckNeg CVC4_PUBLIC;
extern struct CVC4_PUBLIC sepChildRefine__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepChildRefine CVC4_PUBLIC;
extern struct CVC4_PUBLIC sepDisequalC__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepDisequalC CVC4_PUBLIC;
extern struct CVC4_PUBLIC sepExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC sepMinimalRefine__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepMinimalRefine CVC4_PUBLIC;
extern struct CVC4_PUBLIC sepPreSkolemEmp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sepPreSkolemEmp CVC4_PUBLIC;

}  // namespace options

template <> const options::sepCheckNeg__option_t::type& Options::operator[](
    options::sepCheckNeg__option_t) const;
template <> bool Options::wasSetByUser(options::sepCheckNeg__option_t) const;
template <> void Options::assignBool(
    options::sepCheckNeg__option_t,
    std::string option,
    bool value);
template <> const options::sepChildRefine__option_t::type& Options::operator[](
    options::sepChildRefine__option_t) const;
template <> bool Options::wasSetByUser(options::sepChildRefine__option_t) const;
template <> void Options::assignBool(
    options::sepChildRefine__option_t,
    std::string option,
    bool value);
template <> const options::sepDisequalC__option_t::type& Options::operator[](
    options::sepDisequalC__option_t) const;
template <> bool Options::wasSetByUser(options::sepDisequalC__option_t) const;
template <> void Options::assignBool(
    options::sepDisequalC__option_t,
    std::string option,
    bool value);
template <> const options::sepExp__option_t::type& Options::operator[](
    options::sepExp__option_t) const;
template <> bool Options::wasSetByUser(options::sepExp__option_t) const;
template <> void Options::assignBool(
    options::sepExp__option_t,
    std::string option,
    bool value);
template <> const options::sepMinimalRefine__option_t::type& Options::operator[](
    options::sepMinimalRefine__option_t) const;
template <> bool Options::wasSetByUser(options::sepMinimalRefine__option_t) const;
template <> void Options::assignBool(
    options::sepMinimalRefine__option_t,
    std::string option,
    bool value);
template <> const options::sepPreSkolemEmp__option_t::type& Options::operator[](
    options::sepPreSkolemEmp__option_t) const;
template <> bool Options::wasSetByUser(options::sepPreSkolemEmp__option_t) const;
template <> void Options::assignBool(
    options::sepPreSkolemEmp__option_t,
    std::string option,
    bool value);


namespace options {

inline sepCheckNeg__option_t::type sepCheckNeg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepCheckNeg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sepChildRefine__option_t::type sepChildRefine__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepChildRefine__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sepDisequalC__option_t::type sepDisequalC__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepDisequalC__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sepExp__option_t::type sepExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sepMinimalRefine__option_t::type sepMinimalRefine__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepMinimalRefine__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sepPreSkolemEmp__option_t::type sepPreSkolemEmp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sepPreSkolemEmp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__SEP_H */
