#ifndef _ECTOR_RENDERER_EO_H_
#define _ECTOR_RENDERER_EO_H_

#ifndef _ECTOR_RENDERER_EO_CLASS_TYPE
#define _ECTOR_RENDERER_EO_CLASS_TYPE

typedef Eo Ector_Renderer;

#endif

#ifndef _ECTOR_RENDERER_EO_TYPES
#define _ECTOR_RENDERER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Ector renderer abstract interface
 *
 * @ingroup Ector_Renderer
 */
#define ECTOR_RENDERER_CLASS ector_renderer_class_get()

ECTOR_API ECTOR_API_WEAK const Efl_Class *ector_renderer_class_get(void) EINA_CONST;

/**
 * @brief Surface associated with this renderer
 *
 * Do not use.
 *
 * @param[in] obj The object.
 * @param[in] s Associated surface
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_surface_set(Eo *obj, Ector_Surface *s);

/**
 * @brief Surface associated with this renderer
 *
 * Gets the surface associated with this renderer. Can not be set.
 *
 * @param[in] obj The object.
 *
 * @return Associated surface
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK Ector_Surface *ector_renderer_surface_get(const Eo *obj);

/**
 * @brief Transformation property
 *
 * @param[in] obj The object.
 * @param[in] m Transformation matrix
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_transformation_set(Eo *obj, const Eina_Matrix3 *m);

/**
 * @brief Transformation property
 *
 * @param[in] obj The object.
 *
 * @return Transformation matrix
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK const Eina_Matrix3 *ector_renderer_transformation_get(const Eo *obj);

/**
 * @brief Renderer origin
 *
 * @param[in] obj The object.
 * @param[in] x X coordinate
 * @param[in] y Y coordinate
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_origin_set(Eo *obj, double x, double y);

/**
 * @brief Renderer origin
 *
 * @param[in] obj The object.
 * @param[out] x X coordinate
 * @param[out] y Y coordinate
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_origin_get(const Eo *obj, double *x, double *y);

/**
 * @brief The given Ector renderer can be visible or invisible.
 *
 * @param[in] obj The object.
 * @param[in] v @c true to make the object visible, @c false otherwise
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_visibility_set(Eo *obj, Eina_Bool v);

/**
 * @brief The given Ector renderer can be visible or invisible.
 *
 * @param[in] obj The object.
 *
 * @return @c true to make the object visible, @c false otherwise
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_renderer_visibility_get(const Eo *obj);

/**
 * @brief Retrieves the general/main color of the given Ector renderer.
 *
 * Retrieves the main color's RGB component (and alpha channel) values, which
 * range from 0 to 255. For the alpha channel, which defines the object's
 * transparency level, 0 means totally transparent, while 255 means opaque.
 * These color values are premultiplied by the alpha value.
 *
 * Use null pointers on the components you're not interested in, they'll be
 * ignored by the function.
 *
 * @param[in] obj The object.
 * @param[in] r The red component of the given color.
 * @param[in] g The green component of the given color.
 * @param[in] b The blue component of the given color.
 * @param[in] a The alpha component of the given color.
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_color_set(Eo *obj, int r, int g, int b, int a);

/**
 * @brief Retrieves the general/main color of the given Ector renderer.
 *
 * Retrieves the main color's RGB component (and alpha channel) values, which
 * range from 0 to 255. For the alpha channel, which defines the object's
 * transparency level, 0 means totally transparent, while 255 means opaque.
 * These color values are premultiplied by the alpha value.
 *
 * Use null pointers on the components you're not interested in, they'll be
 * ignored by the function.
 *
 * @param[in] obj The object.
 * @param[out] r The red component of the given color.
 * @param[out] g The green component of the given color.
 * @param[out] b The blue component of the given color.
 * @param[out] a The alpha component of the given color.
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_color_get(const Eo *obj, int *r, int *g, int *b, int *a);

/**
 * @brief Cyclic redundancy check
 *
 * @param[in] obj The object.
 *
 * @return CRC value
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK unsigned int ector_renderer_crc_get(const Eo *obj);

/**
 * @brief Set Composite Buffer to this Renderer
 *
 * @param[in] obj The object.
 * @param[in] comp Composite Buffer
 * @param[in] method Composite method
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK void ector_renderer_comp_method_set(Eo *obj, Ector_Buffer *comp, Efl_Gfx_Vg_Composite_Method method);

/**
 * @brief Actual draw operation
 *
 * @param[in] obj The object.
 * @param[in] op Renderer operation
 * @param[in] clips Array of @ref Eina_Rect clip
 * @param[in] mul_col Premultiplied color
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_renderer_draw(Eo *obj, Efl_Gfx_Render_Op op, Eina_Array *clips, unsigned int mul_col);

/**
 * @brief Prepare for rendering
 *
 * @param[in] obj The object.
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Ector_Renderer
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_renderer_prepare(Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
